/*
 * Decompiled with CFR 0.152.
 */
package com.yyon.grapplinghook.relocated.dev._100media.capabilitysyncer.core;

import com.yyon.grapplinghook.relocated.dev._100media.capabilitysyncer.core.BlockEntityCapability;
import com.yyon.grapplinghook.relocated.dev._100media.capabilitysyncer.core.GlobalLevelCapability;
import com.yyon.grapplinghook.relocated.dev._100media.capabilitysyncer.core.INBTSavable;
import com.yyon.grapplinghook.relocated.dev._100media.capabilitysyncer.core.ISyncableCapability;
import com.yyon.grapplinghook.relocated.dev._100media.capabilitysyncer.core.ItemStackCapability;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.core.Direction;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CapabilityAttacher {
    private static final List<Class<?>> capClasses;
    private static final List<BiConsumer<AttachCapabilitiesEvent<Entity>, Entity>> entityCapAttachers;
    private static final List<Function<Entity, LazyOptional<? extends ISyncableCapability>>> entityCapRetrievers;
    private static final List<BiConsumer<AttachCapabilitiesEvent<Level>, Level>> levelCapAttachers;
    private static final List<Function<Level, LazyOptional<? extends ISyncableCapability>>> levelCapRetrievers;
    private static final List<BiConsumer<AttachCapabilitiesEvent<BlockEntity>, BlockEntity>> blockEntityCapAttachers;
    private static final List<Function<BlockEntity, LazyOptional<? extends BlockEntityCapability>>> blockEntityCapRetrievers;
    private static final List<BiConsumer<AttachCapabilitiesEvent<ItemStack>, ItemStack>> itemStackCapAttachers;
    private static final List<Function<ItemStack, LazyOptional<? extends ItemStackCapability>>> itemStackCapRetrievers;
    private static final List<CloneConsumer> playerCapCloners;

    @NotNull
    protected static <T> Capability<T> getCapability(CapabilityToken<T> type) {
        return CapabilityManager.get(type);
    }

    protected static <T> void registerCapability(Class<T> capClass) {
        capClasses.add(capClass);
    }

    protected static <T extends GlobalLevelCapability> LazyOptional<T> getGlobalLevelCapability(Level level, Capability<T> capability) {
        if (level.f_46443_ || level.m_46472_() == Level.f_46428_) {
            return level.getCapability(capability);
        }
        MinecraftServer server = level.m_7654_();
        if (server == null) {
            return LazyOptional.empty();
        }
        return server.m_129783_().getCapability(capability);
    }

    protected static <C extends ISyncableCapability> void registerPlayerAttacher(BiConsumer<AttachCapabilitiesEvent<Entity>, Player> attacher, Function<Player, LazyOptional<C>> capRetriever, boolean copyOnDeath) {
        CapabilityAttacher.registerEntityAttacher(Player.class, attacher, capRetriever, copyOnDeath);
    }

    protected static <E extends Entity, C extends ISyncableCapability> void registerEntityAttacher(Class<E> entityClass, BiConsumer<AttachCapabilitiesEvent<Entity>, E> attacher, Function<E, LazyOptional<C>> capRetriever) {
        CapabilityAttacher.registerEntityAttacher(entityClass, attacher, capRetriever, false);
    }

    protected static <E extends Entity, C extends ISyncableCapability> void registerEntityAttacher(Class<E> entityClass, BiConsumer<AttachCapabilitiesEvent<Entity>, E> attacher, Function<E, LazyOptional<C>> capRetriever, boolean copyOnDeath) {
        entityCapAttachers.add((event, entity) -> {
            if (entityClass.isInstance(entity)) {
                attacher.accept((AttachCapabilitiesEvent<Entity>)event, (Object)entity);
            }
        });
        entityCapRetrievers.add(entity -> entityClass.isInstance(entity) ? (LazyOptional)capRetriever.apply(entity) : LazyOptional.empty());
        if (entityClass.isAssignableFrom(Player.class) || Player.class.isAssignableFrom(entityClass)) {
            playerCapCloners.add((oldPlayer, newPlayer, wasDeath) -> {
                if ((copyOnDeath || !wasDeath) && entityClass.isInstance(newPlayer) && entityClass.isInstance(oldPlayer)) {
                    ((LazyOptional)capRetriever.apply(oldPlayer)).ifPresent(oldCap -> ((LazyOptional)capRetriever.apply(newPlayer)).ifPresent(newCap -> newCap.copyFrom((ISyncableCapability)oldCap, wasDeath)));
                }
            });
        }
    }

    protected static <C extends ISyncableCapability> void registerLevelAttacher(BiConsumer<AttachCapabilitiesEvent<Level>, Level> attacher, Function<Level, LazyOptional<C>> capRetriever) {
        CapabilityAttacher.registerLevelAttacher(Level.class, attacher, capRetriever);
    }

    protected static <E extends Level, C extends ISyncableCapability> void registerLevelAttacher(Class<E> levelClass, BiConsumer<AttachCapabilitiesEvent<Level>, E> attacher, Function<E, LazyOptional<C>> capRetriever) {
        levelCapAttachers.add((event, level) -> {
            if (levelClass.isInstance(level)) {
                attacher.accept((AttachCapabilitiesEvent<Level>)event, (Object)level);
            }
        });
        levelCapRetrievers.add(level -> levelClass.isInstance(level) ? (LazyOptional)capRetriever.apply(level) : LazyOptional.empty());
    }

    protected static <C extends GlobalLevelCapability> void registerGlobalLevelAttacher(BiConsumer<AttachCapabilitiesEvent<Level>, Level> attacher, Function<Level, LazyOptional<C>> capRetriever) {
        levelCapAttachers.add((event, level) -> {
            if (level.f_46443_ || level.m_46472_() == Level.f_46428_) {
                attacher.accept((AttachCapabilitiesEvent<Level>)event, (Level)level);
            }
        });
        levelCapRetrievers.add(level -> {
            if (level.f_46443_) {
                return (LazyOptional)capRetriever.apply((Level)level);
            }
            MinecraftServer server = level.m_7654_();
            return server == null ? LazyOptional.empty() : (LazyOptional)capRetriever.apply((Level)server.m_129783_());
        });
    }

    protected static <C extends ItemStackCapability> void registerItemStackAttacher(BiConsumer<AttachCapabilitiesEvent<ItemStack>, ItemStack> attacher, Function<ItemStack, LazyOptional<C>> capRetriever) {
        itemStackCapAttachers.add(attacher);
        itemStackCapRetrievers.add(capRetriever::apply);
    }

    protected static <C extends BlockEntityCapability> void registerBlockEntityAttacher(BiConsumer<AttachCapabilitiesEvent<BlockEntity>, BlockEntity> attacher, Function<BlockEntity, LazyOptional<C>> capRetriever) {
        blockEntityCapAttachers.add(attacher);
        blockEntityCapRetrievers.add(capRetriever::apply);
    }

    protected static <I extends INBTSerializable<T>, T extends Tag> void genericAttachCapability(AttachCapabilitiesEvent<?> event, I impl, Capability<I> capability, ResourceLocation location) {
        CapabilityAttacher.genericAttachCapability(event, impl, capability, location, true);
    }

    protected static <I extends INBTSerializable<T>, T extends Tag> void genericAttachCapability(AttachCapabilitiesEvent<?> event, I impl, Capability<I> capability, ResourceLocation location, boolean save) {
        LazyOptional storage = LazyOptional.of(() -> impl);
        ICapabilityProvider provider = CapabilityAttacher.getProvider(impl, storage, capability, save);
        event.addCapability(location, provider);
    }

    protected static <I extends INBTSerializable<T>, T extends Tag> ICapabilityProvider getProvider(final I impl, final LazyOptional<I> storage, final Capability<I> capability, boolean save) {
        if (capability == null) {
            throw new NullPointerException();
        }
        return save ? new ICapabilitySerializable<T>(){

            @NotNull
            public <C> LazyOptional<C> getCapability(@NotNull Capability<C> cap, @Nullable Direction side) {
                return cap == capability ? storage.cast() : LazyOptional.empty();
            }

            public T serializeNBT() {
                return impl instanceof INBTSavable ? ((INBTSavable)impl).serializeNBT(true) : impl.serializeNBT();
            }

            public void deserializeNBT(T nbt) {
                if (impl instanceof INBTSavable) {
                    ((INBTSavable)impl).deserializeNBT(nbt, true);
                } else {
                    impl.deserializeNBT(nbt);
                }
            }
        } : new ICapabilityProvider(){

            @NotNull
            public <C> LazyOptional<C> getCapability(@NotNull Capability<C> cap, @Nullable Direction side) {
                return cap == capability ? storage.cast() : LazyOptional.empty();
            }
        };
    }

    private static void onRegisterCapabilities(RegisterCapabilitiesEvent event) {
        capClasses.forEach(arg_0 -> ((RegisterCapabilitiesEvent)event).register(arg_0));
    }

    private static void onAttachEntityCapability(AttachCapabilitiesEvent<Entity> event) {
        entityCapAttachers.forEach(attacher -> attacher.accept(event, (Entity)event.getObject()));
    }

    private static void onAttachItemStackCapability(AttachCapabilitiesEvent<ItemStack> event) {
        itemStackCapAttachers.forEach(attacher -> attacher.accept(event, (ItemStack)event.getObject()));
    }

    private static void onAttachBlockEntityCapability(AttachCapabilitiesEvent<BlockEntity> event) {
        blockEntityCapAttachers.forEach(attacher -> attacher.accept(event, (BlockEntity)event.getObject()));
    }

    private static void onAttachLevelCapability(AttachCapabilitiesEvent<Level> event) {
        levelCapAttachers.forEach(attacher -> attacher.accept(event, (Level)event.getObject()));
    }

    private static void onEntityJoinLevel(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            entityCapRetrievers.forEach(capRetriever -> ((LazyOptional)capRetriever.apply(player)).ifPresent(cap -> cap.sendUpdatePacketToPlayer(player)));
            levelCapRetrievers.forEach(capRetriever -> ((LazyOptional)capRetriever.apply(player.m_9236_())).ifPresent(cap -> cap.sendUpdatePacketToPlayer(player)));
        }
    }

    private static void onPlayerStartTracking(PlayerEvent.StartTracking event) {
        ServerPlayer currentPlayer = (ServerPlayer)event.getEntity();
        entityCapRetrievers.forEach(capRetriever -> ((LazyOptional)capRetriever.apply(event.getTarget())).ifPresent(cap -> cap.sendUpdatePacketToPlayer(currentPlayer)));
    }

    private static void onPlayerClone(PlayerEvent.Clone event) {
        Player oldPlayer = event.getOriginal();
        Player newPlayer = event.getEntity();
        oldPlayer.reviveCaps();
        playerCapCloners.forEach(capCloner -> capCloner.accept(oldPlayer, newPlayer, event.isWasDeath()));
    }

    static {
        IEventBus modBus;
        MinecraftForge.EVENT_BUS.addGenericListener(Entity.class, CapabilityAttacher::onAttachEntityCapability);
        MinecraftForge.EVENT_BUS.addGenericListener(ItemStack.class, CapabilityAttacher::onAttachItemStackCapability);
        MinecraftForge.EVENT_BUS.addGenericListener(Level.class, CapabilityAttacher::onAttachLevelCapability);
        MinecraftForge.EVENT_BUS.addGenericListener(BlockEntity.class, CapabilityAttacher::onAttachBlockEntityCapability);
        MinecraftForge.EVENT_BUS.addListener(CapabilityAttacher::onEntityJoinLevel);
        MinecraftForge.EVENT_BUS.addListener(CapabilityAttacher::onPlayerStartTracking);
        MinecraftForge.EVENT_BUS.addListener(CapabilityAttacher::onPlayerClone);
        FMLJavaModLoadingContext modLoadingContext = FMLJavaModLoadingContext.get();
        if (modLoadingContext == null) {
            ModContainer prevContainer = ModLoadingContext.get().getActiveContainer();
            ModLoadingContext.get().setActiveContainer((ModContainer)ModList.get().getModContainerById("forge").orElseThrow(() -> new IllegalStateException("Forge is not loaded")));
            modBus = FMLJavaModLoadingContext.get().getModEventBus();
            ModLoadingContext.get().setActiveContainer(prevContainer);
        } else {
            modBus = modLoadingContext.getModEventBus();
        }
        modBus.addListener(CapabilityAttacher::onRegisterCapabilities);
        capClasses = new ArrayList();
        entityCapAttachers = new ArrayList<BiConsumer<AttachCapabilitiesEvent<Entity>, Entity>>();
        entityCapRetrievers = new ArrayList<Function<Entity, LazyOptional<? extends ISyncableCapability>>>();
        levelCapAttachers = new ArrayList<BiConsumer<AttachCapabilitiesEvent<Level>, Level>>();
        levelCapRetrievers = new ArrayList<Function<Level, LazyOptional<? extends ISyncableCapability>>>();
        blockEntityCapAttachers = new ArrayList<BiConsumer<AttachCapabilitiesEvent<BlockEntity>, BlockEntity>>();
        blockEntityCapRetrievers = new ArrayList<Function<BlockEntity, LazyOptional<? extends BlockEntityCapability>>>();
        itemStackCapAttachers = new ArrayList<BiConsumer<AttachCapabilitiesEvent<ItemStack>, ItemStack>>();
        itemStackCapRetrievers = new ArrayList<Function<ItemStack, LazyOptional<? extends ItemStackCapability>>>();
        playerCapCloners = new ArrayList<CloneConsumer>();
    }

    private static interface CloneConsumer {
        public void accept(Player var1, Player var2, boolean var3);
    }
}

