/*
 * Decompiled with CFR 0.152.
 */
package com.yyon.grapplinghook.controllers;

import com.yyon.grapplinghook.client.ClientProxyInterface;
import com.yyon.grapplinghook.config.GrappleConfig;
import com.yyon.grapplinghook.controllers.GrappleController;
import com.yyon.grapplinghook.utils.GrappleCustomization;
import com.yyon.grapplinghook.utils.Vec;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class AirfrictionController
extends GrappleController {
    public double playerMovementMult = 0.5;
    public int ignoreGroundCounter = 0;
    public boolean wasSliding = false;
    public boolean wasWallrunning = false;
    public boolean wasRocket = false;
    public boolean firstTickSinceCreated = true;

    public AirfrictionController(int grapplehookEntityId, int entityId, Level world, Vec pos, int id, GrappleCustomization custom) {
        super(grapplehookEntityId, entityId, world, pos, id, custom);
    }

    @Override
    public void updatePlayerPos() {
        LivingEntity living;
        Entity entity = this.entity;
        if (entity == null) {
            return;
        }
        if (entity.m_20202_() != null) {
            this.unattach();
            this.updateServerPos();
            return;
        }
        if (entity instanceof LivingEntity && (living = (LivingEntity)entity).m_6147_()) {
            this.unattach();
            return;
        }
        Vec additionalmotion = new Vec(0.0, 0.0, 0.0);
        if (!(!GrappleConfig.getConf().other.dont_override_movement_in_air || entity.m_20096_() || this.wasSliding || this.wasWallrunning || this.wasRocket || this.firstTickSinceCreated)) {
            this.motion = Vec.motionVec(entity);
            this.unattach();
            return;
        }
        if (this.attached) {
            LivingEntity entityliving;
            boolean issliding = ClientProxyInterface.proxy.isSliding(entity, this.motion);
            if (issliding && !this.wasSliding) {
                this.playSlideSound();
            }
            if (this.ignoreGroundCounter <= 0) {
                this.normalGround(issliding);
                this.normalCollisions(issliding);
            }
            this.applyAirFriction();
            if (this.entity.m_20069_() || this.entity.m_20077_()) {
                this.unattach();
                return;
            }
            boolean doesrocket = false;
            if (this.custom != null && this.custom.rocket) {
                Vec rocket = this.rocket(entity);
                this.motion.add_ip(rocket);
                if (rocket.length() > 0.0) {
                    doesrocket = true;
                }
            }
            if (issliding) {
                this.applySlidingFriction();
            }
            boolean wallrun = this.applyWallrun();
            if (!issliding && !this.wasSliding) {
                if (wallrun) {
                    this.motion = this.motion.removeAlong(new Vec(0.0, 1.0, 0.0));
                    if (this.wallDirection != null) {
                        this.motion = this.motion.removeAlong(this.wallDirection);
                    }
                    Vec new_movement = this.playerMovement.changeLen(GrappleConfig.getConf().enchantments.wallrun.wallrun_speed * 1.5);
                    if (this.wallDirection != null) {
                        new_movement = new_movement.removeAlong(this.wallDirection);
                    }
                    if (new_movement.length() > GrappleConfig.getConf().enchantments.wallrun.wallrun_speed) {
                        new_movement.changeLen_ip(GrappleConfig.getConf().enchantments.wallrun.wallrun_speed);
                    }
                    Vec current_motion_along = this.motion.removeAlong(new Vec(0.0, 1.0, 0.0));
                    Vec new_motion_along = this.motion.add(new_movement).removeAlong(new Vec(0.0, 1.0, 0.0));
                    if (this.wallDirection != null) {
                        current_motion_along = current_motion_along.removeAlong(this.wallDirection);
                        new_motion_along = new_motion_along.removeAlong(this.wallDirection);
                    }
                    if (current_motion_along.length() <= GrappleConfig.getConf().enchantments.wallrun.wallrun_max_speed || current_motion_along.dot(new_movement) < 0.0) {
                        this.motion.add_ip(new_movement);
                        if (new_motion_along.length() > GrappleConfig.getConf().enchantments.wallrun.wallrun_max_speed) {
                            this.motion.changeLen_ip(GrappleConfig.getConf().enchantments.wallrun.wallrun_max_speed);
                        }
                    }
                    additionalmotion.add_ip(this.wallrunPressAgainstWall());
                } else {
                    double max_motion = GrappleConfig.getConf().other.airstrafe_max_speed;
                    double accel = GrappleConfig.getConf().other.airstrafe_acceleration;
                    Vec motion_horizontal = this.motion.removeAlong(new Vec(0.0, 1.0, 0.0));
                    double prev_motion = motion_horizontal.length();
                    Vec new_motion_horizontal = motion_horizontal.add(this.playerMovement.changeLen(accel));
                    double angle = motion_horizontal.angle(new_motion_horizontal);
                    if (new_motion_horizontal.length() > max_motion && new_motion_horizontal.length() > prev_motion) {
                        double ninety_deg = 1.5707963267948966;
                        double new_max_motion = max_motion;
                        if (angle < ninety_deg && prev_motion > max_motion) {
                            new_max_motion = prev_motion + (max_motion - prev_motion) * (angle / 1.5707963267948966);
                        }
                        new_motion_horizontal.changeLen_ip(new_max_motion);
                    }
                    this.motion.x = new_motion_horizontal.x;
                    this.motion.z = new_motion_horizontal.z;
                }
            }
            if (entity instanceof LivingEntity && (entityliving = (LivingEntity)entity).m_21255_()) {
                this.unattach();
            }
            Vec gravity = new Vec(0.0, -0.05, 0.0);
            if (!wallrun) {
                this.motion.add_ip(gravity);
            }
            Vec newmotion = this.motion.add(additionalmotion);
            newmotion.setMotion(entity);
            this.updateServerPos();
            if (entity.m_20096_() && !issliding && !wallrun) {
                if (!doesrocket) {
                    if (this.ignoreGroundCounter <= 0) {
                        this.unattach();
                    }
                } else {
                    this.motion = Vec.motionVec(entity);
                }
            }
            if (this.ignoreGroundCounter > 0) {
                --this.ignoreGroundCounter;
            }
            this.wasSliding = issliding;
            this.wasWallrunning = wallrun;
            this.wasRocket = doesrocket;
            this.firstTickSinceCreated = false;
        }
    }

    @Override
    public void receiveEnderLaunch(double x, double y, double z) {
        super.receiveEnderLaunch(x, y, z);
        this.ignoreGroundCounter = 2;
    }

    @Override
    public void slidingJump() {
        super.slidingJump();
        this.ignoreGroundCounter = 2;
    }

    public void playSlideSound() {
        ClientProxyInterface.proxy.playSlideSound(this.entity);
    }
}

