/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdlib.util.rendering;

import com.finderfeed.fdlib.systems.bedrock.models.FDModel;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Stack;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Timer;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.AxisAngle4f;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class FDRenderUtil {
    public static void renderCenteredScaledItemStack(GuiGraphics graphics, float x, float y, float scale, ItemStack itemStack) {
        PoseStack stack = RenderSystem.getModelViewStack();
        stack.m_85836_();
        float mfx = x / scale;
        float mfy = y / scale;
        stack.m_85841_(scale, scale, 1.0f);
        stack.m_252880_(mfx - 8.0f, mfy - 8.0f, 0.0f);
        RenderSystem.applyModelViewMatrix();
        graphics.m_280480_(itemStack, 0, 0);
        stack.m_85849_();
        RenderSystem.applyModelViewMatrix();
    }

    public static void renderScaledItemStack(GuiGraphics graphics, float x, float y, float scale, ItemStack itemStack) {
        PoseStack stack = RenderSystem.getModelViewStack();
        stack.m_85836_();
        float mfx = x / scale;
        float mfy = y / scale;
        stack.m_85841_(scale, scale, 1.0f);
        stack.m_252880_(mfx, mfy, 0.0f);
        RenderSystem.applyModelViewMatrix();
        graphics.m_280480_(itemStack, 0, 0);
        stack.m_85849_();
        RenderSystem.applyModelViewMatrix();
    }

    public static float tryGetPartialTickIgnorePause() {
        Timer timer = Minecraft.m_91087_().f_90991_;
        return timer.f_92518_;
    }

    public static void renderFDModelInScreen(PoseStack matrices, FDModel model, float x, float y, float rotX, float rotY, float rotZ, float scale, int light, int overlay, float r, float g, float b, float a, RenderType renderType) {
        matrices.m_85836_();
        VertexConsumer builder = Minecraft.m_91087_().m_91269_().m_110104_().m_6299_(renderType);
        matrices.m_252880_(x, y, 0.0f);
        matrices.m_252781_(new Quaternionf().rotationXYZ(rotX, rotY, rotZ));
        matrices.m_85841_(-scale, -scale, -scale);
        model.render(matrices, builder, light, overlay, r, g, b, a);
        Minecraft.m_91087_().m_91269_().m_110104_().m_173043_();
        matrices.m_85849_();
    }

    public static void renderFDModelInScreen(PoseStack matrices, FDModel model, float x, float y, float rotX, float rotY, float rotZ, float scale, int light, int overlay, RenderType renderType) {
        FDRenderUtil.renderFDModelInScreen(matrices, model, x, y, rotX, rotY, rotZ, scale, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f, renderType);
    }

    public static void renderFDModelInScreen(PoseStack matrices, FDModel model, float x, float y, float rotX, float rotY, float rotZ, float scale, RenderType renderType) {
        FDRenderUtil.renderFDModelInScreen(matrices, model, x, y, rotX, rotY, rotZ, scale, 0xF000F0, OverlayTexture.f_118083_, renderType);
    }

    public static void renderCenteredText(GuiGraphics graphics, float x, float y, float textScale, boolean drawShadow, String s, int color) {
        Font font = Minecraft.m_91087_().f_91062_;
        float w = (float)font.m_92895_(s) * textScale;
        FDRenderUtil.renderScaledText(graphics, s, x - w / 2.0f, y, textScale, drawShadow, color);
    }

    public static void renderFullyCenteredText(GuiGraphics graphics, float x, float y, int width, float textScale, boolean drawShadow, int color, Component component) {
        Font font = Minecraft.m_91087_().f_91062_;
        List sequences = font.m_92923_((FormattedText)component, width);
        int n = sequences.size();
        Objects.requireNonNull(font);
        float ySize = (float)(n * 9) * textScale;
        y -= ySize / 2.0f;
        for (int i = 0; i < sequences.size(); ++i) {
            FormattedCharSequence sequence = (FormattedCharSequence)sequences.get(i);
            float xp = x - (float)font.m_92724_(sequence) / 2.0f * textScale;
            Objects.requireNonNull(font);
            float yp = y + (float)(i * 9) * textScale;
            FDRenderUtil.renderScaledText(graphics, sequence, xp, yp, textScale, drawShadow, color);
        }
    }

    public static void applyMovementMatrixRotations(PoseStack matrices, Vec3 vec) {
        double angleY = Math.toDegrees(Math.atan2(vec.f_82479_, vec.f_82481_));
        double angleX = Math.toDegrees(Math.atan2(Math.sqrt(vec.f_82479_ * vec.f_82479_ + vec.f_82481_ * vec.f_82481_), vec.f_82480_));
        matrices.m_252781_(FDRenderUtil.rotationDegrees(FDRenderUtil.YP(), (float)angleY));
        matrices.m_252781_(FDRenderUtil.rotationDegrees(FDRenderUtil.XP(), (float)angleX));
    }

    public static void applyMovementMatrixRotations(Matrix4f matrices, Vec3 vec) {
        double angleY = Math.atan2(vec.f_82479_, vec.f_82481_);
        double angleX = Math.atan2(Math.sqrt(vec.f_82479_ * vec.f_82479_ + vec.f_82481_ * vec.f_82481_), vec.f_82480_);
        matrices.rotateY((float)angleY);
        matrices.rotateX((float)angleX);
    }

    public static void scissor(float x, float y, float width, float boxY) {
        Window window = Minecraft.m_91087_().m_91268_();
        double scale = window.m_85449_();
        int nx = (int)Math.round((double)x * scale);
        int ny = (int)Math.round((double)window.m_85442_() - (double)y * scale);
        int nBX = (int)Math.round((double)width * scale);
        int nBY = (int)Math.round((double)boxY * scale);
        RenderSystem.enableScissor((int)nx, (int)(ny - nBY), (int)nBX, (int)nBY);
    }

    public static List<String> splitStringByCharacter(String s, char c) {
        ArrayList<String> strings = new ArrayList<String>();
        int sBegin = 0;
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (ch != c) continue;
            strings.add(s.substring(sBegin, i + 1));
            sBegin = i + 1;
        }
        return strings;
    }

    public static void fill(PoseStack matrices, float x, float y, float xw, float yw, float r, float g, float b, float a) {
        Tesselator tesselator = RenderSystem.renderThreadTesselator();
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::m_172811_);
        BufferBuilder builder = tesselator.m_85915_();
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        Matrix4f m = matrices.m_85850_().m_252922_();
        builder.m_252986_(m, x, y + yw, 0.0f).m_85950_(r, g, b, a).m_5752_();
        builder.m_252986_(m, x + xw, y + yw, 0.0f).m_85950_(r, g, b, a).m_5752_();
        builder.m_252986_(m, x + xw, y, 0.0f).m_85950_(r, g, b, a).m_5752_();
        builder.m_252986_(m, x, y, 0.0f).m_85950_(r, g, b, a).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)builder.m_231175_());
    }

    public static void fill(PoseStack matrices, float x, float y, float xw, float yw, float r1, float g1, float b1, float a1, float r2, float g2, float b2, float a2, float r3, float g3, float b3, float a3, float r4, float g4, float b4, float a4) {
        Tesselator tesselator = RenderSystem.renderThreadTesselator();
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::m_172811_);
        BufferBuilder builder = tesselator.m_85915_();
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        Matrix4f m = matrices.m_85850_().m_252922_();
        builder.m_252986_(m, x, y + yw, 0.0f).m_85950_(r4, g4, b4, a4).m_5752_();
        builder.m_252986_(m, x + xw, y + yw, 0.0f).m_85950_(r3, g3, b3, a3).m_5752_();
        builder.m_252986_(m, x + xw, y, 0.0f).m_85950_(r2, g2, b2, a2).m_5752_();
        builder.m_252986_(m, x, y, 0.0f).m_85950_(r1, g1, b1, a1).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)builder.m_231175_());
    }

    public static void renderShader(PoseStack matrices, float x, float y, float xw, float yw, float r, float g, float b, float a, float xuvStretch, float yuvStretch) {
        Tesselator tesselator = RenderSystem.renderThreadTesselator();
        RenderSystem.enableBlend();
        BufferBuilder builder = tesselator.m_85915_();
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        Matrix4f m = matrices.m_85850_().m_252922_();
        float xuvs = 0.0f;
        float xuvend = xuvStretch;
        float yuvs = 0.0f;
        float yuvend = yuvStretch;
        builder.m_252986_(m, x, y + yw, 0.0f).m_7421_(xuvs, yuvend).m_85950_(r, g, b, a).m_5752_();
        builder.m_252986_(m, x + xw, y + yw, 0.0f).m_7421_(xuvend, yuvend).m_85950_(r, g, b, a).m_5752_();
        builder.m_252986_(m, x + xw, y, 0.0f).m_7421_(xuvend, yuvs).m_85950_(r, g, b, a).m_5752_();
        builder.m_252986_(m, x, y, 0.0f).m_7421_(xuvs, yuvs).m_85950_(r, g, b, a).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)builder.m_231175_());
    }

    public static void fill(RenderType type, PoseStack matrices, float x, float y, float xw, float yw, float r, float g, float b, float a) {
        MultiBufferSource.BufferSource source = Minecraft.m_91087_().m_91269_().m_110104_();
        RenderSystem.enableBlend();
        VertexConsumer builder = source.m_6299_(type);
        Matrix4f m = matrices.m_85850_().m_252922_();
        builder.m_252986_(m, x, y + yw, 0.0f).m_85950_(r, g, b, a).m_5752_();
        builder.m_252986_(m, x + xw, y + yw, 0.0f).m_85950_(r, g, b, a).m_5752_();
        builder.m_252986_(m, x + xw, y, 0.0f).m_85950_(r, g, b, a).m_5752_();
        builder.m_252986_(m, x, y, 0.0f).m_85950_(r, g, b, a).m_5752_();
        source.m_109912_(type);
    }

    public static void fill(RenderType type, PoseStack matrices, float x, float y, float xw, float yw, float r1, float g1, float b1, float a1, float r2, float g2, float b2, float a2, float r3, float g3, float b3, float a3, float r4, float g4, float b4, float a4) {
        MultiBufferSource.BufferSource source = Minecraft.m_91087_().m_91269_().m_110104_();
        RenderSystem.enableBlend();
        VertexConsumer builder = source.m_6299_(type);
        Matrix4f m = matrices.m_85850_().m_252922_();
        builder.m_252986_(m, x, y + yw, 0.0f).m_85950_(r4, g4, b4, a4).m_5752_();
        builder.m_252986_(m, x + xw, y + yw, 0.0f).m_85950_(r3, g3, b3, a3).m_5752_();
        builder.m_252986_(m, x + xw, y, 0.0f).m_85950_(r2, g2, b2, a2).m_5752_();
        builder.m_252986_(m, x, y, 0.0f).m_85950_(r1, g1, b1, a1).m_5752_();
        source.m_109912_(type);
    }

    public static void renderScrollBar(PoseStack matrices, float x, float y, float scrollBarWidth, float scrollBarHeight, float scrollValue, float maxScrollValue, float r, float g, float b, float a, float scrollerR, float scrollerG, float scrollerB, float scrollerA) {
        FDRenderUtil.fill(matrices, x, y, scrollBarWidth, scrollBarHeight, r, g, b, a);
        float factor = (maxScrollValue + scrollBarHeight) / scrollBarHeight;
        float scrollBarYSize = scrollBarHeight / factor;
        float scrollBarYPos = scrollValue / factor;
        FDRenderUtil.fill(matrices, x, y + scrollBarYPos, scrollBarWidth, scrollBarYSize, scrollerR, scrollerG, scrollerB, scrollerA);
    }

    public static void renderScaledText(GuiGraphics graphics, String text, float x, float y, float scale, boolean drawShadow, int color) {
        if (scale != 0.0f) {
            Font font = Minecraft.m_91087_().f_91062_;
            PoseStack matrices = graphics.m_280168_();
            matrices.m_85836_();
            matrices.m_85841_(scale, scale, 1.0f);
            graphics.drawString(font, text, x *= 1.0f / scale, y *= 1.0f / scale, color, drawShadow);
            matrices.m_85849_();
        }
    }

    public static void renderScaledText(GuiGraphics graphics, Component text, float x, float y, float scale, boolean drawShadow, int color) {
        if (scale != 0.0f) {
            Font font = Minecraft.m_91087_().f_91062_;
            PoseStack matrices = graphics.m_280168_();
            matrices.m_85836_();
            matrices.m_85841_(scale, scale, 1.0f);
            matrices.m_252880_(x *= 1.0f / scale, y *= 1.0f / scale, 0.0f);
            graphics.m_280614_(font, text, 0, 0, color, drawShadow);
            matrices.m_85849_();
        }
    }

    public static void renderScaledText(GuiGraphics graphics, FormattedCharSequence text, float x, float y, float scale, boolean drawShadow, int color) {
        if (scale != 0.0f) {
            Font font = Minecraft.m_91087_().f_91062_;
            PoseStack matrices = graphics.m_280168_();
            matrices.m_85836_();
            matrices.m_85841_(scale, scale, 1.0f);
            matrices.m_252880_(x *= 1.0f / scale, y *= 1.0f / scale, 0.0f);
            graphics.m_280649_(font, text, 0, 0, color, drawShadow);
            matrices.m_85849_();
        }
    }

    public static void blitWithBlend(PoseStack matrices, float x, float y, float width, float height, float texPosX, float texPosY, float renderAmountX, float renderAmountY, float texWidth, float texHeight, float zOffset, float alpha) {
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::m_172820_);
        float u1 = texPosX / texWidth;
        float u2 = (texPosX + renderAmountX) / texWidth;
        float v1 = texPosY / texHeight;
        float v2 = (texPosY + renderAmountY) / texHeight;
        Matrix4f m = matrices.m_85850_().m_252922_();
        BufferBuilder vertex = Tesselator.m_85913_().m_85915_();
        vertex.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        vertex.m_252986_(m, x, y, zOffset).m_7421_(u1, v1).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_5752_();
        vertex.m_252986_(m, x, y + height, zOffset).m_7421_(u1, v2).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_5752_();
        vertex.m_252986_(m, x + width, y + height, zOffset).m_7421_(u2, v2).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_5752_();
        vertex.m_252986_(m, x + width, y, zOffset).m_7421_(u2, v1).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)vertex.m_231175_());
        RenderSystem.disableBlend();
    }

    public static void blitWithBlendCentered(PoseStack matrices, float x, float y, float width, float height, float texPosX, float texPosY, float renderAmountX, float renderAmountY, float texWidth, float texHeight, float zOffset, float alpha) {
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::m_172820_);
        float u1 = texPosX / texWidth;
        float u2 = (texPosX + renderAmountX) / texWidth;
        float v1 = texPosY / texHeight;
        float v2 = (texPosY + renderAmountY) / texHeight;
        Matrix4f m = matrices.m_85850_().m_252922_();
        BufferBuilder vertex = Tesselator.m_85913_().m_85915_();
        vertex.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        vertex.m_252986_(m, x - width / 2.0f, y - height / 2.0f, zOffset).m_7421_(u1, v1).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_5752_();
        vertex.m_252986_(m, x - width / 2.0f, y + height / 2.0f, zOffset).m_7421_(u1, v2).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_5752_();
        vertex.m_252986_(m, x + width / 2.0f, y + height / 2.0f, zOffset).m_7421_(u2, v2).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_5752_();
        vertex.m_252986_(m, x + width / 2.0f, y - height / 2.0f, zOffset).m_7421_(u2, v1).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)vertex.m_231175_());
        RenderSystem.disableBlend();
    }

    public static void blitWithBlendRgb(PoseStack matrices, float x, float y, float width, float height, float texPosX, float texPosY, float renderAmountX, float renderAmountY, float texWidth, float texHeight, float zOffset, float alpha, float r, float g, float b) {
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::m_172820_);
        float u1 = texPosX / texWidth;
        float u2 = (texPosX + renderAmountX) / texWidth;
        float v1 = texPosY / texHeight;
        float v2 = (texPosY + renderAmountY) / texHeight;
        Matrix4f m = matrices.m_85850_().m_252922_();
        BufferBuilder vertex = Tesselator.m_85913_().m_85915_();
        vertex.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        vertex.m_252986_(m, x, y, zOffset).m_7421_(u1, v1).m_85950_(r, g, b, alpha).m_5752_();
        vertex.m_252986_(m, x, y + height, zOffset).m_7421_(u1, v2).m_85950_(r, g, b, alpha).m_5752_();
        vertex.m_252986_(m, x + width, y + height, zOffset).m_7421_(u2, v2).m_85950_(r, g, b, alpha).m_5752_();
        vertex.m_252986_(m, x + width, y, zOffset).m_7421_(u2, v1).m_85950_(r, g, b, alpha).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)vertex.m_231175_());
        RenderSystem.disableBlend();
    }

    public static void bindTexture(ResourceLocation location) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)location);
    }

    public static boolean isMouseInBounds(float mx, float my, float x, float y, float wx, float wy) {
        return mx >= x && mx <= x + wx && my >= y && my <= y + wy;
    }

    public static Vector3f YP() {
        return new Vector3f(0.0f, 1.0f, 0.0f);
    }

    public static Vector3f YN() {
        return new Vector3f(0.0f, -1.0f, 0.0f);
    }

    public static Vector3f XP() {
        return new Vector3f(1.0f, 0.0f, 0.0f);
    }

    public static Vector3f XN() {
        return new Vector3f(-1.0f, 0.0f, 0.0f);
    }

    public static Vector3f ZP() {
        return new Vector3f(0.0f, 0.0f, 1.0f);
    }

    public static Vector3f ZN() {
        return new Vector3f(0.0f, 0.0f, -1.0f);
    }

    public static Quaternionf rotationDegrees(Vector3f rotation, float angle) {
        return new Quaternionf(new AxisAngle4f((float)Math.toRadians(angle), (Vector3fc)rotation));
    }

    public static class RenderTypes
    extends RenderType {
        public static final RenderType LIGHTNING_NO_CULL = RenderTypes.m_173215_((String)"lightning_no_cull", (VertexFormat)DefaultVertexFormat.f_85815_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)1536, (boolean)false, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_110661_(RenderStateShard.f_110110_).m_173292_(f_173091_).m_110687_(f_110114_).m_110685_(f_110136_).m_110675_(f_110127_).m_110691_(false));

        public RenderTypes(String p_173178_, VertexFormat p_173179_, VertexFormat.Mode p_173180_, int p_173181_, boolean p_173182_, boolean p_173183_, Runnable p_173184_, Runnable p_173185_) {
            super(p_173178_, p_173179_, p_173180_, p_173181_, p_173182_, p_173183_, p_173184_, p_173185_);
        }
    }

    public static class ParticleRenderTypesS {
        public static final Function<ResourceLocation, ParticleRenderType> TEXTURES_BLUR_ADDITIVE = Util.m_143827_(location -> new ParticleRenderType((ResourceLocation)location){
            final /* synthetic */ ResourceLocation val$location;
            {
                this.val$location = resourceLocation;
            }

            public void m_6294_(Tesselator tesselator) {
                tesselator.m_85914_();
                RenderSystem.disableBlend();
                RenderSystem.defaultBlendFunc();
                Minecraft.m_91087_().m_91097_().m_118506_(this.val$location).restoreLastBlurMipmap();
            }

            @Nullable
            public void m_6505_(BufferBuilder tesselator, TextureManager textureManager) {
                RenderSystem.enableBlend();
                RenderSystem.blendFunc((int)770, (int)1);
                RenderSystem.setShader(GameRenderer::m_172820_);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.val$location);
                Minecraft.m_91087_().m_91097_().m_118506_(this.val$location).setBlurMipmap(true, true);
                tesselator.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
            }
        });
        public static final Function<ResourceLocation, ParticleRenderType> TEXTURES_DEFAULT = Util.m_143827_(location -> new ParticleRenderType((ResourceLocation)location){
            final /* synthetic */ ResourceLocation val$location;
            {
                this.val$location = resourceLocation;
            }

            public void m_6294_(Tesselator tesselator) {
                tesselator.m_85914_();
                RenderSystem.disableBlend();
                RenderSystem.defaultBlendFunc();
            }

            @Nullable
            public void m_6505_(BufferBuilder tesselator, TextureManager textureManager) {
                RenderSystem.enableBlend();
                RenderSystem.blendFunc((int)770, (int)771);
                RenderSystem.setShader(GameRenderer::m_172820_);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.val$location);
                tesselator.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
            }
        });
    }

    public static class ParticleRenderTypes {
        public static final ParticleRenderType ADDITIVE_TRANSLUCENT = new ParticleRenderType(){

            @Nullable
            public void m_6505_(BufferBuilder tesselator, TextureManager textureManager) {
                if (Minecraft.m_91085_()) {
                    Minecraft.m_91087_().m_91385_().m_83947_(false);
                }
                RenderSystem.depthMask((boolean)false);
                RenderSystem.enableBlend();
                RenderSystem.blendFunc((int)770, (int)1);
                FDRenderUtil.bindTexture(TextureAtlas.f_118260_);
                tesselator.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85813_);
            }

            public void m_6294_(Tesselator tesselator) {
                tesselator.m_85914_();
                if (Minecraft.m_91085_()) {
                    Minecraft.m_91087_().f_91060_.m_109830_().m_83945_(Minecraft.m_91087_().m_91385_());
                    Minecraft.m_91087_().f_91060_.m_109830_().m_83947_(false);
                }
                RenderSystem.disableBlend();
                RenderSystem.depthMask((boolean)true);
            }

            public String toString() {
                return "solarcraft:additive";
            }
        };
        public static final ParticleRenderType NORMAL_TRANSLUCENT = new ParticleRenderType(){

            public void m_6294_(Tesselator tesselator) {
                tesselator.m_85914_();
                if (Minecraft.m_91085_()) {
                    Minecraft.m_91087_().f_91060_.m_109830_().m_83945_(Minecraft.m_91087_().m_91385_());
                    Minecraft.m_91087_().f_91060_.m_109830_().m_83947_(false);
                }
                RenderSystem.disableBlend();
                RenderSystem.depthMask((boolean)true);
            }

            @Nullable
            public void m_6505_(BufferBuilder tesselator, TextureManager p_107437_) {
                if (Minecraft.m_91085_()) {
                    Minecraft.m_91087_().m_91385_().m_83947_(false);
                }
                RenderSystem.depthMask((boolean)false);
                RenderSystem.enableBlend();
                RenderSystem.blendFunc((int)770, (int)771);
                FDRenderUtil.bindTexture(TextureAtlas.f_118260_);
                tesselator.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85813_);
            }
        };
    }

    public record Scissor(float x, float y, float x2, float y2) {
        private static Stack<Scissor> activeScissors = new Stack();

        public static void pushScissors(float x, float y, float wx, float wy) {
            Window window = Minecraft.m_91087_().m_91268_();
            Scissor previnst = activeScissors.isEmpty() ? new Scissor(0.0f, 0.0f, window.m_85445_(), window.m_85446_()) : activeScissors.peek();
            Scissor instance = Scissor.createScissors(previnst, x, y, wx, wy);
            activeScissors.push(instance);
            FDRenderUtil.scissor(instance.x, instance.y, instance.x2 - instance.x, instance.y2 - instance.y);
        }

        public static void pushScissors(PoseStack poseStack, float x, float y, float wx, float wy) {
            Matrix4f m = poseStack.m_85850_().m_252922_();
            Vector3f pos = m.transformPosition(x, y, 0.0f, new Vector3f());
            Scissor.pushScissors(pos.x, pos.y, wx, wy);
        }

        public static void popScissors() {
            if (activeScissors.isEmpty()) {
                RenderSystem.disableScissor();
            } else {
                activeScissors.pop();
                if (activeScissors.isEmpty()) {
                    RenderSystem.disableScissor();
                } else {
                    Scissor instance = activeScissors.peek();
                    FDRenderUtil.scissor(instance.x, instance.y, instance.x2 - instance.x, instance.y2 - instance.y);
                }
            }
        }

        private static Scissor createScissors(Scissor previousScissors, float x, float y, float wx, float wy) {
            float px = previousScissors.x;
            float py = previousScissors.y;
            float pxn = previousScissors.x2;
            float pyn = previousScissors.y2;
            float x2 = x + wx;
            float y2 = y + wy;
            x = Mth.m_14036_((float)x, (float)px, (float)pxn);
            y = Mth.m_14036_((float)y, (float)py, (float)pyn);
            x2 = Mth.m_14036_((float)x2, (float)px, (float)pxn);
            y2 = Mth.m_14036_((float)y2, (float)py, (float)pyn);
            return new Scissor(x, y, x2, y2);
        }
    }
}

