/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdlib.systems.shake;

import com.finderfeed.fdlib.systems.stream_codecs.NetworkCodec;

public class FDShakeData {
    public static final NetworkCodec<FDShakeData> STREAM_CODEC = NetworkCodec.composite(NetworkCodec.INT, v -> v.inTime, NetworkCodec.INT, v -> v.stayTime, NetworkCodec.INT, v -> v.outTime, NetworkCodec.FLOAT, v -> Float.valueOf(v.amplitude), NetworkCodec.FLOAT, v -> Float.valueOf(v.frequency), (inTime, stayTime, outTime, amplitude, frequency) -> {
        FDShakeData data = new FDShakeData();
        data.inTime = inTime;
        data.stayTime = stayTime;
        data.outTime = outTime;
        data.amplitude = amplitude.floatValue();
        data.frequency = frequency.floatValue();
        return data;
    });
    private int inTime = 2;
    private int stayTime = 2;
    private int outTime = 2;
    private float amplitude = 0.1f;
    private float frequency = 1.0f;

    public static Builder builder() {
        return new Builder();
    }

    public float getAmplitude() {
        return this.amplitude;
    }

    public int getOutTime() {
        return this.outTime;
    }

    public int getStayTime() {
        return this.stayTime;
    }

    public int getInTime() {
        return this.inTime;
    }

    public int duration() {
        return this.outTime + this.inTime + this.stayTime;
    }

    public float getFrequency() {
        return this.frequency;
    }

    public static class Builder {
        private FDShakeData data = new FDShakeData();

        public Builder inTime(int inTime) {
            this.data.inTime = inTime;
            return this;
        }

        public Builder outTime(int outTime) {
            this.data.outTime = outTime;
            return this;
        }

        public Builder stayTime(int stayTime) {
            this.data.stayTime = stayTime;
            return this;
        }

        public Builder amplitude(float amplitude) {
            this.data.amplitude = amplitude;
            return this;
        }

        public Builder frequency(float frequency) {
            this.data.frequency = frequency;
            return this;
        }

        public FDShakeData build() {
            return this.data;
        }
    }
}

