/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdlib.systems.screen.default_components.text;

import com.finderfeed.fdlib.systems.screen.FDEditorComponent;
import com.finderfeed.fdlib.systems.screen.FDScreen;
import com.finderfeed.fdlib.systems.screen.ValueComponent;
import com.finderfeed.fdlib.systems.screen.annotations.FDScale;
import com.finderfeed.fdlib.util.rendering.FDRenderUtil;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.util.Mth;

public abstract class FDTextBox<T>
extends ValueComponent<T> {
    private int firstLineId = 0;
    private int lastLineId = 0;
    private float scrollerWidth = 6.0f;
    private float scrollAmount = 0.0f;
    private boolean mouseSelecting = false;
    private boolean isSelecting;
    protected int selectionCursor = 0;
    protected int cursor = 0;
    protected StringBuilder value = new StringBuilder();
    protected List<Line> lines = new ArrayList<Line>(List.of(new Line(0, 0)));
    public float textOffsetLeft = 3.0f;
    public float textOffsetRight = 3.0f;
    public float textOffsetY = 3.0f;
    public float textScale = 1.0f;
    public Component emptyComponentText = Component.m_237119_();
    public String filter = "(.|\\n)*";

    public FDTextBox(FDScreen screen, String uniqueId, float x, float y, float width, float height) {
        super(screen, uniqueId, x, y, width, height);
    }

    @Override
    public void renderComponent(GuiGraphics graphics, float x, float y, float mx, float my, float partialTicks) {
        this.renderBackground(graphics, x, y, mx, my, partialTicks);
        this.renderText(graphics, x, y, mx, my, partialTicks);
        this.renderScrollBar(graphics, x, y, mx, my, partialTicks);
    }

    public void renderScrollBar(GuiGraphics graphics, float x, float y, float mx, float my, float partialTicks) {
        float scrollAmount = this.getMaxScrollAmount();
        if (scrollAmount != 0.0f) {
            float xp = x + this.getWidth() - this.scrollerWidth - this.textOffsetY;
            FDRenderUtil.renderScrollBar(graphics.m_280168_(), xp, y + this.getTextOffsetY(), this.scrollerWidth, this.getHeight() - this.getTextOffsetY() * 2.0f, this.scrollAmount, scrollAmount, 0.3f, 0.3f, 0.3f, 1.0f, 0.8f, 0.8f, 0.8f, 1.0f);
        }
    }

    public void renderText(GuiGraphics graphics, float x, float y, float mx, float my, float partialTicks) {
        String str = this.value.toString();
        x += this.textOffsetLeft;
        y += this.textOffsetY;
        Font font = Minecraft.m_91087_().f_91062_;
        Objects.requireNonNull(font);
        float lineHeight = 9.0f * this.textScale;
        int cursorLine = this.getLineAtCursor(this.cursor);
        this.firstLineId = -1;
        this.lastLineId = -1;
        for (int i = 0; i < this.lines.size(); ++i) {
            Line line = this.lines.get(i);
            String toRender = str.substring(line.begin, line.end);
            float f = i;
            Objects.requireNonNull(font);
            float offs = f * (9.0f * this.textScale);
            float yPos = y + offs - this.scrollAmount;
            float ys = yPos - y;
            if (ys < 0.0f) continue;
            if (this.firstLineId == -1) {
                this.firstLineId = i;
            }
            float f2 = this.getHeight() - this.getTextOffsetY();
            Objects.requireNonNull(font);
            if (ys > f2 - 9.0f * this.textScale) {
                if (this.lastLineId != -1) continue;
                this.lastLineId = i - 1;
                continue;
            }
            FDRenderUtil.renderScaledText(graphics, toRender.replace("\n", ""), x, yPos, this.textScale, false, 0xFFFFFF);
            if (!this.m_93696_() || i != cursorLine) continue;
            float alpha = Util.m_137550_() % 800L < 400L ? 0.0f : 1.0f;
            int index = this.cursor - line.begin;
            String w = toRender.substring(0, index);
            float sw = (float)font.m_92895_(w) * this.textScale;
            FDRenderUtil.fill(graphics.m_280168_(), x + sw, y + offs - this.scrollAmount, this.textScale, lineHeight, 1.0f, 1.0f, 1.0f, alpha);
        }
        if (this.lastLineId == -1) {
            this.lastLineId = this.lines.size() - 1;
        }
        if (this.isSelecting && this.selectionCursor != this.cursor) {
            int line2;
            int selectionLine = this.getLineAtCursor(this.selectionCursor);
            int line1 = Math.min(cursorLine, selectionLine);
            if (line1 != (line2 = Math.max(cursorLine, selectionLine))) {
                for (int i = line1; i <= line2; ++i) {
                    String ws;
                    Line line = this.lines.get(i);
                    int begin = line.begin;
                    int end = line.end;
                    float startOffset = 0.0f;
                    if (i == line1) {
                        begin = Math.min(this.cursor, this.selectionCursor);
                        ws = this.value.substring(line.begin, begin);
                        startOffset = (float)font.m_92895_(ws) * this.textScale;
                    } else if (i == line2) {
                        end = Math.max(this.cursor, this.selectionCursor);
                    }
                    ws = this.value.substring(begin, end);
                    float w = (float)font.m_92895_(ws) * this.textScale;
                    float yRenderPos = y + (float)i * lineHeight - this.scrollAmount;
                    if (yRenderPos - y < 0.0f) continue;
                    float f = this.getHeight() - this.getTextOffsetY();
                    Objects.requireNonNull(font);
                    if (yRenderPos - y > f - 9.0f * this.textScale) continue;
                    FDRenderUtil.fill(RenderType.m_285783_(), graphics.m_280168_(), x + startOffset, yRenderPos, w + this.textScale, lineHeight, 0.0f, 0.0f, 1.0f, 1.0f);
                }
            } else {
                Line line = this.lines.get(line1);
                int begin = Math.min(this.cursor, this.selectionCursor);
                int end = Math.max(this.cursor, this.selectionCursor);
                String ws = this.value.substring(begin, end);
                String ws2 = this.value.substring(line.begin, begin);
                float w = (float)font.m_92895_(ws) * this.textScale;
                float w2 = (float)font.m_92895_(ws2) * this.textScale;
                FDRenderUtil.fill(RenderType.m_285783_(), graphics.m_280168_(), x + w2, y + (float)line1 * lineHeight - this.scrollAmount, w + this.textScale, lineHeight, 0.0f, 0.0f, 1.0f, 1.0f);
            }
        }
    }

    public abstract void renderBackground(GuiGraphics var1, float var2, float var3, float var4, float var5, float var6);

    public void updateLines() {
        this.lines.clear();
        if (this.value.isEmpty()) {
            this.lines.add(new Line(0, 0));
            return;
        }
        int splitLength = this.textScale != 0.0f ? Math.round((this.getWidth() - this.getTextOffsetLeft() - this.getTextOffsetRight()) / this.textScale) : 0;
        Minecraft.m_91087_().f_91062_.m_92865_().m_92364_(this.value.toString(), splitLength, Style.f_131099_, true, (style, begin, end) -> this.lines.add(new Line(begin, end)));
        if (this.value.charAt(this.value.length() - 1) == '\n') {
            this.lines.add(new Line(this.value.length(), this.value.length()));
        }
    }

    public void moveCursorLeft() {
        this.cursor = Mth.m_14045_((int)(this.cursor - 1), (int)0, (int)this.value.length());
        if (!this.isSelecting) {
            this.selectionCursor = this.cursor;
        } else if (!Screen.m_96638_()) {
            this.isSelecting = false;
        }
        this.scrollToCursor(this.cursor);
    }

    public void moveCursorRight() {
        this.cursor = Mth.m_14045_((int)(this.cursor + 1), (int)0, (int)this.value.length());
        if (!this.isSelecting) {
            this.selectionCursor = this.cursor;
        } else if (!Screen.m_96638_()) {
            this.isSelecting = false;
        }
        this.scrollToCursor(this.cursor);
    }

    public void moveCursorUp() {
        int line = this.getLineAtCursor(this.cursor);
        if (line > 0) {
            Line prev = this.lines.get(line - 1);
            Line current = this.lines.get(line);
            int currentLocalPos = this.cursor - current.begin;
            int cdelta = prev.end - prev.begin;
            if (currentLocalPos > cdelta) {
                char endChar = this.value.charAt(prev.end - 1);
                this.cursor = prev.end;
                if (endChar == '\n') {
                    --this.cursor;
                }
            } else {
                this.cursor = prev.begin + currentLocalPos;
            }
        }
        if (!this.isSelecting) {
            this.selectionCursor = this.cursor;
        } else if (!Screen.m_96638_()) {
            this.isSelecting = false;
        }
        this.scrollToCursor(this.cursor);
    }

    public void moveCursorDown() {
        int line = this.getLineAtCursor(this.cursor);
        if (line < this.lines.size() - 1) {
            Line next = this.lines.get(line + 1);
            Line current = this.lines.get(line);
            int currentLocalPos = this.cursor - current.begin;
            int cdelta = next.end - next.begin;
            if (currentLocalPos > cdelta) {
                char endChar = this.value.charAt(next.end - 1);
                boolean flag = next.end != this.value.length() || line + 1 != this.lines.size() - 1;
                this.cursor = next.end;
                if (endChar == '\n' && flag) {
                    --this.cursor;
                }
            } else {
                this.cursor = next.begin + currentLocalPos;
            }
        }
        if (!this.isSelecting) {
            this.selectionCursor = this.cursor;
        } else if (!Screen.m_96638_()) {
            this.isSelecting = false;
        }
        this.scrollToCursor(this.cursor);
    }

    public int getLineAtCursor(int cursor) {
        for (int i = 0; i < this.lines.size(); ++i) {
            Line line = this.lines.get(i);
            if (cursor < line.begin || cursor >= line.end) continue;
            return i;
        }
        return this.lines.size() - 1;
    }

    public boolean removeCharacterAtCursor(boolean update) {
        if (!this.isSelecting) {
            int deletePos = this.cursor - 1;
            if (deletePos >= 0 && deletePos < this.value.length()) {
                this.value.deleteCharAt(deletePos);
                --this.cursor;
                this.updateLines();
                this.scrollToCursor(this.cursor);
                return true;
            }
        } else {
            int begin = Mth.m_14045_((int)Math.min(this.cursor, this.selectionCursor), (int)0, (int)this.value.length());
            int end = Mth.m_14045_((int)Math.max(this.cursor, this.selectionCursor), (int)0, (int)this.value.length());
            this.value.delete(begin, end);
            this.cursor = begin;
            if (update) {
                this.updateLines();
            }
            this.isSelecting = false;
            this.selectionCursor = this.cursor;
            this.scrollToCursor(this.cursor);
            return true;
        }
        return false;
    }

    public boolean insertText(String text) {
        text = text.replace("\r\n", "\n");
        text = text.replace("\r", "\n");
        if (!this.isSelecting) {
            String potentialValue = new StringBuilder(this.value).insert(this.cursor, text).toString();
            if (this.checkString(potentialValue)) {
                this.value = new StringBuilder(potentialValue);
                this.cursor += text.length();
                this.updateLines();
                this.scrollToCursor(this.cursor);
                return true;
            }
        } else {
            String cache = this.value.toString();
            this.removeCharacterAtCursor(false);
            this.value.insert(this.cursor, text);
            if (this.checkString(this.value.toString())) {
                this.updateLines();
                this.isSelecting = false;
                this.cursor += text.length();
                this.scrollToCursor(this.cursor);
                return true;
            }
            this.value = new StringBuilder(cache);
        }
        return false;
    }

    public boolean checkString(String check) {
        int i = 0;
        int substrAmount = 100;
        do {
            int end;
            String s;
            if ((s = check.substring(i, end = Mth.m_14045_((int)(i + substrAmount), (int)0, (int)check.length()))).matches(this.filter)) continue;
            return false;
        } while ((i += substrAmount) < check.length());
        return true;
    }

    public void setCursorAtMouse(float mx, float my) {
        if (!this.value.isEmpty()) {
            Font font = Minecraft.m_91087_().f_91062_;
            float x = mx - this.getTextOffsetLeft();
            float y = my - this.textOffsetY;
            float f = this.getHeight() / this.textScale - this.textOffsetY;
            Objects.requireNonNull(font);
            y = Mth.m_14036_((float)y, (float)0.0f, (float)(f - 9.0f * this.textScale)) + this.scrollAmount;
            Objects.requireNonNull(font);
            int lineId = (int)Math.floor(y / (9.0f * this.textScale));
            lineId = Mth.m_14045_((int)lineId, (int)0, (int)(this.lines.size() - 1));
            Line line = this.lines.get(lineId);
            if (line.begin != line.end) {
                float prevWidth = (float)font.m_92895_(this.value.substring(line.begin, line.begin + 1)) * this.textScale / 2.0f;
                for (int i = 0; i < line.end - line.begin; ++i) {
                    String ws = this.value.substring(line.begin, line.begin + i);
                    float width = (float)font.m_92895_(ws) * this.textScale;
                    if (x < width + Math.abs(width - prevWidth) / 2.0f) {
                        this.cursor = line.begin + i;
                        return;
                    }
                    prevWidth = width;
                }
            }
            this.cursor = line.end;
            if (lineId != this.lines.size() - 1) {
                --this.cursor;
            }
        } else {
            this.cursor = 0;
        }
    }

    public boolean scroll(int times) {
        Font font = Minecraft.m_91087_().f_91062_;
        Objects.requireNonNull(font);
        float amount = this.textScale * 9.0f * (float)times;
        float prev = this.scrollAmount;
        this.scrollAmount = Mth.m_14036_((float)(this.scrollAmount + amount), (float)0.0f, (float)this.getMaxScrollAmount());
        return prev != this.scrollAmount;
    }

    public void scrollToCursor(int cursor) {
        int lineId = this.getLineAtCursor(cursor);
        this.lastLineId = Mth.m_14045_((int)this.lastLineId, (int)0, (int)(this.lines.size() - 1));
        if (lineId > this.lastLineId) {
            this.scroll(lineId - this.lastLineId);
        } else if (lineId < this.firstLineId) {
            this.scroll(lineId - this.firstLineId);
        }
    }

    public boolean m_5534_(char character, int key) {
        return this.insertText(Character.toString(character));
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 340 || keyCode == 344) {
            if (!this.isSelecting) {
                this.selectionCursor = this.cursor;
                this.isSelecting = true;
            }
            return true;
        }
        switch (keyCode) {
            case 86: {
                if (Screen.m_96637_()) {
                    String s = Minecraft.m_91087_().f_91068_.m_90876_();
                    this.insertText(s);
                    return true;
                }
                return false;
            }
            case 67: {
                if (Screen.m_96637_() && !this.value.isEmpty() && this.cursor != this.selectionCursor) {
                    int begin = Math.min(this.cursor, this.selectionCursor);
                    int end = Math.max(this.cursor, this.selectionCursor);
                    String s = this.value.substring(begin, end);
                    Minecraft.m_91087_().f_91068_.m_90911_(s);
                    return true;
                }
                return false;
            }
            case 88: {
                if (Screen.m_96637_() && !this.value.isEmpty() && this.cursor != this.selectionCursor) {
                    int begin = Math.min(this.cursor, this.selectionCursor);
                    int end = Math.max(this.cursor, this.selectionCursor);
                    String s = this.value.substring(begin, end);
                    Minecraft.m_91087_().f_91068_.m_90911_(s);
                    this.removeCharacterAtCursor(true);
                    return true;
                }
                return false;
            }
            case 65: {
                if (Screen.m_96637_()) {
                    this.isSelecting = true;
                    this.cursor = this.lines.get((int)(this.lines.size() - 1)).end;
                    this.selectionCursor = 0;
                    return true;
                }
                return false;
            }
            case 263: {
                this.moveCursorLeft();
                return true;
            }
            case 262: {
                this.moveCursorRight();
                return true;
            }
            case 265: {
                this.moveCursorUp();
                return true;
            }
            case 264: {
                this.moveCursorDown();
                return true;
            }
            case 257: {
                this.insertText("\n");
                return true;
            }
            case 259: {
                this.removeCharacterAtCursor(true);
                return true;
            }
        }
        return false;
    }

    public boolean m_6050_(double mx, double my, double scrollY) {
        int scroll = (int)scrollY;
        return this.scroll(-scroll);
    }

    public boolean m_7920_(int key, int scanCode, int modifiers) {
        return super.m_7920_(key, scanCode, modifiers);
    }

    public boolean m_6375_(double mx, double my, int key) {
        if (key == 0) {
            this.setCursorAtMouse((float)mx, (float)my);
            this.isSelecting = false;
            this.mouseSelecting = true;
            this.selectionCursor = this.cursor;
            return true;
        }
        return false;
    }

    public void m_94757_(double mx, double my) {
        if (this.mouseSelecting) {
            this.setCursorAtMouse((float)mx, (float)my);
            this.isSelecting = true;
        }
        super.m_94757_(mx, my);
    }

    public boolean m_6348_(double mx, double my, int key) {
        if (key == 0) {
            this.mouseSelecting = false;
            return true;
        }
        return false;
    }

    public String getStringValue() {
        return this.value.toString();
    }

    public boolean isSelectionActive() {
        return this.isSelecting && this.selectionCursor != this.cursor;
    }

    @Override
    public void setValue(String value) {
        if (value.matches(this.filter)) {
            this.value = new StringBuilder(value);
        }
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    @Override
    public void setWidth(float width) {
        super.setWidth(Mth.m_14036_((float)width, (float)this.scrollerWidth, (float)2.1474836E9f));
    }

    @Override
    public void setHeight(float height) {
        super.setHeight(height);
    }

    @Override
    public void onFocused(boolean state) {
        if (!state) {
            this.isSelecting = false;
            this.cursor = 0;
            this.selectionCursor = 0;
        }
    }

    public float getTextOffsetLeft() {
        return this.textOffsetLeft;
    }

    public float getTextOffsetRight() {
        return this.textOffsetRight + this.scrollerWidth + 2.0f;
    }

    public float getTextOffsetY() {
        return this.textOffsetY;
    }

    public float getMaxScrollAmount() {
        Font font = Minecraft.m_91087_().f_91062_;
        Objects.requireNonNull(font);
        float lineHeight = 9.0f * this.textScale;
        int lineCount = this.lines.size() + 1;
        return Mth.m_14036_((float)(lineHeight * (float)lineCount - this.getHeight() - this.textOffsetY * 2.0f), (float)0.0f, (float)2.1474836E9f);
    }

    @Override
    public void applyOptions(FDEditorComponent owner, Annotation annotation) {
        if (annotation instanceof FDScale) {
            FDScale scale = (FDScale)annotation;
            this.textScale = scale.value();
        }
    }

    public record Line(int begin, int end) {
    }
}

