/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdlib.systems.bedrock.animations.animation_system.item;

import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.item.FDModelItemRendererOptions;
import com.finderfeed.fdlib.systems.bedrock.models.FDModel;
import com.finderfeed.fdlib.systems.bedrock.models.FDModelInfo;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;

public class FDModelItemRenderer
extends BlockEntityWithoutLevelRenderer {
    public List<FDModel> models;
    public FDModelItemRendererOptions options;

    public FDModelItemRenderer(FDModelItemRendererOptions options) {
        super(Minecraft.m_91087_().m_167982_(), Minecraft.m_91087_().m_167973_());
        this.options = options;
    }

    public void m_108829_(ItemStack stack, ItemDisplayContext displayContext, PoseStack matrices, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        this.initModelsIfNecessary();
        float scale = this.options.scale.apply(displayContext).floatValue();
        if (displayContext == ItemDisplayContext.GUI) {
            translation = this.options.translation.apply(displayContext);
            matrices.m_85837_(0.5 + (double)translation.x, (double)(0.25f + translation.y), 0.5 + (double)translation.z);
            matrices.m_252781_(Axis.f_252529_.m_252977_(35.0f));
            matrices.m_252781_(Axis.f_252436_.m_252977_(45.0f + this.options.rotation.apply(displayContext).floatValue()));
        } else {
            translation = this.options.translation.apply(displayContext);
            if (displayContext == ItemDisplayContext.GROUND) {
                matrices.m_85837_(0.5 + (double)translation.x, 0.3 + (double)translation.y, 0.5 + (double)translation.z);
            } else {
                matrices.m_85837_(0.5 + (double)translation.z, 0.5 + (double)translation.y, 0.5 + (double)translation.x);
            }
            matrices.m_252781_(Axis.f_252436_.m_252977_(this.options.rotation.apply(displayContext).floatValue()));
        }
        matrices.m_85841_(scale, scale, scale);
        for (int i = 0; i < this.models.size(); ++i) {
            FDModel model = this.models.get(i);
            VertexConsumer vertex = buffer.m_6299_(this.options.renderTypes.get(i));
            model.render(matrices, vertex, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    private void initModelsIfNecessary() {
        if (this.models == null) {
            this.models = new ArrayList<FDModel>();
            for (Supplier<FDModelInfo> sup : this.options.modelInfos) {
                this.models.add(new FDModel(sup.get()));
            }
        }
    }

    public static IClientItemExtensions createExtensions(final FDModelItemRendererOptions options) {
        return new IClientItemExtensions(){
            private FDModelItemRenderer renderer;
            {
                this.renderer = new FDModelItemRenderer(options);
            }

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return this.renderer;
            }
        };
    }
}

