/*
 * Decompiled with CFR 0.152.
 */
package fr.atesab.customcursormod.forge;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import fr.atesab.customcursormod.common.handler.CommonMatrixStack;
import fr.atesab.customcursormod.common.handler.CommonShader;
import fr.atesab.customcursormod.common.handler.GuiUtils;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import org.joml.Matrix4f;

public class ForgeGuiUtils
extends GuiUtils {
    private static final ForgeGuiUtils instance = new ForgeGuiUtils();

    private ForgeGuiUtils() {
    }

    public static ForgeGuiUtils getForge() {
        return instance;
    }

    @Override
    public void drawScaledCustomSizeModalRect(int x, int y, float u, float v, int uWidth, int vHeight, int width, int height, float tileWidth, float tileHeight, int color, boolean useAlpha) {
        float scaleX = 1.0f / tileWidth;
        float scaleY = 1.0f / tileHeight;
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        int alpha = useAlpha ? color >> 24 : 255;
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        bufferbuilder.m_5483_((double)x, (double)(y + height), 0.0).m_7421_(u * scaleX, (v + (float)vHeight) * scaleY).m_6122_(red, green, blue, alpha).m_5752_();
        bufferbuilder.m_5483_((double)(x + width), (double)(y + height), 0.0).m_7421_((u + (float)uWidth) * scaleX, (v + (float)vHeight) * scaleY).m_6122_(red, green, blue, alpha).m_5752_();
        bufferbuilder.m_5483_((double)(x + width), (double)y, 0.0).m_7421_((u + (float)uWidth) * scaleX, v * scaleY).m_6122_(red, green, blue, alpha).m_5752_();
        bufferbuilder.m_5483_((double)x, (double)y, 0.0).m_7421_(u * scaleX, v * scaleY).m_6122_(red, green, blue, alpha).m_5752_();
        tesselator.m_85914_();
    }

    @Override
    public void drawGradientRect(CommonMatrixStack stack, int left, int top, int right, int bottom, int rightTopColor, int leftTopColor, int leftBottomColor, int rightBottomColor, float zLevel) {
        float alphaRightTop = (float)(rightTopColor >> 24 & 0xFF) / 255.0f;
        float redRightTop = (float)(rightTopColor >> 16 & 0xFF) / 255.0f;
        float greenRightTop = (float)(rightTopColor >> 8 & 0xFF) / 255.0f;
        float blueRightTop = (float)(rightTopColor & 0xFF) / 255.0f;
        float alphaLeftTop = (float)(leftTopColor >> 24 & 0xFF) / 255.0f;
        float redLeftTop = (float)(leftTopColor >> 16 & 0xFF) / 255.0f;
        float greenLeftTop = (float)(leftTopColor >> 8 & 0xFF) / 255.0f;
        float blueLeftTop = (float)(leftTopColor & 0xFF) / 255.0f;
        float alphaLeftBottom = (float)(leftBottomColor >> 24 & 0xFF) / 255.0f;
        float redLeftBottom = (float)(leftBottomColor >> 16 & 0xFF) / 255.0f;
        float greenLeftBottom = (float)(leftBottomColor >> 8 & 0xFF) / 255.0f;
        float blueLeftBottom = (float)(leftBottomColor & 0xFF) / 255.0f;
        float alphaRightBottom = (float)(rightBottomColor >> 24 & 0xFF) / 255.0f;
        float redRightBottom = (float)(rightBottomColor >> 16 & 0xFF) / 255.0f;
        float greenRightBottom = (float)(rightBottomColor >> 8 & 0xFF) / 255.0f;
        float blueRightBottom = (float)(rightBottomColor & 0xFF) / 255.0f;
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::m_172811_);
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        Matrix4f mat = ((PoseStack)stack.getHandle()).m_85850_().m_252922_();
        bufferbuilder.m_252986_(mat, (float)right, (float)top, zLevel).m_85950_(redRightTop, greenRightTop, blueRightTop, alphaRightTop).m_5752_();
        bufferbuilder.m_252986_(mat, (float)left, (float)top, zLevel).m_85950_(redLeftTop, greenLeftTop, blueLeftTop, alphaLeftTop).m_5752_();
        bufferbuilder.m_252986_(mat, (float)left, (float)bottom, zLevel).m_85950_(redLeftBottom, greenLeftBottom, blueLeftBottom, alphaLeftBottom).m_5752_();
        bufferbuilder.m_252986_(mat, (float)right, (float)bottom, zLevel).m_85950_(redRightBottom, greenRightBottom, blueRightBottom, alphaRightBottom).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
        RenderSystem.disableBlend();
    }

    @Override
    public int fontHeight() {
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        return 9;
    }

    @Override
    public void setShaderColor(float r, float g, float b, float a) {
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)a);
    }

    @Override
    public void setShader(CommonShader shader) {
        RenderSystem.setShader((Supplier)((Supplier)shader.getHandle()));
    }
}

