/*
 * Decompiled with CFR 0.152.
 */
package fr.atesab.customcursormod.common.handler;

import fr.atesab.customcursormod.common.CursorMod;
import fr.atesab.customcursormod.common.handler.GameType;
import fr.atesab.customcursormod.common.handler.UnhandledGameTypeException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;

public class CommonSupplier<I, T> {
    private boolean buffer;
    private Function<I, T> bufferedFunction;
    private T store = null;
    private Map<GameType, Function<I, T>> suppliers = new HashMap<GameType, Function<I, T>>();

    public CommonSupplier(boolean buffer) {
        this.buffer = buffer;
    }

    public CommonSupplier<I, T> forType(GameType type, Runnable action) {
        return this.forType(type, (I i) -> {
            action.run();
            return null;
        });
    }

    public CommonSupplier<I, T> forType(GameType type, Supplier<T> supplier) {
        return this.forType(type, (I i) -> supplier.get());
    }

    public CommonSupplier<I, T> forType(GameType type, Function<I, T> supplier) {
        this.suppliers.put(Objects.requireNonNull(type, "type can't be null"), Objects.requireNonNull(supplier, "supplier can't be null"));
        return this;
    }

    public T fetch() {
        return this.fetch(null);
    }

    public T fetch(I input) {
        if (this.buffer && this.store != null) {
            return this.store;
        }
        if (this.bufferedFunction == null) {
            GameType type = CursorMod.getInstance().getType();
            Function<I, Object> s = this.suppliers.get(type);
            if (s == null && (s = this.suppliers.get(GameType.COMMON)) == null) {
                throw new UnhandledGameTypeException(type);
            }
            this.bufferedFunction = s;
            this.suppliers.clear();
            this.suppliers = null;
        }
        T out = this.bufferedFunction.apply(input);
        if (this.buffer) {
            this.store = out;
            if (this.store != null) {
                this.bufferedFunction = null;
            }
        }
        return out;
    }
}

