/*
 * Decompiled with CFR 0.152.
 */
package fr.atesab.customcursormod.common.handler;

import fr.atesab.customcursormod.common.handler.CommonElement;
import fr.atesab.customcursormod.common.handler.CommonMatrixStack;
import fr.atesab.customcursormod.common.handler.CommonSupplier;
import fr.atesab.customcursormod.common.handler.CommonText;
import java.util.ArrayList;
import java.util.List;

public abstract class CommonScreen {
    public static final CommonSupplier<CommonScreenObject, CommonScreen> SUPPLIER = new CommonSupplier(false);
    public static final CommonSupplier<Void, CommonScreen> SUPPLIER_CURRENT = new CommonSupplier(false);
    private static final ScreenListener NULL_LISTENER = new ScreenListener();
    private CommonScreen parent;
    public final ScreenListener listener;
    public final List<CommonElement> childrens = new ArrayList<CommonElement>();

    public static CommonScreen create(CommonScreen parent, CommonText title, ScreenListener listener) {
        return SUPPLIER.fetch(new CommonScreenObject(parent == null ? CommonScreen.createNull() : parent, title, listener));
    }

    public static CommonScreen createNull() {
        return CommonScreen.create(null, null, NULL_LISTENER);
    }

    public static CommonScreen getCurrent() {
        return SUPPLIER_CURRENT.fetch();
    }

    protected CommonScreen(CommonScreen parent, ScreenListener listener) {
        this.parent = parent;
        this.listener = listener == null ? new ScreenListener() : listener;
        this.listener.screen = this;
    }

    protected CommonScreen(CommonScreen parent) {
        this(parent, null);
    }

    public <E extends CommonElement> E addChildren(E child) {
        this.childrens.add(child);
        return child;
    }

    public CommonScreen getParent() {
        return this.parent == null ? CommonScreen.createNull() : this.parent;
    }

    public void setParent(CommonScreen parent) {
        this.parent = parent == null ? CommonScreen.createNull() : parent;
    }

    public void resize(int width, int height) {
        this.listener.width = width;
        this.listener.height = height;
    }

    public void init() {
        this.childrens.clear();
        this.listener.init();
    }

    public boolean charTyped(char key, int modifier) {
        if (this.listener.charTyped(key, modifier)) {
            return true;
        }
        for (CommonElement e : this.childrens) {
            if (!e.charTyped(key, modifier)) continue;
            return true;
        }
        return false;
    }

    public boolean keyPressed(int key, int scan, int modifier) {
        if (this.listener.keyPressed(key, scan, modifier)) {
            return true;
        }
        for (CommonElement e : this.childrens) {
            if (!e.keyPressed(key, scan, modifier)) continue;
            return true;
        }
        return false;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (this.listener.mouseClicked(mouseX, mouseY, mouseButton)) {
            return true;
        }
        for (CommonElement e : this.childrens) {
            if (!e.mouseClicked(mouseX, mouseY, mouseButton)) continue;
            return true;
        }
        return false;
    }

    public void tick() {
        this.listener.tick();
        for (CommonElement e : this.childrens) {
            e.tick();
        }
    }

    public void render(CommonMatrixStack stack, int mouseX, int mouseY, float partialTicks) {
        this.listener.render(stack, mouseX, mouseY, partialTicks);
        for (CommonElement e : this.childrens) {
            e.render(stack, mouseX, mouseY, partialTicks);
        }
    }

    public abstract void renderDefaultBackground(CommonMatrixStack var1);

    public abstract void displayScreen();

    public abstract int fontWidth(String var1);

    public void drawCenterString(CommonMatrixStack stack, String text, int x, int y, int color, float factor) {
        this.drawCenterString(stack, text, (float)x, (float)y, color, factor);
    }

    public void drawCenterString(CommonMatrixStack stack, String text, float x, float y, int color, float factor) {
        this.drawString(stack, text, x - (float)this.fontWidth(text) * factor / 2.0f, y, color, factor);
    }

    public void drawRightString(CommonMatrixStack stack, String text, int x, int y, int color, float factor) {
        this.drawRightString(stack, text, (float)x, (float)y, color, factor);
    }

    public void drawRightString(CommonMatrixStack stack, String text, float x, float y, int color, float factor) {
        this.drawString(stack, text, x - (float)this.fontWidth(text) * factor, y, color, factor);
    }

    public void drawCenterString(CommonMatrixStack stack, String text, int x, int y, int color) {
        this.drawCenterString(stack, text, (float)x, (float)y, color);
    }

    public void drawCenterString(CommonMatrixStack stack, String text, float x, float y, int color) {
        this.drawString(stack, text, x - (float)this.fontWidth(text) / 2.0f, y, color);
    }

    public void drawRightString(CommonMatrixStack stack, String text, int x, int y, int color) {
        this.drawRightString(stack, text, (float)x, (float)y, color);
    }

    public void drawRightString(CommonMatrixStack stack, String text, float x, float y, int color) {
        this.drawString(stack, text, x - (float)this.fontWidth(text), y, color);
    }

    public void drawString(CommonMatrixStack stack, String text, int x, int y, int color, float factor) {
        this.drawString(stack, text, (float)x, (float)y, color, factor);
    }

    public void drawString(CommonMatrixStack stack, String text, float x, float y, int color, float factor) {
        stack.scale(factor);
        this.drawString(stack, text, x / factor, y / factor, color);
        stack.scaleInv(factor);
    }

    public void drawString(CommonMatrixStack stack, String text, int x, int y, int color) {
        this.drawString(stack, text, (float)x, (float)y, color);
    }

    public abstract void drawString(CommonMatrixStack var1, String var2, float var3, float var4, int var5);

    public abstract float getBlitOffset();

    public static class CommonScreenObject {
        public final CommonScreen parent;
        public final CommonText title;
        public final ScreenListener listener;

        public CommonScreenObject(CommonScreen parent, CommonText title, ScreenListener listener) {
            this.title = title;
            this.parent = parent;
            this.listener = listener;
        }
    }

    public static class ScreenListener {
        protected int width;
        protected int height;
        private CommonScreen screen;

        public CommonScreen getScreen() {
            return this.screen;
        }

        public void resize(int width, int height) {
        }

        public void init() {
        }

        public boolean charTyped(char key, int modifier) {
            return false;
        }

        public boolean keyPressed(int key, int scan, int modifier) {
            return false;
        }

        public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
            return false;
        }

        public void tick() {
        }

        public void render(CommonMatrixStack stack, int mouseX, int mouseY, float partialTicks) {
        }
    }
}

