/*
 * Decompiled with CFR 0.152.
 */
package fr.atesab.customcursormod.common.config;

import fr.atesab.customcursormod.common.handler.ResourceLocationCommon;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.nio.ByteBuffer;
import javax.imageio.ImageIO;
import org.lwjgl.BufferUtils;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWImage;

public class CursorConfig {
    private int xHotSpot;
    private int yHotSpot;
    private String link;
    private int size = 32;
    private long cursor = 0L;
    private GLFWImage glfwImage = GLFWImage.create();

    public static CursorConfig read(CursorConfigStore store, CursorConfig defaultConfig) {
        CursorConfig cursor = new CursorConfig();
        if (store == null) {
            cursor.xHotSpot = defaultConfig.xHotSpot;
            cursor.yHotSpot = defaultConfig.yHotSpot;
            cursor.link = defaultConfig.link;
            cursor.size = defaultConfig.size;
        } else {
            cursor.xHotSpot = store.xHotSpot;
            cursor.yHotSpot = store.yHotSpot;
            cursor.link = store.link == null ? defaultConfig.link : store.link;
            cursor.size = store.size > 0 ? store.size : defaultConfig.size;
        }
        return cursor;
    }

    private CursorConfig() {
    }

    public CursorConfig(String link) {
        this(link, 0, 0);
    }

    public CursorConfig(String link, int xHotSpot, int yHotSpot) {
        this(link, xHotSpot, yHotSpot, 32);
    }

    public CursorConfig(String link, int xHotSpot, int yHotSpot, int size) {
        this.xHotSpot = xHotSpot;
        this.yHotSpot = yHotSpot;
        this.link = link;
        this.size = size;
    }

    private void allocate() {
        try {
            this.readImage();
            if (this.cursor != 0L) {
                this.freeCursor();
            }
            if (this.glfwImage != null && this.glfwImage.width() > 0 && this.glfwImage.height() > 0) {
                this.cursor = GLFW.glfwCreateCursor((GLFWImage)this.glfwImage, (int)this.getxHotSpot(), (int)this.getyHotSpot());
                if (this.cursor == 0L) {
                    System.err.println("Failed to create cursor");
                }
            } else {
                System.err.println("Invalid image dimensions or format");
            }
        }
        catch (Exception e) {
            System.err.println("Error allocating cursor: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public CursorConfig copy() {
        CursorConfig config = new CursorConfig(this.link, this.xHotSpot, this.yHotSpot, this.size);
        return config;
    }

    public void freeCursor() {
        if (this.isAllocate()) {
            GLFW.glfwDestroyCursor((long)this.cursor);
        }
    }

    public long getCursor() {
        if (this.cursor == 0L) {
            this.allocate();
        }
        return this.cursor;
    }

    public String getLink() {
        return this.link;
    }

    public InputStream getResource() {
        try {
            return this.getResourceLocation().openStream();
        }
        catch (Exception e) {
            return null;
        }
    }

    public ResourceLocationCommon getResourceLocation() {
        return ResourceLocationCommon.create(this.link);
    }

    public int getxHotSpot() {
        return this.xHotSpot;
    }

    public int getyHotSpot() {
        return this.yHotSpot;
    }

    public boolean isAllocate() {
        return this.cursor != 0L;
    }

    private void readImage() {
        try {
            InputStream stream = this.getResource();
            if (stream == null) {
                System.err.println("Failed to load cursor resource: " + this.link);
                return;
            }
            BufferedImage originalImage = ImageIO.read(stream);
            if (originalImage == null) {
                System.err.println("Failed to read cursor image: " + this.link);
                return;
            }
            int originalWidth = originalImage.getWidth();
            int originalHeight = originalImage.getHeight();
            float scale = (float)this.size / (float)originalWidth;
            int scaledWidth = this.size;
            int scaledHeight = (int)((float)originalHeight * scale);
            BufferedImage scaledImage = new BufferedImage(scaledWidth, scaledHeight, 2);
            Graphics2D g2d = scaledImage.createGraphics();
            g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g2d.drawImage(originalImage, 0, 0, scaledWidth, scaledHeight, null);
            g2d.dispose();
            int[] pixels = new int[scaledWidth * scaledHeight];
            scaledImage.getRGB(0, 0, scaledWidth, scaledHeight, pixels, 0, scaledWidth);
            ByteBuffer buffer = BufferUtils.createByteBuffer((int)(scaledWidth * scaledHeight * 4));
            for (int y = 0; y < scaledHeight; ++y) {
                for (int x = 0; x < scaledWidth; ++x) {
                    int pixel = pixels[y * scaledWidth + x];
                    buffer.put((byte)(pixel >> 16 & 0xFF));
                    buffer.put((byte)(pixel >> 8 & 0xFF));
                    buffer.put((byte)(pixel & 0xFF));
                    buffer.put((byte)(pixel >> 24 & 0xFF));
                }
            }
            buffer.flip();
            this.glfwImage.pixels(buffer);
            this.glfwImage.width(scaledWidth);
            this.glfwImage.height(scaledHeight);
        }
        catch (Exception e) {
            System.err.println("Error reading cursor image: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void setLink(String link) {
        if (this.cursor != 0L) {
            this.allocate();
        }
        this.link = link;
    }

    public void setxHotSpot(int xHotSpot) {
        this.xHotSpot = xHotSpot;
        if (this.cursor != 0L) {
            this.freeCursor();
            this.allocate();
        }
    }

    public void setyHotSpot(int yHotSpot) {
        this.yHotSpot = yHotSpot;
        if (this.cursor != 0L) {
            this.freeCursor();
            this.allocate();
        }
    }

    public CursorConfigStore write() {
        CursorConfigStore store = new CursorConfigStore(this);
        store.size = this.size;
        return store;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        int newSize = Math.max(1, Math.min(128, size));
        if (this.size != newSize) {
            this.size = newSize;
            if (this.cursor != 0L) {
                this.freeCursor();
                this.allocate();
            }
        }
    }

    public static class CursorConfigStore {
        int xHotSpot;
        int yHotSpot;
        String link;
        int size;

        public CursorConfigStore(CursorConfig current) {
            this();
            this.xHotSpot = current.xHotSpot;
            this.yHotSpot = current.yHotSpot;
            this.link = current.link;
            this.size = current.size;
        }

        private CursorConfigStore() {
        }
    }
}

