/*
 * Decompiled with CFR 0.152.
 */
package me.kall.duplicationless.mixinextras.expression.impl.ast.expressions;

import me.kall.duplicationless.mixinextras.expression.impl.ExpressionSource;
import me.kall.duplicationless.mixinextras.expression.impl.ast.expressions.SimpleExpression;
import me.kall.duplicationless.mixinextras.expression.impl.flow.FlowValue;
import me.kall.duplicationless.mixinextras.expression.impl.point.ExpressionContext;
import me.kall.duplicationless.mixinextras.expression.impl.utils.ExpressionASMUtils;
import org.objectweb.asm.Type;

public class DecimalLiteralExpression
extends SimpleExpression {
    public final double value;

    public DecimalLiteralExpression(ExpressionSource src, double value) {
        super(src);
        this.value = value;
    }

    @Override
    protected boolean matchesImpl(FlowValue node, ExpressionContext ctx) {
        if (!node.typeMatches(Type.FLOAT_TYPE) && !node.typeMatches(Type.DOUBLE_TYPE)) {
            return false;
        }
        Object cst = ExpressionASMUtils.getConstant(node.getInsn());
        if (cst == null) {
            return false;
        }
        return (cst instanceof Float || cst instanceof Double) && String.valueOf(this.value).equals(cst.toString());
    }
}

