/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.v2.widgets.text;

import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.sixik.v2.color.RGB;
import net.sixik.v2.color.RGBA;
import net.sixik.v2.render.GLRenderHelper;
import net.sixik.v2.render.TextRenderHelper;
import net.sixik.v2.utils.math.Vector2;
import net.sixik.v2.widgets.UIComponent;

public class TextFieldUIComponent
extends UIComponent {
    public Component fieldText = Component.m_237119_();
    public float textSize = 1.0f;
    public int textSpace = 0;
    public RGBA color = RGBA.create(255, 255, 255, 255);

    public TextFieldUIComponent() {
    }

    public TextFieldUIComponent(Component fieldText) {
        this.setText(fieldText);
    }

    public TextFieldUIComponent(String fieldText) {
        this.setText(fieldText);
    }

    public TextFieldUIComponent setText(Component fieldText) {
        this.fieldText = fieldText;
        this.calculateHeight();
        return this;
    }

    public TextFieldUIComponent calculateHeight() {
        List<String> list = TextRenderHelper.splitTextToLines(this.fieldText.getString(), this.textSize, this.width);
        this.setHeight((int)((float)list.size() * TextRenderHelper.getTextHeight(this.textSize) + (float)(list.size() * this.textSpace)));
        return this;
    }

    public TextFieldUIComponent setTextSpace(int textSpace) {
        this.textSpace = textSpace;
        return this;
    }

    public TextFieldUIComponent setText(String fieldText) {
        return this.setText((Component)Component.m_237113_((String)fieldText));
    }

    public TextFieldUIComponent setTextTranslatable(String fieldText) {
        return this.setText((Component)Component.m_237115_((String)fieldText));
    }

    public TextFieldUIComponent setTextSize(float textSize) {
        this.textSize = textSize;
        this.calculateHeight();
        return this;
    }

    public TextFieldUIComponent setColor(RGB color) {
        this.color = color.toARGB();
        return this;
    }

    @Override
    public void drawWidget(GuiGraphics graphics, int x, int y, int w, int h) {
        super.drawWidget(graphics, x, y, w, h);
    }

    @Override
    public void drawBackground(GuiGraphics graphics, int x, int y, int w, int h) {
        graphics.m_280168_().m_85836_();
        GLRenderHelper.pushTransform(graphics, new Vector2(x, y), new Vector2(1, 1), this.textSize, 0.0f);
        this.drawTextField(graphics, x, y, (int)((float)w / this.textSize), h);
        List<String> list = TextRenderHelper.splitTextToLines(this.fieldText.getString(), this.textSize, w);
        for (int i = 0; i < list.size(); ++i) {
            TextRenderHelper.drawText(graphics, list.get(i), x + 2, (int)((float)(y + 2) + (float)i * TextRenderHelper.getTextHeight(this.textSize) + (float)this.textSpace), (RGB)this.color);
        }
        GLRenderHelper.popTransform(graphics);
        graphics.m_280168_().m_85849_();
    }

    public void drawTextField(GuiGraphics graphics, int x, int y, int w, int h) {
        RGBA.create(0, 0, 0, 85).draw(graphics, x, y, w, h);
    }
}

