/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.v2.widgets.text;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.util.Mth;
import net.sixik.v2.color.Colors;
import net.sixik.v2.enums.KeyboardKey;
import net.sixik.v2.render.TextRenderHelper;
import net.sixik.v2.widgets.UIComponent;

public class TextBoxUIComponent
extends UIComponent {
    public String boxText = "";
    private int cursorPos = 0;

    @Override
    public boolean keyPressed(KeyboardKey key) {
        if (key.keyCode == 259) {
            this.deleteCharacter();
        }
        if (key.keyCode == 263) {
            this.setCursorPos(this.cursorPos - 1);
        }
        if (key.keyCode == 262) {
            this.setCursorPos(this.cursorPos + 1);
        }
        return super.keyPressed(key);
    }

    @Override
    public boolean charTyped(char keyChar, int modifiers) {
        this.insertText(Character.toString(keyChar));
        return true;
    }

    public void insertText(String string) {
        this.boxText = this.boxText.substring(0, this.cursorPos) + string + this.boxText.substring(this.cursorPos);
        this.cursorPos += string.length();
    }

    public TextBoxUIComponent setCursorPos(int cursorPos) {
        this.cursorPos = Mth.m_14045_((int)cursorPos, (int)0, (int)this.boxText.length());
        return this;
    }

    public TextBoxUIComponent setText(String text) {
        this.boxText = text;
        return this;
    }

    public TextBoxUIComponent setText(Object text) {
        return this.setText(TextRenderHelper.getText(text));
    }

    public void deleteCharacter() {
        if (this.cursorPos > 0) {
            this.boxText = this.boxText.substring(0, this.cursorPos - 1) + this.boxText.substring(this.cursorPos);
            --this.cursorPos;
        }
    }

    @Override
    public void drawBackground(GuiGraphics graphics, int x, int y, int w, int h) {
        Colors.UI_NIGHT_1.draw(graphics, x, y, w, h);
        TextRenderHelper.drawText(graphics, this.boxText, x, y);
    }
}

