/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.v2.widgets.slieder;

import net.minecraft.client.gui.GuiGraphics;
import net.sixik.v2.color.Colors;
import net.sixik.v2.enums.MouseClick;
import net.sixik.v2.enums.SliderType;
import net.sixik.v2.widgets.UIComponent;

public class SliderUIComponent
extends UIComponent {
    public int maxValue = 1;
    public int minValue = 0;
    public int currentValue = 0;
    public SliderType sliderType = SliderType.HORIZONTAL;
    private double lastDragPos = 0.0;
    public int postScrollButton = 0;
    public int scrollButtonX = 0;
    public int scrollButtonY = 0;
    public int scrollButtonWidth = 10;
    public int scrollButtonHeight = 10;

    public void onValueChanged(int value) {
    }

    public void onFilled() {
    }

    public SliderUIComponent setScrollButtonSize(int w, int h) {
        this.scrollButtonWidth = w >= this.width ? w : this.width;
        this.scrollButtonHeight = h >= this.height ? h : this.height;
        return this;
    }

    @Override
    public UIComponent setPos(int x, int y) {
        super.setPos(x, y);
        this.scrollButtonX = this.getX();
        this.scrollButtonY = this.getY();
        return this;
    }

    public SliderUIComponent resetValue() {
        this.currentValue = this.minValue;
        return this;
    }

    public SliderUIComponent setValue(int value) {
        this.currentValue = Math.min(this.maxValue, Math.max(value, this.minValue));
        this.changeScroll(1.0);
        return this;
    }

    public SliderUIComponent setMinValue(int minValue) {
        this.minValue = minValue;
        this.setValue(minValue);
        return this;
    }

    public SliderUIComponent setMaxValue(int maxValue) {
        if (maxValue <= this.minValue) {
            this.maxValue = this.minValue + 1;
            throw new RuntimeException("Try to set maxValue who less than minValue");
        }
        this.maxValue = maxValue;
        return this;
    }

    @Override
    public void drawBackground(GuiGraphics graphics, int x, int y, int w, int h) {
        this.drawSliderBackground(graphics, x, y, w, h);
        this.drawSlider(graphics, this.scrollButtonX, this.scrollButtonY, this.scrollButtonWidth, this.scrollButtonHeight);
    }

    public void drawSliderBackground(GuiGraphics graphics, int x, int y, int w, int h) {
        Colors.POLAR_NIGHT_1.draw(graphics, x, y, w, h);
    }

    public void drawSlider(GuiGraphics graphics, int x, int y, int w, int h) {
        Colors.UI_GOLD_0.draw(graphics, x, y, w, h);
    }

    @Override
    public boolean mousePressed(double mouseX, double mouseY, MouseClick mouseClick) {
        boolean flag;
        boolean bl = flag = mouseX >= (double)this.scrollButtonX && mouseX < (double)(this.scrollButtonX + this.scrollButtonWidth) && mouseY >= (double)this.scrollButtonY && mouseY < (double)(this.scrollButtonY + this.scrollButtonHeight);
        if (flag) {
            this.isDragged = true;
            return true;
        }
        this.isDragged = false;
        return false;
    }

    @Override
    public boolean mouseDragged(double mouseX, double mouseY, MouseClick mouseClick, double dragX, double dragY) {
        if (this.isDragged) {
            double deltaDrag = this.sliderType.isHorizontal() ? dragX : dragY;
            double d = deltaDrag = deltaDrag < 0.0 ? -1.0 : 1.0;
            if (this.sliderType.isHorizontal() && mouseX >= (double)this.scrollButtonX && mouseX < (double)(this.scrollButtonX + this.scrollButtonWidth)) {
                this.changeScroll(deltaDrag);
            } else if (this.sliderType.isVertical() && mouseY >= (double)this.scrollButtonY && mouseY < (double)(this.scrollButtonY + this.scrollButtonHeight)) {
                this.changeScroll(deltaDrag);
            }
        }
        return true;
    }

    @Override
    public boolean mouseScrolled(double x, double y, double scroll) {
        this.changeScroll(scroll < 0.0 ? scroll : (double)Math.round(scroll));
        return true;
    }

    public void changeScroll(double drag) {
        int h = this.sliderType.isHorizontal() ? this.width - this.scrollButtonWidth : this.height - this.scrollButtonHeight;
        int valueSize = h / this.maxValue;
        int j = (int)(drag * (double)valueSize);
        if (this.sliderType.isHorizontal()) {
            this.scrollButtonX = Math.max(this.getX(), Math.min(this.getX() + h, this.scrollButtonX + j));
        } else {
            this.scrollButtonY = Math.max(this.getY(), Math.min(this.getY() + h, this.scrollButtonY + j));
        }
        if (drag < 0.0 && this.currentValue - 1 >= this.minValue) {
            --this.currentValue;
            this.onValueChanged(this.currentValue);
        } else if (drag > 0.0 && this.currentValue + 1 <= this.maxValue) {
            ++this.currentValue;
            if (this.currentValue == this.maxValue) {
                this.onFilled();
            } else {
                this.onValueChanged(this.currentValue);
            }
        }
    }
}

