/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.v2.widgets.screen;

import com.mojang.blaze3d.platform.Window;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.sixik.v2.color.RGBA;
import net.sixik.v2.enums.CenterOperators;
import net.sixik.v2.utils.math.Vector2;
import net.sixik.v2.widgets.UIComponent;
import net.sixik.v2.widgets.alight.AlightContainerUIComponent;
import net.sixik.v2.widgets.panel.UIPanel;
import net.sixik.v2.widgets.screen.UIScreenWrapper;

public class UIScreen
extends UIPanel {
    public Window window = Minecraft.m_91087_().m_91268_();
    public CenterOperators.Type centerOperator = CenterOperators.Type.CENTER_Y;
    public boolean isPauseGame = false;

    public UIScreen() {
        this.renderContext = new RenderContext();
    }

    public boolean onInit() {
        this.setSize(128, 176);
        return true;
    }

    @Override
    public void addWidget(UIComponent component) {
        Vector2 d = this.getStartPos();
        if (this.gui != null) {
            component.setGui(this.gui);
        }
        component.setRenderContext(this.renderContext);
        if (component instanceof UIPanel) {
            UIPanel panel = (UIPanel)component;
            panel.addWidgets();
        }
        this.components.addLast(component.setParent(this).setWidgetIndex(this.components.size()).setOffset(d.x, d.y));
    }

    public final void initGui() {
        if (this.onInit()) {
            this.addWidgets();
            this.refreshWidget();
            this.onPostInit();
        }
    }

    public void onPostInit() {
    }

    public void openGui() {
        Minecraft.m_91087_().m_91152_((Screen)new UIScreenWrapper(this));
    }

    public UIScreen setCenterOperator(CenterOperators.Type centerOperator) {
        this.centerOperator = centerOperator;
        return this;
    }

    public void closeGui() {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ != null) {
            mc.f_91074_.m_6915_();
            if (mc.f_91080_ == null) {
                mc.m_7440_(true);
            }
        }
        this.clearWidgets();
    }

    @Override
    public void addWidgets() {
    }

    @Override
    public void alightWidgets() {
        if (this.renderType.isOnlyRender() || this.renderType.isAllRender()) {
            for (int i = this.components.size() - 1; i >= 0; --i) {
                UIComponent component = (UIComponent)this.components.get(i);
                if (component instanceof UIPanel) {
                    UIPanel panel = (UIPanel)component;
                    panel.alightWidgets();
                }
                if (!(component instanceof AlightContainerUIComponent)) continue;
                AlightContainerUIComponent d = (AlightContainerUIComponent)component;
                d.alightWidgets();
            }
        }
    }

    @Override
    public void refreshWidget() {
        this.renderContext.setFocusedComponent(null);
        this.alightWidgets();
        this.refreshWidgets();
    }

    @Override
    public void drawWidget(GuiGraphics graphics, int x, int y, int w, int h) {
        switch (this.centerOperator) {
            case NONE: {
                super.drawWidget(graphics, this.y, this.x, this.width, this.height);
                break;
            }
            case CENTER_X: {
                super.drawWidget(graphics, this.window.m_85445_() / 2 - this.width / 2 + this.x, this.y, this.width, this.height);
                break;
            }
            case CENTER_Y: {
                super.drawWidget(graphics, this.x, this.window.m_85446_() / 2 - this.height / 2 + this.y, this.width, this.height);
                break;
            }
            case CENTER_XY: {
                super.drawWidget(graphics, this.window.m_85445_() / 2 - this.width / 2 + this.x, this.window.m_85446_() / 2 - this.height / 2 + this.y, this.width, this.height);
            }
        }
    }

    public final Vector2 getStartPos() {
        switch (this.centerOperator) {
            case NONE: {
                return new Vector2(this.y, this.x);
            }
            case CENTER_X: {
                return new Vector2(this.window.m_85445_() / 2 - this.width / 2 + this.x, this.y);
            }
            case CENTER_Y: {
                return new Vector2(this.x, this.window.m_85446_() / 2 - this.height / 2 + this.y);
            }
            case CENTER_XY: {
                return new Vector2(this.window.m_85445_() / 2 - this.width / 2 + this.x, this.window.m_85446_() / 2 - this.height / 2 + this.y);
            }
        }
        return new Vector2(0, 0);
    }

    @Override
    public void drawBackground(GuiGraphics graphics, int x, int y, int w, int h) {
        RGBA.create(0, 0, 0, 85).drawRoundFill(graphics, x, y, w, h, 10);
    }

    public static void refreshScreen() {
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (screen instanceof UIScreenWrapper) {
            UIScreenWrapper screenWrapper = (UIScreenWrapper)screen;
            screenWrapper.getScreen().refreshWidget();
        }
    }

    public static void refreshIfOpen(UIScreen screen) {
        UIScreenWrapper screenWrapper;
        Screen screen2 = Minecraft.m_91087_().f_91080_;
        if (screen2 instanceof UIScreenWrapper && (screenWrapper = (UIScreenWrapper)screen2).getScreen().equals(screen)) {
            screenWrapper.getScreen().refreshWidget();
        }
    }

    public static class RenderContext {
        public UIComponent focusedComponent = null;

        public boolean isFocusedComponent(UIComponent component) {
            return this.focusedComponent == null || this.focusedComponent.equals(component);
        }

        public RenderContext setFocusedComponent(UIComponent component) {
            this.focusedComponent = component;
            return this;
        }
    }
}

