/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.v2.widgets.prgressbar;

import net.minecraft.client.gui.GuiGraphics;
import net.sixik.v2.color.RGBA;
import net.sixik.v2.widgets.UIComponent;

public class ProgressBarUIComponent
extends UIComponent {
    public int progressValue = 0;
    public int minProgressValue = 0;
    public int maxProgressValue = 1;

    public ProgressBarUIComponent setMaxProgressValue(int value) {
        if (value <= this.minProgressValue) {
            this.maxProgressValue = this.minProgressValue + 1;
            throw new RuntimeException("Try to set maxValue who less than minValue");
        }
        this.maxProgressValue = value;
        return this;
    }

    public ProgressBarUIComponent setMinProgressValue(int value) {
        this.minProgressValue = value;
        return this;
    }

    public ProgressBarUIComponent setProgressValue(int value) {
        this.progressValue = Math.min(this.maxProgressValue, Math.max(this.minProgressValue, value));
        return this;
    }

    @Override
    public void drawBackground(GuiGraphics graphics, int x, int y, int w, int h) {
        this.drawProgressBar(graphics, x, y, w, h);
    }

    public void drawProgressBar(GuiGraphics graphics, int x, int y, int w, int h) {
        RGBA.create(0, 0, 0, 85).draw(graphics, x, y, w, h);
        int safeProgressValue = Math.min(this.progressValue, this.maxProgressValue);
        float progressWidth = (float)(w - 2) * (float)safeProgressValue / (float)this.maxProgressValue;
        RGBA.create(255, 0, 0, 255).draw(graphics, x + 1, y + 1, (int)progressWidth, h - 2);
    }
}

