/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.v2.widgets.panel;

import java.util.LinkedList;
import net.minecraft.client.gui.GuiGraphics;
import net.sixik.v2.enums.KeyboardKey;
import net.sixik.v2.enums.MouseClick;
import net.sixik.v2.enums.WidgetRender;
import net.sixik.v2.render.GLRenderHelper;
import net.sixik.v2.utils.math.Vector2;
import net.sixik.v2.widgets.UIComponent;
import net.sixik.v2.widgets.alight.AlightContainerUIComponent;

public abstract class UIPanel
extends UIComponent {
    public LinkedList<UIComponent> components = new LinkedList();
    public boolean useScissor = true;

    public abstract void addWidgets();

    public void addWidget(UIComponent component) {
        if (this.gui != null) {
            component.setGui(this.gui);
        }
        if (component instanceof UIPanel) {
            UIPanel panel = (UIPanel)component;
            panel.addWidgets();
        }
        this.components.addLast(component.setParent(this).setWidgetIndex(this.components.size()).setOffset(this.getX(), this.getY()).setRenderContext(this.renderContext));
    }

    public void addWidget(UIComponent component, WidgetRender renderType) {
        this.addWidget(component.setRenderType(renderType));
    }

    public boolean removeWidget(UIComponent component) {
        return this.components.remove(component);
    }

    public UIPanel setUseScissor() {
        this.useScissor = true;
        return this;
    }

    public UIComponent removeLastWidget() {
        return this.components.removeLast();
    }

    public UIComponent removeFirstWidget() {
        return this.components.removeFirst();
    }

    public void clearWidgets() {
        this.components.clear();
    }

    public void clearWidgets(WidgetRender renderType) {
        this.components.removeIf(component -> component.renderType == renderType);
    }

    public void alightWidgets() {
        if (this.renderType.isOnlyRender() || this.renderType.isAllRender()) {
            for (int i = this.components.size() - 1; i >= 0; --i) {
                UIComponent component = this.components.get(i);
                if (component instanceof UIPanel) {
                    UIPanel panel = (UIPanel)component;
                    panel.alightWidgets();
                }
                if (!(component instanceof AlightContainerUIComponent)) continue;
                AlightContainerUIComponent d = (AlightContainerUIComponent)component;
                d.alightWidgets();
            }
        }
    }

    @Override
    public void refreshWidget() {
        this.alightWidgets();
        this.refreshWidgets();
    }

    public void refreshWidgets() {
        for (int i = this.components.size() - 1; i >= 0; --i) {
            this.components.get(i).refreshWidget();
        }
    }

    @Override
    public boolean mouseScrolled(double x, double y, double scroll) {
        for (int i = this.components.size() - 1; i >= 0; --i) {
            UIComponent component = this.components.get(i);
            if (!component.renderType.isAllRender() || !component.isMouseOver || !this.renderContext.isFocusedComponent(component) || !component.mouseScrolled(x, y, scroll)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean mouseDragged(double mouseX, double mouseY, MouseClick mouseClick, double dragX, double dragY) {
        for (int i = this.components.size() - 1; i >= 0; --i) {
            UIComponent component = this.components.get(i);
            if (!component.renderType.isAllRender() || !component.isMouseOver || !this.renderContext.isFocusedComponent(component) || !component.mouseDragged(mouseX, mouseY, mouseClick, dragX, dragY)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, MouseClick mouseClick) {
        for (int i = this.components.size() - 1; i >= 0; --i) {
            UIComponent component = this.components.get(i);
            if (!component.renderType.isAllRender() || !component.isMouseOver || !this.renderContext.isFocusedComponent(component) || !component.mouseReleased(mouseX, mouseY, mouseClick)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean mousePressed(double mouseX, double mouseY, MouseClick mouseClick) {
        for (int i = this.components.size() - 1; i >= 0; --i) {
            UIComponent component = this.components.get(i);
            if (component.renderType.isAllRender() && this.renderContext.isFocusedComponent(component)) {
                if (component.isMouseOver && component.mousePressed(mouseX, mouseY, mouseClick)) {
                    component.isFocused = true;
                    return false;
                }
                if (component.isMouseOver) continue;
                component.isFocused = false;
                continue;
            }
            component.isFocused = false;
        }
        return true;
    }

    @Override
    public void mouseMoved(double mouseX, double mouseY) {
        for (int i = this.components.size() - 1; i >= 0; --i) {
            UIComponent component = this.components.get(i);
            if (!component.renderType.isAllRender() || !this.renderContext.isFocusedComponent(component)) continue;
            component.mouseMoved(mouseX, mouseY);
        }
    }

    @Override
    public boolean isMouseOver(double mouseX, double mouseY) {
        for (int i = this.components.size() - 1; i >= 0; --i) {
            UIComponent component = this.components.get(i);
            if (!component.renderType.isAllRender() || !this.renderContext.isFocusedComponent(component) || !component.isMouseOver(mouseX, mouseY)) continue;
            return true;
        }
        this.isMouseOver = mouseX >= (double)this.getX() && mouseX < (double)(this.getX() + this.width) && mouseY >= (double)this.getY() && mouseY < (double)(this.getY() + this.height);
        return this.isMouseOver;
    }

    @Override
    public boolean keyPressed(KeyboardKey key) {
        for (int i = this.components.size() - 1; i >= 0; --i) {
            if (!this.components.get(i).keyPressed(key)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean keyReleased(KeyboardKey key) {
        for (int i = this.components.size() - 1; i >= 0; --i) {
            if (!this.components.get(i).keyReleased(key)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean charTyped(char keyChar, int modifiers) {
        for (int i = this.components.size() - 1; i >= 0; --i) {
            UIComponent component = this.components.get(i);
            if (!component.renderType.isAllRender() || !component.isFocused || !component.charTyped(keyChar, modifiers)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void drawWidget(GuiGraphics graphics, int x, int y, int w, int h) {
        this.tickWidget();
        if (this.useScissor) {
            GLRenderHelper.pushScissor(graphics, new Vector2(x, y), new Vector2(w, h));
        }
        this.drawBackground(graphics, x, y, w, h);
        for (int i = this.components.size() - 1; i >= 0; --i) {
            UIComponent component = this.components.get(i);
            if (!component.renderType.isOnlyRender() && !component.renderType.isAllRender()) continue;
            GLRenderHelper.pushTransform(graphics, new Vector2(x, y), new Vector2(1, 1), component.widgetScale, 0.0f);
            component.drawWidget(graphics, x + component.x, y + component.y, component.width, component.height);
            GLRenderHelper.popTransform(graphics);
        }
        if (this.useScissor) {
            GLRenderHelper.popScissor(graphics);
        }
    }
}

