/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.v2.widgets.list.abstr;

import java.util.Collection;
import java.util.LinkedList;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.util.Mth;
import net.sixik.sdmuilib.SDMUILib;
import net.sixik.v2.color.Colors;
import net.sixik.v2.enums.MouseClick;
import net.sixik.v2.render.TextRenderHelper;
import net.sixik.v2.widgets.UIComponent;

public abstract class AbstractDropDownListUIComponent<T>
extends UIComponent {
    public T selectedContent = null;
    public LinkedList<T> components = new LinkedList();
    public int scrollValue;
    public int displayedValue;
    public int maxScrollValue;
    public int maxDisplayedValue;
    public boolean isMouseOverList = false;
    public boolean isOpenedList = false;
    public String ghostText = "";

    public AbstractDropDownListUIComponent() {
        this(1);
    }

    public AbstractDropDownListUIComponent(int maxDisplayedValue) {
        this.maxDisplayedValue = maxDisplayedValue;
        this.scrollValue = 0;
        this.maxScrollValue = 0;
        this.displayedValue = 0;
    }

    public AbstractDropDownListUIComponent<T> setSelectedValue(T value) {
        this.selectedContent = value;
        return this;
    }

    public AbstractDropDownListUIComponent<T> setGhostText(String ghostText) {
        this.ghostText = ghostText;
        return this;
    }

    public AbstractDropDownListUIComponent<T> setGhostText(Object ghostText) {
        this.ghostText = TextRenderHelper.getText(ghostText);
        return this;
    }

    public AbstractDropDownListUIComponent<T> addContent(T content) {
        this.components.add(content);
        return this.resize();
    }

    public AbstractDropDownListUIComponent<T> addContent(Collection<T> content) {
        this.components.addAll(content);
        return this.resize();
    }

    public AbstractDropDownListUIComponent<T> resize() {
        this.displayedValue = Math.min(this.maxDisplayedValue, this.components.size());
        this.maxScrollValue = this.components.size() - this.displayedValue;
        return this;
    }

    public AbstractDropDownListUIComponent<T> scroll(int scroll) {
        this.scrollValue = Math.min(this.maxScrollValue, Math.max(0, scroll));
        return this;
    }

    public int getListHeight() {
        return this.isOpenedList ? this.height + this.maxDisplayedValue * this.getContentHeight() : this.height;
    }

    public int getContentHeight() {
        return TextRenderHelper.getTextHeight() + 1;
    }

    public abstract void onClickContent(T var1);

    @Override
    public boolean mousePressed(double mouseX, double mouseY, MouseClick mouseClick) {
        this.onClick(mouseX, mouseY, mouseClick);
        return true;
    }

    @Override
    public void onClick(double mouseX, double mouseY, MouseClick mouseClick) {
        if (this.isOpenedList && this.isMouseOverList) {
            int clickedLine = ((int)mouseY - this.getY() - this.getContentHeight()) / this.getContentHeight() + this.scrollValue;
            if (--clickedLine < 0 || clickedLine >= this.components.size()) {
                SDMUILib.LOGGER.error("Selected line is out of bound: " + clickedLine + "/" + this.components.size());
                return;
            }
            this.selectedContent = this.components.get(clickedLine);
            this.onClickContent(this.components.get(clickedLine));
        }
        boolean bl = this.isOpenedList = !this.isOpenedList;
        if (this.isOpenedList) {
            this.renderContext.setFocusedComponent(this);
        } else {
            this.renderContext.setFocusedComponent(null);
        }
    }

    @Override
    public boolean isMouseOver(double mouseX, double mouseY) {
        if (this.isOpenedList) {
            this.isMouseOver = this.checkMouseOver(mouseX, mouseY, this.getX(), this.getY() + this.height, this.width, this.getListHeight());
            if (this.isMouseOver) {
                this.isMouseOverList = true;
                return true;
            }
        }
        this.isMouseOverList = false;
        return super.isMouseOver(mouseX, mouseY);
    }

    @Override
    public boolean mouseScrolled(double x, double y, double scroll) {
        if (this.isOpenedList) {
            this.scroll(this.scrollValue - Mth.m_14205_((double)scroll));
            return true;
        }
        return false;
    }

    @Override
    public void drawBackground(GuiGraphics graphics, int x, int y, int w, int h) {
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_(0.0f, 0.0f, 900.0f);
        this.drawList(graphics, x, y, w, h);
        graphics.m_280168_().m_85849_();
    }

    public abstract void drawList(GuiGraphics var1, int var2, int var3, int var4, int var5);

    public void drawScrollBar(GuiGraphics graphics, int x, int y, int w, int h) {
        int sizePerScroll = Math.max(h / this.maxScrollValue, h / (this.maxScrollValue + 1));
        int scrollBarY = y + (int)((float)this.scrollValue / (float)this.maxScrollValue * (float)(h - sizePerScroll));
        Colors.UI_GOLD_0.draw(graphics, x + w - this.getWeightScrollBar(), scrollBarY, this.getWeightScrollBar(), sizePerScroll);
    }

    public int getWeightScrollBar() {
        return 2;
    }
}

