/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.v2.widgets.list;

import net.minecraft.client.gui.GuiGraphics;
import net.sixik.v2.color.RGBA;
import net.sixik.v2.enums.MouseClick;
import net.sixik.v2.render.GLRenderHelper;
import net.sixik.v2.utils.math.Vector2;
import net.sixik.v2.widgets.UIComponent;
import net.sixik.v2.widgets.panel.UIPanel;

public abstract class WidgetHideListUIComponent
extends UIPanel {
    public boolean isListHide = true;

    public WidgetHideListUIComponent setListHide(boolean isListHide) {
        this.isListHide = isListHide;
        return this;
    }

    @Override
    public void addWidget(UIComponent component) {
        if (this.gui != null) {
            component.setGui(this.gui);
        }
        if (component instanceof UIPanel) {
            UIPanel panel = (UIPanel)component;
            panel.addWidgets();
        }
        this.components.addLast(component.setParent(this).setWidgetIndex(this.components.size()).setOffset(this.getX(), this.getY()).setRenderContext(this.renderContext));
    }

    @Override
    public UIComponent setHeight(int height) {
        for (UIComponent component : this.components) {
            component.offsetY += height;
        }
        return super.setHeight(height);
    }

    @Override
    public boolean mousePressed(double mouseX, double mouseY, MouseClick mouseClick) {
        if (mouseClick.isLeft()) {
            if (this.isMouseOver) {
                boolean bl = this.isListHide = !this.isListHide;
                if (this.parentPanel != null) {
                    this.parentPanel.refreshWidget();
                }
                return true;
            }
            if (!this.isListHide) {
                return super.mousePressed(mouseX, mouseY, mouseClick);
            }
        }
        return false;
    }

    @Override
    public boolean isMouseOver(double mouseX, double mouseY) {
        if (!this.isListHide) {
            for (int i = this.components.size() - 1; i >= 0; --i) {
                UIComponent component = (UIComponent)this.components.get(i);
                if (!component.renderType.isAllRender() || !this.renderContext.isFocusedComponent(component) || !component.isMouseOver(mouseX, mouseY)) continue;
                return true;
            }
        }
        this.isMouseOver = mouseX >= (double)this.getX() && mouseX < (double)(this.getX() + this.width) && mouseY >= (double)this.getY() && mouseY < (double)(this.getY() + this.height);
        return this.isMouseOver;
    }

    @Override
    public int getHeight() {
        if (this.isListHide) {
            return this.height;
        }
        int height = this.height;
        for (UIComponent component : this.components) {
            height += component.getHeight();
        }
        return height;
    }

    @Override
    public int getWidth() {
        if (this.isListHide) {
            return this.width;
        }
        int width = this.width;
        for (UIComponent component : this.components) {
            width = Math.max(width, component.getWidth());
        }
        return width;
    }

    @Override
    public void drawWidget(GuiGraphics graphics, int x, int y, int w, int h) {
        this.tickWidget();
        this.drawBackground(graphics, x, y, w, h);
        if (!this.isListHide) {
            for (int i = this.components.size() - 1; i >= 0; --i) {
                UIComponent component = (UIComponent)this.components.get(i);
                if (!component.renderType.isOnlyRender() && !component.renderType.isAllRender()) continue;
                GLRenderHelper.pushTransform(graphics, new Vector2(x, y), new Vector2(1, 1), component.widgetScale, 0.0f);
                component.drawWidget(graphics, x + component.x, y + this.height + component.y, component.width, component.height);
                GLRenderHelper.popTransform(graphics);
            }
        }
    }

    @Override
    public void drawBackground(GuiGraphics graphics, int x, int y, int w, int h) {
        RGBA.create(0, 0, 0, 85).draw(graphics, x, y, w, h);
        if (!this.isListHide || this.isMouseOver) {
            RGBA.create(255, 255, 255, 255).draw(graphics, x + 2, y + 1, 1, h - 2);
        } else {
            RGBA.create(128, 128, 128, 255).draw(graphics, x + 2, y + 1, 1, h - 2);
        }
    }
}

