/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.v2.widgets.list;

import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.sixik.v2.color.RGBA;
import net.sixik.v2.render.TextRenderHelper;
import net.sixik.v2.widgets.list.abstr.AbstractDropDownListUIComponent;

public abstract class DropDownListUIComponent<T>
extends AbstractDropDownListUIComponent<T> {
    public DropDownListUIComponent() {
    }

    public DropDownListUIComponent(int maxDisplayedValue) {
        super(maxDisplayedValue);
    }

    @Override
    public void drawList(GuiGraphics graphics, int x, int y, int w, int h) {
        if (this.isMouseOver) {
            RGBA.create(255, 255, 255, 85).draw(graphics, x, y, w, h);
        } else {
            RGBA.create(0, 0, 0, 85).draw(graphics, x, y, w, h);
        }
        if (this.selectedContent != null) {
            TextRenderHelper.drawTextOverWight(graphics, (Object)this.contentDisplayName(this.selectedContent), x + 1, y + 1, w);
        } else {
            TextRenderHelper.drawTextOverWight(graphics, (Object)Component.m_237113_((String)this.ghostText).m_130940_(ChatFormatting.GRAY).m_130940_(ChatFormatting.ITALIC), x + 1, y + 1, w);
        }
        if (this.isOpenedList) {
            int f = y;
            y += this.height;
            for (int i = 0; i < this.displayedValue && this.scrollValue + i < this.components.size(); ++i) {
                this.drawContent(graphics, x, y, w, this.getContentHeight(), this.components.get(this.scrollValue + i), i);
                y += this.getContentHeight();
            }
            this.drawScrollBar(graphics, x, f + this.height, w, this.getContentHeight() * this.maxDisplayedValue);
        }
    }

    public void drawContent(GuiGraphics graphics, int x, int y, int w, int h, T content, int i) {
        if (this.checkMouseOver(mouseX, mouseY, x, y, w, h)) {
            RGBA.create(255, 255, 255, 85).draw(graphics, x, y, w, h);
        } else {
            RGBA.create(0, 0, 0, 85).draw(graphics, x, y, w, h);
        }
        TextRenderHelper.drawText(graphics, this.contentDisplayName(content), x + 1, y + 1);
    }

    public Component contentDisplayName(T content) {
        return Component.m_237113_((String)content.toString());
    }
}

