/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.v2.widgets.alight;

import java.util.LinkedList;
import net.minecraft.client.gui.GuiGraphics;
import net.sixik.v2.enums.KeyboardKey;
import net.sixik.v2.enums.MouseClick;
import net.sixik.v2.render.GLRenderHelper;
import net.sixik.v2.utils.math.Vector2;
import net.sixik.v2.widgets.UIComponent;

public class AlightContainerUIComponent
extends UIComponent {
    private LinkedList<UIComponent> components = new LinkedList();
    private int[][] matrix = new int[][]{{0}};

    public AlightContainerUIComponent setMatrix(int[][] matrix) {
        this.matrix = matrix;
        return this;
    }

    public AlightContainerUIComponent addWidget(UIComponent component) {
        this.components.add(component.setParent(this.parentPanel).setWidgetIndex(this.components.size()).setOffset(this.getX(), this.getY()).setRenderContext(this.renderContext));
        return this;
    }

    @Override
    public void drawWidget(GuiGraphics graphics, int x, int y, int w, int h) {
        this.tickWidget();
        this.drawBackground(graphics, x, y, w, h);
        for (int i = this.components.size() - 1; i >= 0; --i) {
            UIComponent component = this.components.get(i);
            if (!component.renderType.isOnlyRender() && !component.renderType.isAllRender()) continue;
            GLRenderHelper.pushTransform(graphics, new Vector2(x, y), new Vector2(1, 1), component.widgetScale, 0.0f);
            component.drawWidget(graphics, x + component.x, y + component.y, component.width, component.height);
            GLRenderHelper.popTransform(graphics);
        }
    }

    public int getWeightByLine(int line) {
        int counts;
        if (line >= 0 && line < this.matrix.length && (counts = this.matrix[line].length - 1) > 0) {
            return this.width / counts;
        }
        return 0;
    }

    public int getHeightElements() {
        if (this.matrix.length > 0) {
            return this.height / this.matrix.length;
        }
        return 0;
    }

    public void alightWidgets() {
        int f = 0;
        for (int i = 0; i < this.matrix.length; ++i) {
            for (int j = 0; j < this.matrix[i].length && f < this.components.size(); ++f, ++j) {
                UIComponent component = this.components.get(f);
                component.x = j * this.getWeightByLine(i);
                component.y = i * this.getHeightElements();
                component.width = this.getWeightByLine(i);
                component.height = this.getHeightElements();
            }
        }
    }

    @Override
    public boolean isMouseOver(double mouseX, double mouseY) {
        for (int i = this.components.size() - 1; i >= 0; --i) {
            UIComponent component = this.components.get(i);
            if (!component.renderType.isAllRender() || !this.renderContext.isFocusedComponent(component) || !component.isMouseOver(mouseX, mouseY)) continue;
            return true;
        }
        this.isMouseOver = mouseX >= (double)this.getX() && mouseX < (double)(this.getX() + this.width) && mouseY >= (double)this.getY() && mouseY < (double)(this.getY() + this.height);
        return this.isMouseOver;
    }

    @Override
    public boolean mousePressed(double mouseX, double mouseY, MouseClick mouseClick) {
        for (int i = this.components.size() - 1; i >= 0; --i) {
            UIComponent component = this.components.get(i);
            if (component.renderType.isAllRender() && this.renderContext.isFocusedComponent(component)) {
                if (component.isMouseOver && component.mousePressed(mouseX, mouseY, mouseClick)) {
                    component.isFocused = true;
                    return false;
                }
                if (component.isMouseOver) continue;
                component.isFocused = false;
                continue;
            }
            component.isFocused = false;
        }
        return true;
    }

    @Override
    public boolean mouseScrolled(double x, double y, double scroll) {
        for (int i = this.components.size() - 1; i >= 0; --i) {
            UIComponent component = this.components.get(i);
            if (!component.renderType.isAllRender() || !component.isMouseOver || !this.renderContext.isFocusedComponent(component) || !component.mouseScrolled(x, y, scroll)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean mouseDragged(double mouseX, double mouseY, MouseClick mouseClick, double dragX, double dragY) {
        for (int i = this.components.size() - 1; i >= 0; --i) {
            UIComponent component = this.components.get(i);
            if (!component.renderType.isAllRender() || !component.isMouseOver || !this.renderContext.isFocusedComponent(component) || !component.mouseDragged(mouseX, mouseY, mouseClick, dragX, dragY)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, MouseClick mouseClick) {
        for (int i = this.components.size() - 1; i >= 0; --i) {
            UIComponent component = this.components.get(i);
            if (!component.renderType.isAllRender() || !component.isMouseOver || !this.renderContext.isFocusedComponent(component) || !component.mouseReleased(mouseX, mouseY, mouseClick)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean keyPressed(KeyboardKey key) {
        for (int i = this.components.size() - 1; i >= 0; --i) {
            if (!this.components.get(i).keyPressed(key)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean keyReleased(KeyboardKey key) {
        for (int i = this.components.size() - 1; i >= 0; --i) {
            if (!this.components.get(i).keyReleased(key)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean charTyped(char keyChar, int modifiers) {
        for (int i = this.components.size() - 1; i >= 0; --i) {
            UIComponent component = this.components.get(i);
            if (!component.renderType.isAllRender() || !component.isFocused || !component.charTyped(keyChar, modifiers)) continue;
            return false;
        }
        return true;
    }
}

