/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.v2.utils.math;

import net.sixik.v2.utils.math.Vector2d;
import net.sixik.v2.utils.math.Vector2f;

public class Vector2 {
    public int x;
    public int y;

    public Vector2(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }

    public void setPosition(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public Vector2 add(Vector2 other) {
        return new Vector2(this.x + other.x, this.y + other.y);
    }

    public Vector2 subtract(Vector2 other) {
        return new Vector2(this.x - other.x, this.y - other.y);
    }

    public Vector2 multiply(int scalar) {
        return new Vector2(this.x * scalar, this.y * scalar);
    }

    public Vector2 divide(int scalar) {
        return new Vector2(this.x / scalar, this.y / scalar);
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public Vector2 normalize() {
        double len = this.length();
        return new Vector2((int)((double)this.x / len), (int)((double)this.y / len));
    }

    public double dot(Vector2 other) {
        return this.x * other.x + this.y * other.y;
    }

    public Vector2 cross(Vector2 other) {
        return new Vector2(this.y * other.x - this.x * other.y, this.x * other.y + this.y * other.x);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Vector2)) {
            return false;
        }
        Vector2 other = (Vector2)obj;
        return this.x == other.x && this.y == other.y;
    }

    public static Vector2 of(int x, int y) {
        return new Vector2(x, y);
    }

    public Vector2 toVector2() {
        return new Vector2(this.x, this.y);
    }

    public Vector2f toVector2f() {
        return new Vector2f(this.x, this.y);
    }

    public Vector2d toVector2d() {
        return new Vector2d(this.x, this.y);
    }

    public String toString() {
        return "Vector2{x=" + this.x + ", y=" + this.y + "}";
    }
}

