/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.v2.utils.math;

import java.util.Objects;
import net.minecraft.core.Vec3i;
import net.minecraft.world.phys.Vec3;

public class BoundDoubleBox {
    public double x1;
    public double y1;
    public double z1;
    public double x2;
    public double y2;
    public double z2;

    public BoundDoubleBox(double x1, double y1, double z1, double x2, double y2, double z2) {
        this.x1 = x1;
        this.y1 = y1;
        this.z1 = z1;
        this.x2 = x2;
        this.y2 = y2;
        this.z2 = z2;
    }

    public BoundDoubleBox move(Vec3 pos) {
        return this.move(pos.f_82479_, pos.f_82480_, pos.f_82481_);
    }

    public BoundDoubleBox move(double x, double y, double z) {
        this.x1 += x;
        this.y1 += y;
        this.z1 += z;
        this.x2 += x;
        this.y2 += y;
        this.z2 += z;
        return this;
    }

    public double x1() {
        return this.x1;
    }

    public double y1() {
        return this.y1;
    }

    public double z1() {
        return this.z1;
    }

    public double x2() {
        return this.x2;
    }

    public double y2() {
        return this.y2;
    }

    public double z2() {
        return this.z2;
    }

    public boolean isInside(Vec3i pos) {
        return this.isInside(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }

    public boolean isInside(int x, int y, int z) {
        return (double)x >= this.x1 && (double)x <= this.x2 && (double)z >= this.z1 && (double)z <= this.z2 && (double)y >= this.y1 && (double)y <= this.y2;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        BoundDoubleBox that = (BoundDoubleBox)obj;
        return Double.doubleToLongBits(this.x1) == Double.doubleToLongBits(that.x1) && Double.doubleToLongBits(this.y1) == Double.doubleToLongBits(that.y1) && Double.doubleToLongBits(this.z1) == Double.doubleToLongBits(that.z1) && Double.doubleToLongBits(this.x2) == Double.doubleToLongBits(that.x2) && Double.doubleToLongBits(this.y2) == Double.doubleToLongBits(that.y2) && Double.doubleToLongBits(this.z2) == Double.doubleToLongBits(that.z2);
    }

    public int hashCode() {
        return Objects.hash(this.x1, this.y1, this.z1, this.x2, this.y2, this.z2);
    }

    public String toString() {
        return "BoundDoubleBox[x1=" + this.x1 + ", y1=" + this.y1 + ", z1=" + this.z1 + ", x2=" + this.x2 + ", y2=" + this.y2 + ", z2=" + this.z2 + "]";
    }
}

