/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.v2.render;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.sixik.v2.color.RGB;
import net.sixik.v2.render.RenderHelper;
import net.sixik.v2.utils.math.Vector2;

public class TextureRenderHelper {
    public static void renderTexture(GuiGraphics guiGraphics, String texture, Vector2 pos, Vector2 size, Vector2 uv, Vector2 textureSize) {
        RenderHelper.renderTexture(guiGraphics, texture, pos.x, pos.y, size.x, size.y, uv.x, uv.y, textureSize.x, textureSize.y);
    }

    public static void renderTexture(GuiGraphics guiGraphics, String texture, int x, int y, int width, int height, int textureX, int textureY, int textureW, int textureH) {
        RenderHelper.renderTexture(guiGraphics, texture, x, y, width, height, textureX, textureY, textureW, textureH);
    }

    public static void renderTextureRect(GuiGraphics graphics, int x, int y, int w, int h, RGB col, float u0, float v0, float u1, float v1) {
        RenderSystem.setShader(GameRenderer::m_172814_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        BufferBuilder buffer = Tesselator.m_85913_().m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85818_);
        RenderHelper.addRectToBufferWithUV(graphics, buffer, x, y, w, h, col, u0, v0, u1, v1);
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)buffer.m_231175_());
    }

    public static void renderSlicedTexture(GuiGraphics guiGraphics, ResourceLocation texture, int x, int y, int width, int height, int sliceSize, int textureW, int textureH) {
        int rightX = x + width - sliceSize;
        int bottomY = y + height - sliceSize;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        guiGraphics.m_280411_(texture, x, y, sliceSize, sliceSize, 0.0f, 0.0f, sliceSize, sliceSize, textureW, textureH);
        guiGraphics.m_280411_(texture, rightX, y, sliceSize, sliceSize, (float)(textureW - sliceSize), 0.0f, sliceSize, sliceSize, textureW, textureH);
        guiGraphics.m_280411_(texture, x, bottomY, sliceSize, sliceSize, 0.0f, (float)(textureH - sliceSize), sliceSize, sliceSize, textureW, textureH);
        guiGraphics.m_280411_(texture, rightX, bottomY, sliceSize, sliceSize, (float)(textureW - sliceSize), (float)(textureH - sliceSize), sliceSize, sliceSize, textureW, textureH);
        guiGraphics.m_280411_(texture, x + sliceSize, y, width - sliceSize * 2, sliceSize, (float)sliceSize, 0.0f, textureW - sliceSize * 2, sliceSize, textureW, textureH);
        guiGraphics.m_280411_(texture, x + sliceSize, bottomY, width - sliceSize * 2, sliceSize, (float)sliceSize, (float)(textureH - sliceSize), textureW - sliceSize * 2, sliceSize, textureW, textureH);
        guiGraphics.m_280411_(texture, x, y + sliceSize, sliceSize, height - sliceSize * 2, 0.0f, (float)sliceSize, sliceSize, textureH - sliceSize * 2, textureW, textureH);
        guiGraphics.m_280411_(texture, rightX, y + sliceSize, sliceSize, height - sliceSize * 2, (float)(textureW - sliceSize), (float)sliceSize, sliceSize, textureH - sliceSize * 2, textureW, textureH);
        guiGraphics.m_280411_(texture, x + sliceSize, y + sliceSize, width - sliceSize * 2, height - sliceSize * 2, (float)sliceSize, (float)sliceSize, textureW - sliceSize * 2, textureH - sliceSize * 2, textureW, textureH);
        RenderSystem.disableBlend();
    }

    public static Vector2 getTextureSize(ResourceLocation texture) {
        Minecraft minecraft = Minecraft.m_91087_();
        TextureManager textureManager = minecraft.m_91097_();
        AbstractTexture abstractTexture = textureManager.m_118506_(texture);
        if (abstractTexture != null) {
            NativeImage nativeImage;
            NativeImage nativeImage2 = nativeImage = abstractTexture instanceof DynamicTexture ? ((DynamicTexture)abstractTexture).m_117991_() : null;
            if (nativeImage != null) {
                int textureWidth = nativeImage.m_84982_();
                int textureHeight = nativeImage.m_85084_();
                return new Vector2(textureWidth, textureHeight);
            }
        }
        return new Vector2(0, 0);
    }
}

