/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.v2.render;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.util.RandomSource;
import net.sixik.v2.color.RGB;
import net.sixik.v2.render.GLRenderHelper;
import net.sixik.v2.utils.math.Vector2;

public class RandomRenderHelper {
    public static void renderObjectWithSizeAndPos(GuiGraphics graphics, Vector2 minPos, Vector2 maxPos, Vector2 minScale, Vector2 maxScale, Object object, RGB rgb) {
        Vector2 size = RandomRenderHelper.getRandomScale(minScale, maxScale);
        Vector2 pos = RandomRenderHelper.getRandomPosInZone(minPos, maxPos);
        RandomRenderHelper.rO(graphics, pos, size, object, rgb);
    }

    public static void renderObjectWithSize(GuiGraphics graphics, Vector2 pos, Vector2 minScale, Vector2 maxScale, Object object, RGB rgb) {
        Vector2 size = RandomRenderHelper.getRandomScale(minScale, maxScale);
        RandomRenderHelper.rO(graphics, pos, size, object, rgb);
    }

    public static void renderObjectWithRotation(GuiGraphics graphics, Vector2 pos, Vector2 size, Object object, RGB rgb) {
        RandomSource source = RandomSource.m_216327_();
        GLRenderHelper.pushTransform(graphics, pos, size, 1.0f, source.m_188501_() * 360.0f);
        RandomRenderHelper.rO(graphics, pos, size, object, rgb);
        GLRenderHelper.popTransform(graphics);
    }

    public static void renderObjectWithRotationAndPos(GuiGraphics graphics, Vector2 minPos, Vector2 maxPos, Vector2 size, Object object, RGB rgb) {
        RandomSource source = RandomSource.m_216327_();
        Vector2 pos = RandomRenderHelper.getRandomPosInZone(minPos, maxPos);
        GLRenderHelper.pushTransform(graphics, pos, size, 1.0f, source.m_188501_() * 360.0f);
        RandomRenderHelper.rO(graphics, pos, size, object, rgb);
        GLRenderHelper.popTransform(graphics);
    }

    public static void renderObject(GuiGraphics graphics, Vector2 minPos, Vector2 maxPos, Vector2 minScale, Vector2 maxScale, Object object, RGB rgb) {
        RandomSource source = RandomSource.m_216327_();
        Vector2 pos = RandomRenderHelper.getRandomPosInZone(minPos, maxPos);
        Vector2 size = RandomRenderHelper.getRandomScale(minScale, maxScale);
        GLRenderHelper.pushTransform(graphics, pos, size, 1.0f, source.m_188501_() * 360.0f);
        RandomRenderHelper.rO(graphics, pos, size, object, rgb);
        GLRenderHelper.popTransform(graphics);
    }

    public static void renderObjectCount(GuiGraphics graphics, int count, Vector2 minPos, Vector2 maxPos, Vector2 minScale, Vector2 maxScale, Object object, RGB rgb) {
        for (int i = 0; i < count; ++i) {
            RandomRenderHelper.renderObject(graphics, minPos, maxPos, minScale, maxScale, object, rgb);
        }
    }

    private static void rO(GuiGraphics graphics, Vector2 pos, Vector2 size, Object object, RGB rgb) {
        switch (object) {
            case CUBE: {
                rgb.draw(graphics, pos.x, pos.y, size.x, size.y);
                break;
            }
            case TRIANGLE: {
                rgb.drawTriangle(graphics, pos.x, pos.y, size.x, size.y);
            }
        }
    }

    public static Vector2 getRandomScale(Vector2 minScale, Vector2 maxScale) {
        RandomSource source = RandomSource.m_216327_();
        return new Vector2(source.m_216339_(minScale.x, maxScale.x), source.m_216339_(minScale.y, maxScale.y));
    }

    public static Vector2 getRandomPosInZone(Vector2 startPos, Vector2 endPos) {
        RandomSource source = RandomSource.m_216327_();
        return new Vector2(source.m_216339_(startPos.x, endPos.x), source.m_216339_(startPos.y, endPos.y));
    }

    public static enum Object {
        CUBE,
        TRIANGLE;

    }
}

