/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.v2.color;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.sixik.v2.color.RGBA;
import net.sixik.v2.render.TextureRenderHelper;
import org.joml.Matrix4f;

public class TextureColor
extends RGBA {
    public ResourceLocation textureID;
    public double tileSize;
    public float minU;
    public float minV;
    public float maxU;
    public float maxV;

    protected TextureColor(ResourceLocation textureID) {
        super(255, 255, 255, 255);
        this.textureID = textureID;
        this.minU = 0.0f;
        this.minV = 0.0f;
        this.maxU = 1.0f;
        this.maxV = 1.0f;
        this.tileSize = 0.0;
    }

    public static TextureColor create(ResourceLocation textureID) {
        return new TextureColor(textureID);
    }

    @Override
    public TextureColor copy() {
        return new TextureColor(this.textureID).withColor(RGBA.create(this.r, this.g, this.b, this.a)).withUV(this.minU, this.minV, this.maxU, this.maxV);
    }

    public TextureColor withColor(RGBA color) {
        this.r = color.r;
        this.g = color.g;
        this.b = color.b;
        this.a = color.a;
        return this;
    }

    public TextureColor withUV(float minU, float minV, float maxU, float maxV) {
        this.minU = minU;
        this.minV = minV;
        this.maxU = maxU;
        this.maxV = maxV;
        return this;
    }

    public void setupTexture() {
        TextureManager manager = Minecraft.m_91087_().m_91097_();
        AbstractTexture tex = manager.m_118506_(this.textureID);
        if (tex == null) {
            tex = new SimpleTexture(this.textureID);
            manager.m_118495_(this.textureID, tex);
        }
        RenderSystem.setShaderTexture((int)0, (int)tex.m_117963_());
    }

    @Override
    public void draw(GuiGraphics graphics, int x, int y, int w, int h) {
        this.setupTexture();
        if (this.tileSize <= 0.0) {
            TextureRenderHelper.renderTextureRect(graphics, x, y, w, h, this, this.minU, this.minV, this.maxU, this.maxV);
        } else {
            int r = this.r;
            int g = this.g;
            int b = this.b;
            int a = this.a;
            Matrix4f m = graphics.m_280168_().m_85850_().m_252922_();
            Tesselator tesselator = Tesselator.m_85913_();
            BufferBuilder buffer = tesselator.m_85915_();
            RenderSystem.setShader(GameRenderer::m_172814_);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85818_);
            buffer.m_252986_(m, (float)x, (float)(y + h), 0.0f).m_6122_(r, g, b, a).m_7421_((float)((double)x / this.tileSize), (float)((double)(y + h) / this.tileSize)).m_5752_();
            buffer.m_252986_(m, (float)(x + w), (float)(y + h), 0.0f).m_6122_(r, g, b, a).m_7421_((float)((double)(x + w) / this.tileSize), (float)((double)(y + h) / this.tileSize)).m_5752_();
            buffer.m_252986_(m, (float)(x + w), (float)y, 0.0f).m_6122_(r, g, b, a).m_7421_((float)((double)(x + w) / this.tileSize), (float)((double)y / this.tileSize)).m_5752_();
            buffer.m_252986_(m, (float)x, (float)y, 0.0f).m_6122_(r, g, b, a).m_7421_((float)((double)x / this.tileSize), (float)((double)y / this.tileSize)).m_5752_();
            tesselator.m_85914_();
        }
    }

    @Override
    public void drawTriangle(GuiGraphics graphics, int x, int y, int w, int h) {
    }

    @Override
    public void drawRoundFill(GuiGraphics guiGraphics, int x, int y, int width, int height, int radius) {
    }

    @Override
    public void drawCircle(GuiGraphics graphics, int x, int y, int radius, int segments) {
    }

    @Override
    public void drawLine(GuiGraphics graphics, int x, int y, int x2, int y2, float lineWidth) {
    }
}

