/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.v2.color;

import net.sixik.v2.color.RGB;

public class RGBA
extends RGB {
    public int a;

    protected RGBA(int r, int g, int b, int a) {
        super(r, g, b);
        this.a = a;
    }

    @Override
    public RGB copy() {
        return new RGBA(this.r, this.g, this.b, this.a);
    }

    public static RGBA fromRGB(int r, int g, int b) {
        return new RGBA(r, g, b, 255);
    }

    public static RGBA fromRGB(RGB color) {
        return new RGBA(color.r, color.g, color.b, 255);
    }

    public static RGBA fromARGB(int argb) {
        return new RGBA(argb >> 16 & 0xFF, argb >> 8 & 0xFF, argb & 0xFF, argb >> 24 & 0xFF);
    }

    public static RGBA fromHex(String hex) {
        return RGBA.fromARGB(Integer.parseInt(hex, 16));
    }

    public static RGBA create(int r, int g, int b, int a) {
        return new RGBA(r, g, b, a);
    }

    @Override
    public int toInt() {
        return this.a << 24 | this.r << 16 | this.g << 8 | this.b;
    }

    public RGB toRGB() {
        return new RGB(this.r, this.g, this.b);
    }

    @Override
    public RGBA toARGB() {
        return this;
    }

    @Override
    public RGBA withAlpha(int alpha) {
        this.a = alpha;
        return this;
    }

    public static RGBA interpolate(RGBA colorA, RGBA colorC, float t) {
        int r = (int)((1.0f - t) * (float)colorA.r + t * (float)colorC.r);
        int g = (int)((1.0f - t) * (float)colorA.g + t * (float)colorC.g);
        int b = (int)((1.0f - t) * (float)colorA.b + t * (float)colorC.b);
        int a = (int)((1.0f - t) * (float)colorA.a + t * (float)colorC.a);
        return new RGBA(r, g, b, a);
    }
}

