/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.v2.color;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.sixik.v2.color.RGBA;
import net.sixik.v2.interfaces.IElementRender;
import net.sixik.v2.render.RenderHelper;
import net.sixik.v2.render.ShapesRenderHelper;
import net.sixik.v2.utils.math.Vector2f;
import org.joml.Matrix4f;

public class RGB
implements IElementRender {
    public int r;
    public int g;
    public int b;

    protected RGB(int r, int g, int b) {
        this.r = r;
        this.g = g;
        this.b = b;
    }

    public RGB copy() {
        return new RGB(this.r, this.g, this.b);
    }

    public RGBA withAlpha(int alpha) {
        return new RGBA(this.r, this.g, this.b, alpha);
    }

    public static RGB fromHex(String hex) {
        hex = hex.replace("#", "");
        int r = Integer.parseInt(hex.substring(0, 2), 16);
        int g = Integer.parseInt(hex.substring(2, 4), 16);
        int b = Integer.parseInt(hex.substring(4, 6), 16);
        return new RGB(r, g, b);
    }

    public static RGB fromARGB(int argb) {
        return new RGB(argb >> 16 & 0xFF, argb >> 8 & 0xFF, argb & 0xFF);
    }

    public static RGB create(int r, int g, int b) {
        return new RGB(r, g, b);
    }

    public RGBA toARGB() {
        return new RGBA(this.r, this.g, this.b, 255);
    }

    public int toInt() {
        return this.r << 16 | this.g << 8 | this.b;
    }

    public float toFloat() {
        return (float)this.r / 255.0f + (float)this.g / 255.0f + (float)this.b / 255.0f;
    }

    public RGB interpolate(RGB colorA, RGB colorC, float t) {
        int r = (int)((float)colorA.r * (1.0f - t) + (float)colorC.r * t);
        int g = (int)((float)colorA.g * (1.0f - t) + (float)colorC.g * t);
        int b = (int)((float)colorA.b * (1.0f - t) + (float)colorC.b * t);
        return new RGB(r, g, b);
    }

    @Override
    public void draw(GuiGraphics graphics, int x, int y, int width, int height) {
        if (width > 0 && height > 0) {
            RenderSystem.setShader(GameRenderer::m_172811_);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            Tesselator tesselator = Tesselator.m_85913_();
            BufferBuilder buffer = tesselator.m_85915_();
            buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
            RenderHelper.addFillToBuffer(graphics, buffer, x, y, width, height, this);
            tesselator.m_85914_();
        }
    }

    @Override
    public void drawLine(GuiGraphics graphics, int x, int y, int x2, int y2, float lineWidth) {
    }

    @Override
    public void drawCircle(GuiGraphics graphics, int x, int y, int radius, int segments) {
        RenderSystem.setShader(GameRenderer::m_172811_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferBuilder = tesselator.m_85915_();
        Matrix4f matrix = graphics.m_280168_().m_85850_().m_252922_();
        bufferBuilder.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85815_);
        ShapesRenderHelper.drawCircle(matrix, bufferBuilder, new Vector2f(x, y), (float)radius, segments, this);
        tesselator.m_85914_();
        RenderSystem.disableBlend();
    }

    @Override
    public void drawTriangle(GuiGraphics graphics, int x, int y, int w, int h) {
        if (w > 0 && h > 0) {
            RenderSystem.setShader(GameRenderer::m_172811_);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            Tesselator tesselator = Tesselator.m_85913_();
            BufferBuilder buffer = tesselator.m_85915_();
            RenderHelper.addFillTriangleToBuffer(graphics, buffer, x, y, w, h, this);
            tesselator.m_85914_();
            RenderSystem.disableBlend();
        }
    }

    @Override
    public void drawRoundFill(GuiGraphics guiGraphics, int x, int y, int width, int height, int radius) {
        RenderSystem.setShader(GameRenderer::m_172811_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderHelper.drawRoundedRect(guiGraphics, x, y, width, height, radius, this);
        RenderSystem.disableBlend();
    }
}

