/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.v2.animation;

import net.minecraft.client.gui.GuiGraphics;
import net.sixik.v2.animation.AnimationCondition;
import net.sixik.v2.animation.AnimationManager;
import net.sixik.v2.animation.AnimationSequence;
import net.sixik.v2.animation.functions.AnimationFunction;

public class AnimationContainer {
    protected boolean isStarted = false;
    protected int posX = 0;
    protected int posY = 0;
    protected float scaleX = 0.0f;
    protected float scaleY = 0.0f;
    protected float rotation = 0.0f;
    public AnimationCondition condition;
    public AnimationSequence animationSequence = new AnimationSequence();

    public AnimationContainer(AnimationCondition condition) {
        this.condition = condition;
    }

    public AnimationContainer addFunction(AnimationFunction animationFunction) {
        this.animationSequence.animationFunctions.add(animationFunction.setAnimationContainer(this));
        return this;
    }

    public AnimationContainer addThenFunction(AnimationFunction animationFunction) {
        AnimationSequence lastSequence = this.animationSequence.getLastSequence();
        if (lastSequence.thenSequence == null) {
            lastSequence.thenSequence = new AnimationSequence();
        }
        lastSequence.thenSequence.animationFunctions.add(animationFunction.setAnimationContainer(this));
        return this;
    }

    public final AnimationContainer updatePos(int posX, int posY) {
        this.posX = posX;
        this.posY = posY;
        return this;
    }

    public final AnimationContainer updateScale(float scaleX, float scaleY) {
        this.scaleX = scaleX;
        this.scaleY = scaleY;
        return this;
    }

    public final AnimationContainer updateRotation(float rotation) {
        this.rotation = rotation;
        return this;
    }

    public final AnimationContainer updateParams(int posX, int posY, float scaleX, float scaleY, float rotation) {
        this.posX = posX;
        this.posY = posY;
        this.scaleX = scaleX;
        this.scaleY = scaleY;
        this.rotation = rotation;
        return this;
    }

    @Deprecated
    public AnimationContainer create() {
        AnimationManager.INSTANCE.ANIMATIONS.add(this);
        return this;
    }

    public final void tickAnimation(GuiGraphics graphics) {
        if (!this.isStarted) {
            return;
        }
    }

    public final void startAnimation() {
        this.isStarted = true;
        this.animationSequence.getAnimationFunctions().forEach(AnimationFunction::reset);
    }

    public int getPosY() {
        return this.posY;
    }

    public float getRotation() {
        return this.rotation;
    }

    public float getScaleX() {
        return this.scaleX;
    }

    public float getScaleY() {
        return this.scaleY;
    }

    public int getPosX() {
        return this.posX;
    }
}

