/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmuilib.client.widgetsFake.text;

import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.sixik.sdmuilib.client.utils.RenderHelper;
import net.sixik.sdmuilib.client.utils.misc.RGB;
import net.sixik.sdmuilib.client.widgetsFake.text.SingleLineFakeWidget;

public class MultiLineTextFakeWidget
extends SingleLineFakeWidget {
    public MultiLineTextFakeWidget(Component text) {
        super(text);
    }

    public void calculate() {
        this.lines.clear();
        int currentLine = 0;
        for (String line : this.text.getString().split("\n")) {
            if (Minecraft.m_91087_().f_91062_.m_92895_(line) > this.size.x) {
                String[] words = line.split(" ");
                StringBuilder currentWord = new StringBuilder();
                for (String word : words) {
                    if (Minecraft.m_91087_().f_91062_.m_92895_(currentWord.toString() + " " + word) > this.size.x) {
                        this.lines.add(currentWord.toString());
                        currentWord.setLength(0);
                        ++currentLine;
                    }
                    currentWord.append(word).append(" ");
                }
                if (currentWord.isEmpty()) continue;
                this.lines.add(currentWord.toString());
                continue;
            }
            this.lines.add(line);
        }
    }

    @Override
    public void draw(GuiGraphics graphics) {
        this.calculate();
        RenderHelper.pushScale(graphics, this.position.x, this.position.y, this.textSize);
        int posY = this.position.y;
        for (int i = 0; i < this.lines.size(); ++i) {
            String line = (String)this.lines.get(i);
            graphics.m_280488_(Minecraft.m_91087_().f_91062_, line, this.position.x, posY, RGB.create(255, 255, 255).toInt());
            Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
            posY += 9 * i + 2;
        }
        RenderHelper.popScale(graphics);
    }
}

