/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmuilib.client.widgets.text;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.sixik.sdmuilib.client.utils.math.Vector2;
import net.sixik.sdmuilib.client.utils.misc.RGB;
import net.sixik.sdmuilib.client.widgets.text.SingleLineTextWidget;

public class MultiLineTextWidget
extends SingleLineTextWidget {
    public Component text;
    public List<String> lines = new ArrayList<String>();

    public MultiLineTextWidget(Component text) {
        super((Component)null, (Vector2)null);
        this.text = text;
    }

    public MultiLineTextWidget(Component text, Vector2 size) {
        super((Component)null, size);
        this.text = text;
    }

    public MultiLineTextWidget(Component text, Vector2 position, Vector2 size) {
        super(text, position, size);
        this.text = text;
    }

    public void calculate() {
        this.lines.clear();
        int currentLine = 0;
        for (String line : this.text.getString().split("\n")) {
            if (Minecraft.m_91087_().f_91062_.m_92895_(line) > this.f_93618_) {
                String[] words = line.split(" ");
                StringBuilder currentWord = new StringBuilder();
                for (String word : words) {
                    if (Minecraft.m_91087_().f_91062_.m_92895_(currentWord.toString() + " " + word) > this.f_93618_) {
                        this.lines.add(currentWord.toString());
                        currentWord.setLength(0);
                        ++currentLine;
                    }
                    currentWord.append(word).append(" ");
                }
                if (currentWord.isEmpty()) continue;
                this.lines.add(currentWord.toString());
                continue;
            }
            this.lines.add(line);
        }
    }

    @Override
    public void draw(GuiGraphics graphics, int x, int y, int width, int height, int mouseX, int mouseY, float tick) {
        this.calculate();
        int posY = y;
        for (int i = 0; i < this.lines.size(); ++i) {
            String line = this.lines.get(i);
            graphics.m_280488_(Minecraft.m_91087_().f_91062_, line, x, posY, RGB.create(255, 255, 255).toInt());
            Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
            posY += 9 * i + 2;
        }
    }
}

