/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmuilib.client.widgets.scroll;

import net.minecraft.client.gui.GuiGraphics;
import net.sixik.sdmuilib.client.utils.math.Vector2;
import net.sixik.sdmuilib.client.widgets.RenderWidget;
import net.sixik.sdmuilib.client.widgets.SDMWidget;

public class ScrollWidget
extends RenderWidget {
    private int maxScroll = 0;
    private int scroll;
    public boolean scrolling = false;

    public ScrollWidget(Vector2 position, Vector2 size) {
        super(position, size);
    }

    @Override
    public void draw(GuiGraphics graphics, int x, int y, int width, int height, int mouseX, int mouseY, float tick) {
        if (this.f_93624_) {
            int totalHeight = 0;
            int lastPosY = 0;
            for (SDMWidget widget : this.renderables) {
                if (lastPosY < widget.m_252907_() || totalHeight == 0) {
                    totalHeight += widget.m_93694_();
                    lastPosY = widget.m_252907_();
                }
                this.renderWidget(widget, graphics, x, y - this.scroll, width, height, mouseX, mouseY, tick);
                widget.m_264152_(widget.m_252754_(), widget.m_252907_() - this.scroll);
            }
            if (totalHeight > this.m_93694_()) {
                this.maxScroll = totalHeight - this.m_93694_();
            }
            if (this.maxScroll > 0) {
                this.drawScrollBar(graphics, x + this.m_5711_() - 5, y, height, totalHeight);
            }
        }
    }

    private void drawScrollBar(GuiGraphics graphics, int x, int y, int height, int contentHeight) {
        int scrollbarHeight = Math.max(20, (int)((float)this.m_93694_() / (float)contentHeight * (float)this.m_93694_()));
        int scrollbarY = y + (int)((float)this.scroll / (float)this.maxScroll * (float)(this.m_93694_() - scrollbarHeight));
        graphics.m_280509_(x, y, x + 5, y + this.m_93694_(), -5592406);
        graphics.m_280509_(x, scrollbarY, x + 5, scrollbarY + scrollbarHeight, -16777216);
    }

    @Override
    public boolean m_6050_(double mouseX, double mouseY, double scrollDelta) {
        this.scrolling = true;
        if (this.scrolling) {
            this.scroll = (int)((double)this.scroll - scrollDelta);
        }
        System.out.println(this.scroll);
        return super.m_6050_(mouseX, mouseY, scrollDelta);
    }

    @Override
    public boolean m_6348_(double p_93684_, double p_93685_, int p_93686_) {
        this.scrolling = false;
        return super.m_6348_(p_93684_, p_93685_, p_93686_);
    }

    private void setScroll(int scroll) {
        this.scroll = Math.min(this.maxScroll, Math.max(0, scroll));
        System.out.println(scroll);
    }
}

