/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmuilib.client.widgets.progressBar;

import net.minecraft.client.gui.GuiGraphics;
import net.sixik.sdmuilib.client.utils.RenderHelper;
import net.sixik.sdmuilib.client.utils.math.Vector2;
import net.sixik.sdmuilib.client.widgets.SDMWidget;

public class BasicProgressBarWidget
extends SDMWidget {
    public int widgetImageSize = 81;
    public float progress = 0.0f;

    public BasicProgressBarWidget() {
        this(null, null);
    }

    public BasicProgressBarWidget(Vector2 position) {
        this(position, null);
    }

    public BasicProgressBarWidget(Vector2 position, Vector2 size) {
        super(position, size);
    }

    public void setProgress(float progress) {
        this.progress = progress;
    }

    public void resetProgress() {
        this.progress = 0.0f;
    }

    public void setComplete() {
        this.progress = 1.0f;
        this.onComplete(this.progress);
    }

    public float getProgress() {
        return this.progress;
    }

    public void onProgressChanged(float progress) {
    }

    public void onComplete(float progress) {
    }

    public void addProgress(float progress) {
        if (this.progress < 1.0f) {
            this.progress += progress;
            if (this.progress > 1.0f) {
                this.progress = 1.0f;
                this.onComplete(progress);
            }
            this.onProgressChanged(progress);
        }
    }

    public int getFilling() {
        return (float)((int)this.progress) >= 1.0f ? this.f_93618_ : (int)((float)this.f_93618_ * Math.max(0.0f, Math.min(1.0f, this.progress)));
    }

    public int getFillingImage() {
        return (float)((int)this.progress) >= 1.0f ? this.widgetImageSize : (int)((float)this.widgetImageSize * Math.max(0.0f, Math.min(1.0f, this.progress)));
    }

    @Override
    public void draw(GuiGraphics graphics, int x, int y, int width, int height, int mouseX, int mouseY, float tick) {
        RenderHelper.renderTexture(graphics, "sdm_ui_library:textures/widgets_ss.png", x, y, width, height, 169, 12, this.widgetImageSize, 15, 250, 250);
        RenderHelper.renderTexture(graphics, "sdm_ui_library:textures/widgets_ss_2.png", x, y, this.getFilling(), height, 169, 72, this.getFillingImage(), 15, 250, 250);
    }
}

