/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmuilib.client.widgets.list;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.sixik.sdmuilib.client.utils.GLHelper;
import net.sixik.sdmuilib.client.utils.RenderHelper;
import net.sixik.sdmuilib.client.utils.TextHelper;
import net.sixik.sdmuilib.client.utils.math.Vector2;
import net.sixik.sdmuilib.client.utils.math.Vector2d;
import net.sixik.sdmuilib.client.utils.misc.Colors;
import net.sixik.sdmuilib.client.utils.misc.CursorType;
import net.sixik.sdmuilib.client.widgets.buttons.BasicButtonWidget;

public class BaseDropDownListWidget<T>
extends BasicButtonWidget {
    private Function<T, Component> toNameFunc = t -> Component.m_237113_((String)t.toString());
    private Consumer<T> responder = t -> {};
    private final List<T> possibleValues;
    private T value;
    private final int maxDisplayed;
    private final int maxScroll;
    private int scroll;
    private boolean opened;
    public Vector2 size;
    private int sizeOfTextField = RenderHelper.getTextHeight() + 1;

    public BaseDropDownListWidget(Vector2 pos, int weight, int maxDisplayed, Collection<T> possibleValues, T value) {
        super(pos, new Vector2(weight, RenderHelper.getTextHeight() + 1));
        this.size = new Vector2(weight, this.sizeOfTextField);
        this.possibleValues = new ArrayList<T>(possibleValues);
        this.value = value;
        this.maxDisplayed = maxDisplayed = Math.min(maxDisplayed, possibleValues.size());
        this.maxScroll = possibleValues.size() - maxDisplayed;
        this.opened = false;
    }

    public BaseDropDownListWidget<T> setSizeOfTextField(int sizeOfTextField) {
        this.sizeOfTextField = sizeOfTextField;
        return this;
    }

    public boolean m_6050_(double mouseX, double mouseY, double scrollDelta) {
        if (!this.opened) {
            return false;
        }
        this.setScroll(this.scroll - Mth.m_14205_((double)scrollDelta));
        return false;
    }

    @Override
    public void drawMouseOver(GuiGraphics graphics, int x, int y, int width, int height, float tick) {
        if (this.m_5953_(x, y)) {
            CursorType.set(this.getCursor());
        } else {
            CursorType.set(null);
        }
    }

    @Override
    public void draw(GuiGraphics graphics, int x, int y, int width, int height, int mouseX, int mouseY, float tick) {
        Colors.POLAR_NIGHT_0.draw(graphics, x, y, this.size.x, this.sizeOfTextField, tick);
        String line = this.toNameFunc.apply(this.value).getString();
        TextHelper.drawTextOverWight(graphics, line, new Vector2(x + 1, y + 1), width - 1);
        this.drawList(graphics, x, y + this.sizeOfTextField, this.size.x, this.size.y, mouseX, mouseY, tick);
    }

    public void drawList(GuiGraphics graphics, int x, int y, int width, int height, int mouseX, int mouseY, float tick) {
        if (this.opened) {
            GLHelper.pushScissor(graphics, new Vector2(x, y), new Vector2(width, this.sizeOfTextField * this.maxDisplayed));
            for (int i = 0; i < this.maxDisplayed; ++i) {
                this.drawContent(graphics, x, y, width, this.sizeOfTextField, mouseX, mouseY, tick, i);
                y += this.sizeOfTextField;
            }
            GLHelper.popScissor(graphics);
        }
    }

    public void drawContent(GuiGraphics graphics, int x, int y, int width, int height, int mouseX, int mouseY, float tick, int num) {
        Colors.POLAR_NIGHT_1.draw(graphics, x, y, width, height, tick);
        if (RenderHelper.isMouseOver(Vector2d.create(mouseX, mouseY), Vector2.of(x, y), Vector2.of(width, height))) {
            Colors.POLAR_NIGHT_2.draw(graphics, x, y, width, height, tick);
        }
        String line = this.toNameFunc.apply(this.possibleValues.get(num + this.scroll)).getString();
        TextHelper.drawTextOverWight(graphics, line, new Vector2(++x, ++y), width - 1);
    }

    public BaseDropDownListWidget<T> setToNameFunc(Function<T, Component> function) {
        this.toNameFunc = function;
        this.possibleValues.sort((v1, v2) -> {
            String name1 = ((Component)function.apply(v1)).getString();
            String name2 = ((Component)function.apply(v2)).getString();
            return name1.compareTo(name2);
        });
        return this;
    }

    protected boolean m_93680_(double mouseX, double mouseY) {
        boolean clicked = super.m_93680_(mouseX, mouseY);
        if (!clicked) {
            this.opened = false;
            this.setSize();
        }
        return clicked;
    }

    @Override
    public void m_5716_(double mouseX, double mouseY) {
        boolean bl = this.opened = !this.opened;
        if (RenderHelper.isMouseOver(Vector2d.create(mouseX, mouseY), Vector2.of(this.m_252754_(), this.m_252907_() + this.sizeOfTextField), Vector2.of(this.f_93618_, this.f_93619_))) {
            int clickedLine = ((int)mouseY - this.m_252907_() - this.sizeOfTextField - 1) / this.sizeOfTextField + this.scroll;
            this.value = this.possibleValues.get(clickedLine);
            this.responder.accept(this.value);
        }
        this.setSize();
    }

    public void setSize() {
        if (this.opened) {
            this.f_93618_ = this.size.x;
            this.f_93619_ = this.size.y + this.maxDisplayed * this.sizeOfTextField;
        } else {
            this.f_93618_ = this.size.x;
            this.f_93619_ = this.size.y;
        }
    }

    public BaseDropDownListWidget<T> setResponder(Consumer<T> responder) {
        this.responder = responder;
        return this;
    }

    private void setScroll(int scroll) {
        this.scroll = Math.min(this.maxScroll, Math.max(0, scroll));
    }
}

