/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmuilib.client.utils.misc;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.sixik.sdmuilib.client.render.api.ISDMRender;
import net.sixik.sdmuilib.client.utils.RenderHelper;
import net.sixik.sdmuilib.client.utils.math.Vector2;
import net.sixik.sdmuilib.client.utils.renders.TextureRenderHelper;

public class Texture
implements ISDMRender {
    public ImageType imageType = ImageType.NORMAL;
    public int sliceSize = 10;
    public ResourceLocation texture;
    public Vector2 size = null;
    public Vector2 uv;
    public Vector2 textureSize;

    protected Texture(ResourceLocation texture, Vector2 size, Vector2 UV, Vector2 textureSize) {
        this.texture = texture;
        this.size = size;
        this.uv = UV;
        this.textureSize = textureSize;
    }

    protected Texture(ResourceLocation texture, Vector2 UV, Vector2 textureSize) {
        this.texture = texture;
        this.uv = UV;
        this.textureSize = textureSize;
    }

    public Texture setImageType(ImageType imageType, int sliceSize) {
        this.imageType = imageType;
        this.sliceSize = sliceSize;
        return this;
    }

    public static Texture create(ResourceLocation texture, Vector2 size, Vector2 uv, Vector2 textureSize) {
        return new Texture(texture, size, uv, textureSize);
    }

    public static Texture create(ResourceLocation texture, Vector2 uv, Vector2 textureSize) {
        return new Texture(texture, uv, textureSize);
    }

    public static Texture createAutoTextureSize(ResourceLocation texture, Vector2 size, Vector2 uv) {
        return new Texture(texture, size, uv, TextureRenderHelper.getTextureSize(texture));
    }

    public static Texture createAutoTextureSize(ResourceLocation texture, Vector2 size) {
        return new Texture(texture, size, new Vector2(0, 0), TextureRenderHelper.getTextureSize(texture));
    }

    @Override
    public void draw(GuiGraphics graphics, int x, int y, int width, int height, float tick) {
        this.render(graphics, x, y, width, height, tick);
    }

    protected void render(GuiGraphics graphics, int x, int y, int width, int height, float tick) {
        switch (this.imageType) {
            case NORMAL: {
                if (this.size == null) {
                    RenderHelper.renderTexture(graphics, this.texture.toString(), x, y, width, height, this.uv.x, this.uv.y, this.textureSize.x, this.textureSize.y);
                    break;
                }
                RenderHelper.renderTexture(graphics, this.texture.toString(), x, y, this.size.x, this.size.y, this.uv.x, this.uv.y, this.textureSize.x, this.textureSize.y);
                break;
            }
            case SLICED: {
                if (this.size == null) {
                    TextureRenderHelper.renderSlicedTexture(graphics, this.texture, x, y, width, height, 10, this.textureSize.x, this.textureSize.y);
                    break;
                }
                TextureRenderHelper.renderSlicedTexture(graphics, this.texture, x, y, this.size.x, this.size.y, 10, this.textureSize.x, this.textureSize.y);
            }
        }
    }

    public static enum ImageType {
        SLICED,
        NORMAL;

    }
}

