/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmuilib.client.utils.misc;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.sixik.sdmuilib.client.utils.RenderHelper;
import net.sixik.sdmuilib.client.utils.math.Vector2;
import net.sixik.sdmuilib.client.utils.misc.Texture;

public class AnimationTexture
extends Texture {
    public Vector2 frameSize;
    public int animationSpeed = 1;
    private int tickAnimation = 0;
    public int tickFrame = 0;
    Vector2 a;

    protected AnimationTexture(ResourceLocation texture, Vector2 UV, Vector2 frameSize, Vector2 textureSize) {
        super(texture, new Vector2(0, 0), UV, textureSize);
        this.a = new Vector2(this.uv.x, this.uv.y);
        this.frameSize = frameSize;
    }

    public static AnimationTexture create(ResourceLocation texture, Vector2 UV, Vector2 frameSize, Vector2 textureSize) {
        return new AnimationTexture(texture, UV, frameSize, textureSize);
    }

    @Override
    public void draw(GuiGraphics graphics, int x, int y, int width, int height, float tick) {
        RenderHelper.renderTexture(graphics, this.texture.toString(), x, y, this.frameSize.x, this.frameSize.y, this.a.x, this.a.y, this.frameSize.x, this.frameSize.y);
        this.updateAnimation();
    }

    public void updateAnimation() {
        if (this.tickAnimation % this.animationSpeed == 0) {
            int x = this.a.x + this.frameSize.x;
            int y = this.a.y + this.frameSize.y;
            this.a = x > this.textureSize.x || y > this.textureSize.y ? new Vector2(this.uv.x, this.uv.y) : new Vector2(x, y);
            ++this.tickFrame;
        }
        ++this.tickAnimation;
    }
}

