/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmuilib.client.utils.animation;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.sixik.sdmuilib.client.render.api.ISDMRender;
import net.sixik.sdmuilib.client.utils.GLHelper;
import net.sixik.sdmuilib.client.utils.math.Vector2;
import net.sixik.sdmuilib.client.utils.misc.AnimationContainer;
import net.sixik.sdmuilib.client.widgets.SDMWidget;

public class RotateAnimationContainer
implements AnimationContainer {
    public float rotateSpeed = 0.1f;
    public float rotation = 0.0f;
    private final List<ISDMRender> widgets = new ArrayList<ISDMRender>();

    public static RotateAnimationContainer create() {
        return new RotateAnimationContainer();
    }

    public RotateAnimationContainer addWidget(ISDMRender widget) {
        this.widgets.add(widget);
        return this;
    }

    public RotateAnimationContainer addWidget(ISDMRender ... widget) {
        this.widgets.addAll(new ArrayList<ISDMRender>(List.of(widget)));
        return this;
    }

    @Override
    public List<ISDMRender> getWidgets() {
        return this.widgets;
    }

    @Override
    public AnimationContainer.AnimationType getType() {
        return AnimationContainer.AnimationType.ALL_OBJECT;
    }

    @Override
    public void draw(GuiGraphics graphics, int x, int y, int width, int height, float tick) {
        for (ISDMRender widget : this.getWidgets()) {
            graphics.m_280168_().m_85836_();
            switch (this.getType()) {
                case ALL_OBJECT: {
                    if (widget instanceof SDMWidget) {
                        SDMWidget sdmWidget = (SDMWidget)widget;
                        GLHelper.pushTransform(graphics, new Vector2(sdmWidget.m_252754_(), sdmWidget.m_252907_()), new Vector2(sdmWidget.m_5711_(), sdmWidget.m_93694_()), 1.0f, this.rotation);
                    } else {
                        GLHelper.pushTransform(graphics, new Vector2(x, y), new Vector2(width, height), 1.0f, this.rotation);
                    }
                    GLHelper.popTransform(graphics);
                    break;
                }
                case CUSTOM: {
                    this.customAnimation(widget, graphics, x, y, width, height, this.rotation);
                }
            }
            graphics.m_280168_().m_85849_();
        }
        this.rotation += this.rotateSpeed;
    }

    @Override
    public void customAnimation(ISDMRender widget, GuiGraphics graphics, int x, int y, int width, int height, float tick) {
    }
}

