/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmuilib.client.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.sixik.sdmuilib.client.utils.math.Vector2;
import net.sixik.sdmuilib.client.utils.math.Vector2f;
import net.sixik.sdmuilib.client.utils.misc.RGB;

public class TextHelper {
    public static void drawText(GuiGraphics poseStack, int x, int y, float size, Component text, int textColor) {
        TextHelper.drawText(poseStack, Minecraft.m_91087_().f_91062_, x, y, size, text, textColor);
    }

    public static void drawText(GuiGraphics poseStack, Font font, int x, int y, float size, Component text, int textColor) {
        poseStack.m_280168_().m_85836_();
        poseStack.m_280168_().m_85841_(size, size, 1.0f);
        poseStack.m_280168_().m_252880_((float)x, (float)y, 0.0f);
        poseStack.m_280430_(font, text, x, y, textColor);
        poseStack.m_280168_().m_85849_();
    }

    public static void drawText(GuiGraphics graphics, Component text, int x, int y) {
        graphics.m_280488_(Minecraft.m_91087_().f_91062_, text.getString(), x, y, RGB.create(255, 255, 255).toInt());
    }

    public static void drawText(GuiGraphics graphics, String text, int x, int y) {
        graphics.m_280488_(Minecraft.m_91087_().f_91062_, text, x, y, RGB.create(255, 255, 255).toInt());
    }

    public static void drawText(GuiGraphics graphics, Component text, int x, int y, RGB rgb) {
        graphics.m_280488_(Minecraft.m_91087_().f_91062_, text.getString(), x, y, rgb.toInt());
    }

    public static void drawText(GuiGraphics graphics, String text, int x, int y, RGB rgb) {
        graphics.m_280488_(Minecraft.m_91087_().f_91062_, text, x, y, rgb.toInt());
    }

    public static void drawTextOverWight(GuiGraphics graphics, String text, Vector2 pos, int wight) {
        TextHelper.drawTextOverWight(graphics, Minecraft.m_91087_().f_91062_, text, pos, wight, RGB.create(255, 255, 255));
    }

    public static void drawTextOverWight(GuiGraphics graphics, String text, Vector2 pos, int wight, RGB rgb) {
        TextHelper.drawTextOverWight(graphics, Minecraft.m_91087_().f_91062_, text, pos, wight, rgb);
    }

    public static void drawTextOverWight(GuiGraphics graphics, Font font, String text, Vector2 pos, int wight, RGB rgb) {
        if (font.m_92895_((String)text) > wight - 10) {
            while (font.m_92895_((String)text + "...") > wight - 10) {
                text = ((String)text).substring(0, ((String)text).length() - 1);
            }
            text = (String)text + "...";
        }
        graphics.m_280488_(Minecraft.m_91087_().f_91062_, (String)text, pos.x, pos.y, rgb.toInt());
    }

    public static Vector2f getTextRenderSize(String text, int wight, float scale, int steps) {
        float s = scale;
        float w = 0.0f;
        for (int i = 0; i < steps; ++i) {
            w = TextHelper.getTextWidth(text, s);
            s -= 0.01f;
            if (!(w <= (float)wight)) continue;
            return new Vector2f(w, s);
        }
        return new Vector2f(w, s);
    }

    public static int getTextHeight() {
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        return 9;
    }

    public static float getTextHeight(float scale) {
        return (float)TextHelper.getTextHeight() * scale;
    }

    public static int getTextWidth(String text) {
        return Minecraft.m_91087_().f_91062_.m_92895_(text);
    }

    public static float getTextWidth(String text, float scale) {
        return (float)Minecraft.m_91087_().f_91062_.m_92895_(text) * scale;
    }

    public static List<String> splitTextToLines(String text, float textScale, int maxWidth) {
        if (text.isEmpty()) {
            return Collections.emptyList();
        }
        if (!text.contains(" ") && !text.contains("\n")) {
            return Collections.singletonList(text);
        }
        ArrayList<String> lines = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        int index = 0;
        int wordStartIndex = 0;
        boolean wordProcessing = false;
        char prevSymbol = '0';
        for (char symbol : text.toCharArray()) {
            if (symbol != ' ') {
                wordProcessing = true;
                if (prevSymbol == ' ') {
                    wordStartIndex = index;
                }
            }
            if (symbol == '\n') {
                lines.add(builder.toString());
                builder.delete(0, builder.length());
                index = 0;
                continue;
            }
            if (TextHelper.getTextWidth(builder.toString() + symbol, textScale) <= (float)maxWidth) {
                builder.append(symbol);
            } else {
                if (symbol == '.' || symbol == ',' || symbol == '!' || symbol == '?') {
                    builder.append(symbol);
                }
                if (wordProcessing) {
                    lines.add(builder.toString().substring(0, wordStartIndex));
                    builder.delete(0, wordStartIndex);
                } else {
                    lines.add(builder.toString());
                    builder.delete(0, builder.length());
                }
                if (symbol != ' ') {
                    builder.append(symbol);
                }
                index = builder.length() - 1;
            }
            wordProcessing = false;
            prevSymbol = symbol;
            ++index;
        }
        if (builder.length() != 0) {
            lines.add(builder.toString());
        }
        return lines;
    }
}

