/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmuilib.client.utils;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.AABB;
import net.sixik.sdmuilib.client.utils.GLHelper;
import net.sixik.sdmuilib.client.utils.ShapesRender;
import net.sixik.sdmuilib.client.utils.math.Vector2;
import net.sixik.sdmuilib.client.utils.math.Vector2d;
import net.sixik.sdmuilib.client.utils.math.Vector2f;
import net.sixik.sdmuilib.client.utils.misc.CenterOperators;
import net.sixik.sdmuilib.client.utils.misc.RGB;
import net.sixik.sdmuilib.client.utils.misc.RGBA;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Vector4f;

public class RenderHelper {
    public static double getGuiScale() {
        return Minecraft.m_91087_().m_91268_().m_85449_();
    }

    public static boolean isGamePaused() {
        return Minecraft.m_91087_().m_91104_();
    }

    public static Vector2 getScreenSize() {
        return new Vector2(Minecraft.m_91087_().m_91268_().m_85441_(), Minecraft.m_91087_().m_91268_().m_85446_());
    }

    public static Vector2 getScreenCenter() {
        return new Vector2(RenderHelper.getScreenSize().x / 2, RenderHelper.getScreenSize().y / 2);
    }

    public static Vector2 getScreenCenter(CenterOperators.Type centerType, CenterOperators.Method method) {
        return GLHelper.getCenterWithPos(new Vector2(0, 0), RenderHelper.getScreenSize(), centerType, method);
    }

    public static Vector2 getScreenCenterWithSize(Vector2 size, CenterOperators.Type centerType, CenterOperators.Method method) {
        Vector2 p = GLHelper.getCenterWithPos(new Vector2(0, 0), RenderHelper.getScreenSize(), centerType, method);
        return p.add(new Vector2(size.x / 2, size.y / 2));
    }

    public static Vector2f getMousePosition() {
        return new Vector2f((float)Minecraft.m_91087_().f_91067_.m_91589_(), (float)Minecraft.m_91087_().f_91067_.m_91594_());
    }

    public static int getTextHeight() {
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        return 9;
    }

    public static float getTextHeight(float scale) {
        return (float)RenderHelper.getTextHeight() * scale;
    }

    public static int getTextWidth(String text) {
        return Minecraft.m_91087_().f_91062_.m_92895_(text);
    }

    public static float getTextWidth(String text, float scale) {
        return (float)Minecraft.m_91087_().f_91062_.m_92895_(text) * scale;
    }

    public static boolean isMouseOver(Vector2d mousePos, Vector2 pos, Vector2 size) {
        return mousePos.x >= (double)pos.x && mousePos.y >= (double)pos.y && mousePos.x < (double)(pos.x + size.x) && mousePos.y < (double)(pos.y + size.y);
    }

    public static Vector2 getMaxElementsOnSizeZone(Vector2 elementSize, Vector2 screenSize, int step, CenterOperators.Type type) {
        switch (type) {
            case CENTER_X: {
                return new Vector2(screenSize.x / (elementSize.x + step), 0);
            }
            case CENTER_Y: {
                return new Vector2(0, screenSize.y / (elementSize.y + step));
            }
        }
        return new Vector2(screenSize.x / (elementSize.x + step), screenSize.y / (elementSize.y + step));
    }

    public static void prepareTextureRendering(ResourceLocation textureLocation) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)textureLocation);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
    }

    public static void drawText(GuiGraphics poseStack, int x, int y, float size, Component text, int textColor) {
        RenderHelper.drawText(poseStack, Minecraft.m_91087_().f_91062_, x, y, size, text, textColor);
    }

    public static void drawText(GuiGraphics poseStack, Font font, int x, int y, float size, Component text, int textColor) {
        poseStack.m_280168_().m_85836_();
        poseStack.m_280168_().m_85841_(size, size, 1.0f);
        poseStack.m_280168_().m_252880_((float)x, (float)y, 0.0f);
        poseStack.m_280430_(font, text, x, y, textColor);
        poseStack.m_280168_().m_85849_();
    }

    public static void drawText(GuiGraphics graphics, Component text, int x, int y) {
        graphics.m_280488_(Minecraft.m_91087_().f_91062_, text.getString(), x, y, RGB.create(255, 255, 255).toInt());
    }

    public static void drawText(GuiGraphics graphics, String text, int x, int y) {
        graphics.m_280488_(Minecraft.m_91087_().f_91062_, text, x, y, RGB.create(255, 255, 255).toInt());
    }

    public static void drawText(GuiGraphics graphics, Component text, int x, int y, RGB rgb) {
        graphics.m_280488_(Minecraft.m_91087_().f_91062_, text.getString(), x, y, rgb.toInt());
    }

    public static void drawText(GuiGraphics graphics, String text, int x, int y, RGB rgb) {
        graphics.m_280488_(Minecraft.m_91087_().f_91062_, text, x, y, rgb.toInt());
    }

    public static void addFillToBuffer(GuiGraphics graphics, BufferBuilder buffer, int x, int y, int w, int h, RGB rgb) {
        if (w > 0 && h > 0) {
            Matrix4f m = graphics.m_280168_().m_85850_().m_252922_();
            int r = rgb.r;
            int g = rgb.g;
            int b = rgb.b;
            int a = 255;
            if (rgb instanceof RGBA) {
                RGBA rgba = (RGBA)rgb;
                a = rgba.a;
            }
            buffer.m_252986_(m, (float)x, (float)(y + h), 0.0f).m_6122_(r, g, b, a).m_5752_();
            buffer.m_252986_(m, (float)(x + w), (float)(y + h), 0.0f).m_6122_(r, g, b, a).m_5752_();
            buffer.m_252986_(m, (float)(x + w), (float)y, 0.0f).m_6122_(r, g, b, a).m_5752_();
            buffer.m_252986_(m, (float)x, (float)y, 0.0f).m_6122_(r, g, b, a).m_5752_();
        }
    }

    public static void addFillTriangleToBuffer(GuiGraphics graphics, BufferBuilder buffer, int x, int y, int w, int h, RGB rgb) {
        buffer.m_166779_(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.f_85815_);
        Matrix4f m = graphics.m_280168_().m_85850_().m_252922_();
        int r = rgb.r;
        int g = rgb.g;
        int b = rgb.b;
        int a = 255;
        if (rgb instanceof RGBA) {
            RGBA rgba = (RGBA)rgb;
            a = rgba.a;
        }
        buffer.m_252986_(m, (float)x, (float)y, 0.0f).m_6122_(r, g, b, a).m_5752_();
        buffer.m_252986_(m, (float)(x + w / 2), (float)(y + h), 0.0f).m_6122_(r, g, b, a).m_5752_();
        buffer.m_252986_(m, (float)(x + w), (float)y, 0.0f).m_6122_(r, g, b, a).m_5752_();
    }

    public static void addFillTriangleToBufferGradient(GuiGraphics graphics, BufferBuilder buffer, int x, int y, int w, int h, RGB startRgb, RGB endRgb) {
        buffer.m_166779_(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.f_85815_);
        RGBA s = startRgb.toARGB();
        RGBA e = endRgb.toARGB();
        Matrix4f m = graphics.m_280168_().m_85850_().m_252922_();
        buffer.m_252986_(m, (float)x, (float)y, 0.0f).m_6122_(e.r, e.g, e.b, e.a).m_5752_();
        buffer.m_252986_(m, (float)(x + w / 2), (float)(y + h), 0.0f).m_6122_(s.r, s.g, s.b, s.a).m_5752_();
        buffer.m_252986_(m, (float)(x + w), (float)y, 0.0f).m_6122_(e.r, e.g, e.b, e.a).m_5752_();
    }

    public static void addFillToBufferGradient(GuiGraphics graphics, BufferBuilder buffer, int x, int y, int w, int h, RGB startRgb, RGB endRgb) {
        if (w > 0 && h > 0) {
            RGBA s = startRgb.toARGB();
            RGBA e = endRgb.toARGB();
            Matrix4f m = graphics.m_280168_().m_85850_().m_252922_();
            buffer.m_252986_(m, (float)x, (float)(y + h), 0.0f).m_6122_(s.r, s.g, s.b, s.a).m_5752_();
            buffer.m_252986_(m, (float)(x + w), (float)(y + h), 0.0f).m_6122_(s.r, s.g, s.b, s.a).m_5752_();
            buffer.m_252986_(m, (float)(x + w), (float)y, 0.0f).m_6122_(e.r, e.g, e.b, e.a).m_5752_();
            buffer.m_252986_(m, (float)x, (float)y, 0.0f).m_6122_(e.r, e.g, e.b, e.a).m_5752_();
        }
    }

    public static void drawLine(GuiGraphics graphics, RGB rgb) {
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferBuilder = tesselator.m_85915_();
        Matrix4f m = graphics.m_280168_().m_85850_().m_252922_();
        int r = rgb.r;
        int g = rgb.g;
        int b = rgb.b;
        int a = 255;
        if (rgb instanceof RGBA) {
            RGBA rgba = (RGBA)rgb;
            a = rgba.a;
        }
        RenderSystem.setShader(GameRenderer::m_172811_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.lineWidth((float)5.0f);
        bufferBuilder.m_166779_(VertexFormat.Mode.LINES, DefaultVertexFormat.f_85815_);
        bufferBuilder.m_252986_(m, 20.0f, 20.0f, 0.0f).m_6122_(r, g, b, a).m_5752_();
        bufferBuilder.m_252986_(m, 10.0f, 10.0f, 0.0f).m_6122_(r, g, b, a).m_5752_();
        RenderSystem.lineWidth((float)1.0f);
        tesselator.m_85914_();
        RenderSystem.disableBlend();
    }

    public static void drawFillArc(GuiGraphics graphics, int cX, int cY, int radius, int start, int end, RGB rgb) {
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferBuilder = tesselator.m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85815_);
        Matrix4f m = graphics.m_280168_().m_85850_().m_252922_();
        int r = rgb.r;
        int g = rgb.g;
        int b = rgb.b;
        int a = 255;
        if (rgb instanceof RGBA) {
            RGBA rgba = (RGBA)rgb;
            a = rgba.a;
        }
        bufferBuilder.m_252986_(m, (float)cX, (float)cY, 0.0f).m_6122_(r, g, b, a).m_5752_();
        for (int angle = start; angle <= end; ++angle) {
            double rad = Math.toRadians(angle);
            float x = (float)(Math.cos(rad) * (double)radius) + (float)cX;
            float y = (float)(Math.sin(rad) * (double)radius) + (float)cY;
            bufferBuilder.m_252986_(m, x, y, 0.0f).m_6122_(r, g, b, a).m_5752_();
        }
        tesselator.m_85914_();
    }

    public static void drawCircle(GuiGraphics graphics, int x, int y, int radius, RGB rgb) {
        RenderHelper.drawArc(graphics, x, y, radius, 0, 360, rgb);
    }

    public static void drawFillCircle(GuiGraphics graphics, int x, int y, int radius, RGB rgb) {
        RenderHelper.drawFillArc(graphics, x, y, radius, 0, 360, rgb);
    }

    public static void drawHollowRect(GuiGraphics graphics, int x, int y, int w, int h, RGB col, boolean roundEdges) {
        if (w > 1 && h > 1 && col != null) {
            RenderSystem.setShader(GameRenderer::m_172811_);
            Tesselator tesselator = Tesselator.m_85913_();
            BufferBuilder buffer = tesselator.m_85915_();
            buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
            RenderHelper.addFillToBuffer(graphics, buffer, x, y + 1, 1, h - 2, col);
            RenderHelper.addFillToBuffer(graphics, buffer, x + w - 1, y + 1, 1, h - 2, col);
            if (roundEdges) {
                RenderHelper.addFillToBuffer(graphics, buffer, x + 1, y, w - 2, 1, col);
                RenderHelper.addFillToBuffer(graphics, buffer, x + 1, y + h - 1, w - 2, 1, col);
            } else {
                RenderHelper.addFillToBuffer(graphics, buffer, x, y, w, 1, col);
                RenderHelper.addFillToBuffer(graphics, buffer, x, y + h - 1, w, 1, col);
            }
            tesselator.m_85914_();
        } else {
            col.draw(graphics, x, y, w, h, 0.0f);
        }
    }

    public static void renderTexture(GuiGraphics guiGraphics, String texture, int x, int y, int width, int height, int textureX, int textureY, int textureW, int textureH) {
        RenderHelper.renderTexture(guiGraphics, texture, x, y, width, height, textureX, textureY, textureW, textureH, 256);
    }

    public static void renderTexture(GuiGraphics guiGraphics, String texture, int x, int y, int width, int height, int textureX, int textureY, int textureW, int textureH, int textureSize) {
        guiGraphics.m_280411_(new ResourceLocation(texture), x, y, width, height, (float)textureX, (float)textureY, textureW, textureH, textureSize, textureSize);
    }

    public static void renderTexture(GuiGraphics guiGraphics, String texture, int x, int y, int width, int height, int textureX, int textureY, int textureW, int textureH, int textureSizeX, int textureSizeY) {
        guiGraphics.m_280411_(new ResourceLocation(texture), x, y, width, height, (float)textureX, (float)textureY, textureW, textureH, textureSizeX, textureSizeY);
    }

    public static void renderTexture(GuiGraphics guiGraphics, ResourceLocation texture, int x, int y, int width, int height, int textureX, int textureY, int textureW) {
        guiGraphics.m_280398_(texture, x, y, width, (float)height, (float)textureX, textureY, textureW, 256, 256);
    }

    public static void renderTexture(GuiGraphics guiGraphics, ResourceLocation texture, int x, int y, int width, int height, int textureX, int textureY, int textureW, int textureH, int textureSize) {
        guiGraphics.m_280398_(texture, x, y, width, (float)height, (float)textureX, textureY, textureW, textureH, textureSize);
    }

    public static void renderTexture(GuiGraphics guiGraphics, ResourceLocation texture, int x, int y, int width, int height, int textureX, int textureY, int textureW, int textureH, int textureSizeX, int textureSizeY) {
        guiGraphics.m_280411_(texture, x, y, width, height, (float)textureX, (float)textureY, textureW, textureH, textureSizeX, textureSizeY);
    }

    public static void pushScale(GuiGraphics guiGraphics, int x, int y, int scale) {
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_85841_((float)scale, (float)scale, 1.0f);
        guiGraphics.m_280168_().m_252880_((float)(x / scale), (float)(y / scale), 0.0f);
    }

    public static void pushScale(GuiGraphics guiGraphics, int x, int y, float scale) {
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_85841_(scale, scale, 1.0f);
        guiGraphics.m_280168_().m_252880_((float)((int)((float)x / scale)), (float)((int)((float)y / scale)), 0.0f);
    }

    public static void pushScale(GuiGraphics guiGraphics, int x, int y, int w, int h, int scale) {
        guiGraphics.m_280168_().m_85836_();
        float scaledWidth = w * scale;
        float scaledHeight = h * scale;
        float dx = ((float)w - scaledWidth) / 2.0f;
        float dy = ((float)h - scaledHeight) / 2.0f;
        guiGraphics.m_280168_().m_252880_((float)x + dx, (float)y + dy, 0.0f);
        guiGraphics.m_280168_().m_85841_((float)scale, (float)scale, 1.0f);
    }

    public static void pushScale(GuiGraphics guiGraphics, int x, int y, int w, int h, float scale) {
        guiGraphics.m_280168_().m_85836_();
        float scaledWidth = (float)w * scale;
        float scaledHeight = (float)h * scale;
        float dx = ((float)w - scaledWidth) / 2.0f;
        float dy = ((float)h - scaledHeight) / 2.0f;
        guiGraphics.m_280168_().m_252880_((float)x + dx, (float)y + dy, 0.0f);
        guiGraphics.m_280168_().m_85841_(scale, scale, 1.0f);
    }

    public static void popScale(GuiGraphics guiGraphics) {
        guiGraphics.m_280168_().m_85849_();
    }

    public static int getScaleSize(int size, float scale) {
        return (int)((float)size * scale);
    }

    public static Vector2 getScaleSize(Vector2 size, float scale) {
        return new Vector2((int)((float)size.x * scale), (int)((float)size.y * scale));
    }

    public static void pushUpper(GuiGraphics guiGraphics) {
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 40.0f);
    }

    public static void pushUpper(GuiGraphics guiGraphics, float pos) {
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, pos);
    }

    public static void popUpper(GuiGraphics guiGraphics) {
        guiGraphics.m_280168_().m_85849_();
    }

    public static void pushRotate(GuiGraphics guiGraphics, int x, int y, int w, int h, float angle) {
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_85837_((double)x + (double)w / 2.0, (double)y + (double)h / 2.0, 0.0);
        guiGraphics.m_280168_().m_252781_(Axis.f_252403_.m_252977_(angle));
        guiGraphics.m_280168_().m_85837_((double)(-w) / 2.0, (double)(-h) / 2.0, 0.0);
    }

    public static void pushRotation(GuiGraphics guiGraphics, Vector2 pivot, float angle) {
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_((float)pivot.x, (float)pivot.y, 0.0f);
        guiGraphics.m_280168_().m_252781_(Axis.f_252403_.m_252977_(angle));
        guiGraphics.m_280168_().m_252880_((float)(-pivot.x), (float)(-pivot.y), 0.0f);
    }

    public static void pushTransform(GuiGraphics guiGraphics, Vector2 pos, Vector2 size, float scale, float rotationAngle) {
        Vector2 center = new Vector2(pos.x + size.x / 2, pos.y + size.y / 2);
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_((float)center.x, (float)center.y, 0.0f);
        guiGraphics.m_280168_().m_85841_(scale, scale, 1.0f);
        guiGraphics.m_280168_().m_252781_(Axis.f_252403_.m_252977_(rotationAngle));
        guiGraphics.m_280168_().m_252880_((float)(-center.x), (float)(-center.y), 0.0f);
    }

    public static void pushTransform(GuiGraphics guiGraphics, Vector2 pos, Vector2 size, Vector2 screenSize, float scale, float rotationAngle) {
        Vector2 screenCenter = new Vector2(screenSize.x, screenSize.y);
        Vector2 center = new Vector2(pos.x + size.x / 2, pos.y + size.y / 2);
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_((float)screenCenter.x, (float)screenCenter.y, 0.0f);
        guiGraphics.m_280168_().m_252880_((float)center.x, (float)center.y, 0.0f);
        guiGraphics.m_280168_().m_85841_(scale, scale, 1.0f);
        guiGraphics.m_280168_().m_252781_(Axis.f_252403_.m_252977_(rotationAngle));
        guiGraphics.m_280168_().m_252880_((float)(-center.x), (float)(-center.y), 0.0f);
        guiGraphics.m_280168_().m_252880_((float)(-screenCenter.x), (float)(-screenCenter.y), 0.0f);
    }

    public static void popTransform(GuiGraphics guiGraphics) {
        guiGraphics.m_280168_().m_85849_();
    }

    public static void popRotate(GuiGraphics guiGraphics) {
        guiGraphics.m_280168_().m_85849_();
    }

    public static void setTransparent(GuiGraphics guiGraphics, float alpha) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
    }

    public static void popTransparent() {
        RenderSystem.disableBlend();
    }

    public static void pushColor(RGB rgb) {
        float r = (float)rgb.r / 255.0f;
        float g = (float)rgb.g / 255.0f;
        float b = (float)rgb.b / 255.0f;
        float a = 1.0f;
        if (rgb instanceof RGBA) {
            RGBA rgba = (RGBA)rgb;
            a = (float)rgba.a / 255.0f;
        }
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)a);
    }

    public static void popColor() {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static List<String> splitTextToLines(String text, float textScale, int maxWidth) {
        if (text.isEmpty()) {
            return Collections.emptyList();
        }
        if (!text.contains(" ") && !text.contains("\n")) {
            return Collections.singletonList(text);
        }
        ArrayList<String> lines = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        int index = 0;
        int wordStartIndex = 0;
        boolean wordProcessing = false;
        char prevSymbol = '0';
        for (char symbol : text.toCharArray()) {
            if (symbol != ' ') {
                wordProcessing = true;
                if (prevSymbol == ' ') {
                    wordStartIndex = index;
                }
            }
            if (symbol == '\n') {
                lines.add(builder.toString());
                builder.delete(0, builder.length());
                index = 0;
                continue;
            }
            if (RenderHelper.getTextWidth(builder.toString() + symbol, textScale) <= (float)maxWidth) {
                builder.append(symbol);
            } else {
                if (symbol == '.' || symbol == ',' || symbol == '!' || symbol == '?') {
                    builder.append(symbol);
                }
                if (wordProcessing) {
                    lines.add(builder.toString().substring(0, wordStartIndex));
                    builder.delete(0, wordStartIndex);
                } else {
                    lines.add(builder.toString());
                    builder.delete(0, builder.length());
                }
                if (symbol != ' ') {
                    builder.append(symbol);
                }
                index = builder.length() - 1;
            }
            wordProcessing = false;
            prevSymbol = symbol;
            ++index;
        }
        if (builder.length() != 0) {
            lines.add(builder.toString());
        }
        return lines;
    }

    public static void enableScissor(PoseStack poseStack, double x, double y, double width, double height) {
        Matrix4f mat = poseStack.m_85850_().m_252922_();
        Vector4f origin = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f);
        origin.mulTranspose((Matrix4fc)mat);
        Window window = Minecraft.m_91087_().m_91268_();
        double scale = window.m_85449_();
        RenderSystem.enableScissor((int)((int)((double)origin.x() * scale)), (int)(window.m_85442_() - (int)(((double)origin.y() + height) * scale)), (int)((int)(width * scale)), (int)((int)(height * scale)));
    }

    public static void disableScissor() {
        RenderSystem.disableScissor();
    }

    @Deprecated
    public static void testBuffer(GuiGraphics graphics, int cX, int cY, int w, int h, RGB rgb) {
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferBuilder = tesselator.m_85915_();
        Matrix4f matrix = graphics.m_280168_().m_85850_().m_252922_();
        bufferBuilder.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85815_);
        ShapesRender.drawCircle(matrix, bufferBuilder, new Vector2f(cX, cY), 50.0f, 12, rgb);
        tesselator.m_85914_();
    }

    @Nullable
    public static LivingEntity getEntity(EntityType<?> type) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ != null) {
            Entity entity = type.m_20615_((Level)mc.f_91073_);
            return entity != null ? (LivingEntity)entity : null;
        }
        return null;
    }

    @Deprecated
    public static void drawBlock(GuiGraphics graphics, Block block, int x, int y, int scale) {
        Minecraft mc = Minecraft.m_91087_();
        ItemStack blockStack = new ItemStack((ItemLike)block);
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_((float)x, (float)y, 100.0f);
        graphics.m_280168_().m_85841_((float)scale, (float)scale, (float)scale);
        graphics.m_280168_().m_85849_();
        RenderSystem.disableBlend();
    }

    public static Vector2d getEntitySize(LivingEntity livingEntity, double scale) {
        AABB d = livingEntity.m_20191_();
        return new Vector2d(d.f_82291_ * scale, d.f_82289_ * scale);
    }

    public static void drawLivingEntity(GuiGraphics guiGraphics, int x, int y, double scale, double yaw, double pitch, LivingEntity livingEntity) {
        if (livingEntity.m_9236_() == null) {
            return;
        }
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_((float)x, (float)y, 50.0f);
        poseStack.m_85841_((float)scale, (float)scale, (float)scale);
        poseStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
        poseStack.m_252781_(Axis.f_252529_.m_252977_((float)Math.atan(-1.0) * 10.0f));
        livingEntity.f_20883_ = (float)(-(yaw / 40.0)) * 20.0f;
        livingEntity.m_146922_((float)(-(yaw / 40.0)) * 20.0f);
        livingEntity.f_20885_ = livingEntity.m_146908_();
        livingEntity.f_20886_ = livingEntity.m_146908_();
        poseStack.m_85837_(0.0, livingEntity.m_6049_(), 0.0);
        EntityRenderDispatcher entityRenderDispatcher = Minecraft.m_91087_().m_91290_();
        entityRenderDispatcher.m_252923_(new Quaternionf(0.0f, 0.0f, 0.0f, 1.0f));
        entityRenderDispatcher.m_114468_(false);
        MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
        RenderSystem.runAsFancy(() -> entityRenderDispatcher.m_114384_((Entity)livingEntity, 0.0, 0.0, 0.0, 0.0f, 1.0f, poseStack, (MultiBufferSource)bufferSource, 0xF000F0));
        bufferSource.m_109911_();
        entityRenderDispatcher.m_114468_(true);
        poseStack.m_85849_();
    }

    public static void drawItem(GuiGraphics graphics, ItemStack stack, int hash, boolean renderOverlay, @Nullable String text) {
        if (!stack.m_41619_()) {
            boolean flatLight;
            Minecraft mc = Minecraft.m_91087_();
            ItemRenderer itemRenderer = mc.m_91291_();
            BakedModel bakedModel = itemRenderer.m_174264_(stack, (Level)null, (LivingEntity)mc.f_91074_, hash);
            Minecraft.m_91087_().m_91097_().m_118506_(InventoryMenu.f_39692_).m_117960_(false, false);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.f_39692_);
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            PoseStack modelViewStack = RenderSystem.getModelViewStack();
            modelViewStack.m_85836_();
            modelViewStack.m_252931_(graphics.m_280168_().m_85850_().m_252922_());
            modelViewStack.m_85841_(1.0f, -1.0f, 1.0f);
            modelViewStack.m_85841_(16.0f, 16.0f, 16.0f);
            RenderSystem.applyModelViewMatrix();
            MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
            boolean bl = flatLight = !bakedModel.m_7547_();
            if (flatLight) {
                Lighting.m_84930_();
            }
            itemRenderer.m_115143_(stack, ItemDisplayContext.GUI, false, new PoseStack(), (MultiBufferSource)bufferSource, 0xF000F0, OverlayTexture.f_118083_, bakedModel);
            bufferSource.m_109911_();
            RenderSystem.enableDepthTest();
            if (flatLight) {
                Lighting.m_84931_();
            }
            modelViewStack.m_85849_();
            RenderSystem.applyModelViewMatrix();
            if (renderOverlay) {
                float cooldown;
                Tesselator t = Tesselator.m_85913_();
                Font font = mc.f_91062_;
                if (stack.m_41613_() != 1 || text != null) {
                    String s = text == null ? String.valueOf(stack.m_41613_()) : text;
                    graphics.m_280168_().m_85836_();
                    graphics.m_280168_().m_85837_(9.0 - (double)font.m_92895_(s), 1.0, 20.0);
                    font.m_271703_(s, 0.0f, 0.0f, 0xFFFFFF, true, graphics.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
                    bufferSource.m_109911_();
                    graphics.m_280168_().m_85849_();
                }
                if (stack.m_150947_()) {
                    RenderSystem.disableDepthTest();
                    RenderSystem.disableBlend();
                    int barWidth = stack.m_150948_();
                    int barColor = stack.m_150949_();
                    RenderHelper.draw(graphics, t, -6, 5, 13, 2, 0, 0, 0, 255);
                    RenderHelper.draw(graphics, t, -6, 5, barWidth, 1, barColor >> 16 & 0xFF, barColor >> 8 & 0xFF, barColor & 0xFF, 255);
                    RenderSystem.enableBlend();
                    RenderSystem.enableDepthTest();
                }
                float f = cooldown = mc.f_91074_ == null ? 0.0f : mc.f_91074_.m_36335_().m_41521_(stack.m_41720_(), mc.m_91296_());
                if (cooldown > 0.0f) {
                    RenderSystem.disableDepthTest();
                    RenderSystem.enableBlend();
                    RenderSystem.defaultBlendFunc();
                    RenderHelper.draw(graphics, t, -8, Mth.m_14143_((float)(16.0f * (1.0f - cooldown))) - 8, 16, Mth.m_14167_((float)(16.0f * cooldown)), 255, 255, 255, 127);
                    RenderSystem.enableDepthTest();
                }
            }
        }
    }

    private static void draw(GuiGraphics graphics, Tesselator t, int x, int y, int width, int height, int red, int green, int blue, int alpha) {
        if (width > 0 && height > 0) {
            RenderSystem.setShader(GameRenderer::m_172811_);
            Matrix4f m = graphics.m_280168_().m_85850_().m_252922_();
            BufferBuilder renderer = t.m_85915_();
            renderer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
            renderer.m_252986_(m, (float)x, (float)y, 0.0f).m_6122_(red, green, blue, alpha).m_5752_();
            renderer.m_252986_(m, (float)x, (float)(y + height), 0.0f).m_6122_(red, green, blue, alpha).m_5752_();
            renderer.m_252986_(m, (float)(x + width), (float)(y + height), 0.0f).m_6122_(red, green, blue, alpha).m_5752_();
            renderer.m_252986_(m, (float)(x + width), (float)y, 0.0f).m_6122_(red, green, blue, alpha).m_5752_();
            t.m_85914_();
        }
    }

    public static void drawRoundedRectUp(GuiGraphics guiGraphics, int x, int y, int width, int height, int radius, RGB rgb) {
        int r = rgb.r;
        int g = rgb.g;
        int b = rgb.b;
        int a = 255;
        if (rgb instanceof RGBA) {
            RGBA rgba = (RGBA)rgb;
            a = rgba.a;
        }
        RenderHelper.fillRect(guiGraphics, x, y + radius, width, height - radius, RGBA.create(r, g, b, a));
        RenderHelper.fillRect(guiGraphics, x + radius, y, width - radius * 2, radius, RGBA.create(r, g, b, a));
        RenderHelper.drawArc(guiGraphics, x + radius, y + radius, radius, 270, 180, RGBA.create(r, g, b, a));
        RenderHelper.drawArc(guiGraphics, x + width - radius, y + radius, radius, 0, -90, RGBA.create(r, g, b, a));
    }

    public static void drawRoundedRectDown(GuiGraphics guiGraphics, int x, int y, int width, int height, int radius, RGB rgb) {
        int r = rgb.r;
        int g = rgb.g;
        int b = rgb.b;
        int a = 255;
        if (rgb instanceof RGBA) {
            RGBA rgba = (RGBA)rgb;
            a = rgba.a;
        }
        RenderHelper.fillRect(guiGraphics, x, y, width, height - radius, RGBA.create(r, g, b, a));
        RenderHelper.fillRect(guiGraphics, x + radius, y + height - radius, width - radius * 2, radius, RGBA.create(r, g, b, a));
        RenderHelper.drawArc(guiGraphics, x + radius, y + height - radius, radius, -180, -270, RGBA.create(r, g, b, a));
        RenderHelper.drawArc(guiGraphics, x + width - radius, y + height - radius, radius, 90, 0, RGBA.create(r, g, b, a));
    }

    public static void drawRoundedRect(GuiGraphics guiGraphics, int x, int y, int width, int height, int radius, RGB rgb) {
        int r = rgb.r;
        int g = rgb.g;
        int b = rgb.b;
        int a = 255;
        if (rgb instanceof RGBA) {
            RGBA rgba = (RGBA)rgb;
            a = rgba.a;
        }
        RenderHelper.fillRect(guiGraphics, x, y + radius, width, height - radius * 2, RGBA.create(r, g, b, a));
        RenderHelper.fillRect(guiGraphics, x + radius, y, width - radius * 2, radius, RGBA.create(r, g, b, a));
        RenderHelper.fillRect(guiGraphics, x + radius, y + height - radius, width - radius * 2, radius, RGBA.create(r, g, b, a));
        RenderHelper.drawArc(guiGraphics, x + radius, y + radius, radius, 270, 180, RGBA.create(r, g, b, a));
        RenderHelper.drawArc(guiGraphics, x + width - radius, y + radius, radius, 0, -90, RGBA.create(r, g, b, a));
        RenderHelper.drawArc(guiGraphics, x + radius, y + height - radius, radius, -180, -270, RGBA.create(r, g, b, a));
        RenderHelper.drawArc(guiGraphics, x + width - radius, y + height - radius, radius, 90, 0, RGBA.create(r, g, b, a));
    }

    public static void fillRect(GuiGraphics guiGraphics, int x, int y, int width, int height, RGB rgb) {
        guiGraphics.m_280509_(x, y, x + width, y + height, RenderHelper.rgbaToInt(rgb.r, rgb.g, rgb.b, rgb instanceof RGBA ? ((RGBA)rgb).a : 255));
    }

    public static void drawArc(GuiGraphics graphics, int cX, int cY, int radius, int startAngle, int endAngle, RGB rgb) {
        RenderSystem.setShader(GameRenderer::m_172811_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferBuilder = tesselator.m_85915_();
        Matrix4f m = graphics.m_280168_().m_85850_().m_252922_();
        int r = rgb.r;
        int g = rgb.g;
        int b = rgb.b;
        int a = 255;
        if (rgb instanceof RGBA) {
            RGBA rgba = (RGBA)rgb;
            a = rgba.a;
        }
        bufferBuilder.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85815_);
        bufferBuilder.m_252986_(m, (float)cX, (float)cY, 0.0f).m_6122_(r, g, b, a).m_5752_();
        for (int i = startAngle; i >= endAngle; i -= 5) {
            double angle = Math.toRadians(i);
            float x = (float)(Math.cos(angle) * (double)radius) + (float)cX;
            float y = (float)(Math.sin(angle) * (double)radius) + (float)cY;
            bufferBuilder.m_252986_(m, x, y, 0.0f).m_6122_(r, g, b, a).m_5752_();
        }
        tesselator.m_85914_();
        RenderSystem.disableBlend();
    }

    public static void drawRoundedRectWithOutline(GuiGraphics guiGraphics, int x, int y, int width, int height, int radius, RGB fillColor, RGB outlineColor, int outlineThickness) {
        RenderHelper.drawRoundedRect(guiGraphics, x, y, width, height, radius, fillColor);
        RenderHelper.drawRoundedOutline(guiGraphics, x, y, width, height, radius, outlineColor, outlineThickness);
    }

    public static void drawRoundedOutline(GuiGraphics guiGraphics, int x, int y, int width, int height, int radius, RGB rgb, int thickness) {
        int r = rgb.r;
        int g = rgb.g;
        int b = rgb.b;
        int a = 255;
        if (rgb instanceof RGBA) {
            RGBA rgba = (RGBA)rgb;
            a = rgba.a;
        }
        RenderHelper.drawLine(guiGraphics, x + radius, y, x + width - radius, y, thickness, RGBA.create(r, g, b, a));
        RenderHelper.drawLine(guiGraphics, x + radius, y + height, x + width - radius, y + height, thickness, RGBA.create(r, g, b, a));
        RenderHelper.drawLine(guiGraphics, x, y + radius, x, y + height - radius, thickness, RGBA.create(r, g, b, a));
        RenderHelper.drawLine(guiGraphics, x + width, y + radius, x + width, y + height - radius, thickness, RGBA.create(r, g, b, a));
        RenderHelper.drawArcOutline(guiGraphics, x + radius, y + radius, radius, 270, 180, RGBA.create(r, g, b, a), thickness);
        RenderHelper.drawArcOutline(guiGraphics, x + width - radius, y + radius, radius, 0, -90, RGBA.create(r, g, b, a), thickness);
        RenderHelper.drawArcOutline(guiGraphics, x + radius, y + height - radius, radius, -180, -270, RGBA.create(r, g, b, a), thickness);
        RenderHelper.drawArcOutline(guiGraphics, x + width - radius, y + height - radius, radius, 90, 0, RGBA.create(r, g, b, a), thickness);
    }

    public static void drawLine(GuiGraphics guiGraphics, int x1, int y1, int x2, int y2, int thickness, RGB rgb) {
        guiGraphics.m_280509_(x1, y1, x2, y2 + thickness, RenderHelper.rgbaToInt(rgb.r, rgb.g, rgb.b, rgb instanceof RGBA ? ((RGBA)rgb).a : 255));
    }

    public static void drawArcOutline(GuiGraphics graphics, int cX, int cY, int radius, int startAngle, int endAngle, RGB rgb, int thickness) {
        RenderSystem.setShader(GameRenderer::m_172811_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferBuilder = tesselator.m_85915_();
        Matrix4f m = graphics.m_280168_().m_85850_().m_252922_();
        int r = rgb.r;
        int g = rgb.g;
        int b = rgb.b;
        int a = 255;
        if (rgb instanceof RGBA) {
            RGBA rgba = (RGBA)rgb;
            a = rgba.a;
        }
        bufferBuilder.m_166779_(VertexFormat.Mode.LINE_STRIP, DefaultVertexFormat.f_85815_);
        for (int i = startAngle; i >= endAngle; i -= 5) {
            double angle = Math.toRadians(i);
            float x = (float)(Math.cos(angle) * (double)(radius + thickness / 2)) + (float)cX;
            float y = (float)(Math.sin(angle) * (double)(radius + thickness / 2)) + (float)cY;
            bufferBuilder.m_252986_(m, x, y, 0.0f).m_6122_(r, g, b, a).m_5752_();
        }
        tesselator.m_85914_();
        RenderSystem.disableBlend();
    }

    public static int rgbaToInt(int r, int g, int b, int a) {
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static void pushScissor(GuiGraphics guiGraphics, Vector2 pos, Vector2 size) {
        guiGraphics.m_280588_(pos.x, pos.y, pos.x + size.x, pos.y + size.y);
        guiGraphics.m_280168_().m_85836_();
    }

    public static void popScissor(GuiGraphics guiGraphics) {
        guiGraphics.m_280168_().m_85849_();
        guiGraphics.m_280618_();
    }
}

