/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmuilib.client.utils;

import java.util.ArrayList;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.util.RandomSource;
import net.sixik.sdmuilib.client.utils.GLHelper;
import net.sixik.sdmuilib.client.utils.math.Vector2;
import net.sixik.sdmuilib.client.utils.misc.RGB;
import net.sixik.sdmuilib.client.widgetsFake.RGBFakeWidget;

public class RandomRender {
    public static void renderObjectWithSizeAndPos(GuiGraphics graphics, Vector2 minPos, Vector2 maxPos, Vector2 minScale, Vector2 maxScale, Object object, RGB rgb) {
        Vector2 size = RandomRender.getRandomScale(minScale, maxScale);
        Vector2 pos = RandomRender.getRandomPosInZone(minPos, maxPos);
        RandomRender.rO(graphics, pos, size, object, rgb);
    }

    public static RGBFakeWidget renderObjectWithSizeAndPos(final Vector2 minPos, final Vector2 maxPos, final Vector2 minScale, final Vector2 maxScale, final Object object, RGB rgb) {
        Vector2 size = RandomRender.getRandomScale(minScale, maxScale);
        Vector2 pos = RandomRender.getRandomPosInZone(minPos, maxPos);
        return new RGBFakeWidget(rgb){

            @Override
            public void draw(GuiGraphics graphics) {
                Vector2 size = RandomRender.getRandomScale(minScale, maxScale);
                Vector2 pos = RandomRender.getRandomPosInZone(minPos, maxPos);
                RandomRender.rO(graphics, pos, size, object, this.rgb);
            }
        };
    }

    public static void renderObjectWithSize(GuiGraphics graphics, Vector2 pos, Vector2 minScale, Vector2 maxScale, Object object, RGB rgb) {
        Vector2 size = RandomRender.getRandomScale(minScale, maxScale);
        RandomRender.rO(graphics, pos, size, object, rgb);
    }

    public static RGBFakeWidget renderObjectWithSize(final Vector2 pos, Vector2 minScale, Vector2 maxScale, final Object object, RGB rgb) {
        Vector2 size = RandomRender.getRandomScale(minScale, maxScale);
        return new RGBFakeWidget(rgb){

            @Override
            public void draw(GuiGraphics graphics) {
                RandomRender.rO(graphics, pos, this.size, object, this.rgb);
            }
        };
    }

    public static void renderObjectWithRotation(GuiGraphics graphics, Vector2 pos, Vector2 size, Object object, RGB rgb) {
        RandomSource source = RandomSource.m_216327_();
        GLHelper.pushTransform(graphics, pos, size, 1.0f, source.m_188501_() * 360.0f);
        RandomRender.rO(graphics, pos, size, object, rgb);
        GLHelper.popTransform(graphics);
    }

    public static RGBFakeWidget renderObjectWithRotation(final Vector2 pos, Vector2 size, final Object object, RGB rgb) {
        final RandomSource source = RandomSource.m_216327_();
        return new RGBFakeWidget(rgb){

            @Override
            public void draw(GuiGraphics graphics) {
                GLHelper.pushTransform(graphics, pos, this.size, 1.0f, source.m_188501_() * 360.0f);
                RandomRender.rO(graphics, pos, this.size, object, this.rgb);
                GLHelper.popTransform(graphics);
            }
        };
    }

    public static void renderObjectWithRotationAndPos(GuiGraphics graphics, Vector2 minPos, Vector2 maxPos, Vector2 size, Object object, RGB rgb) {
        RandomSource source = RandomSource.m_216327_();
        Vector2 pos = RandomRender.getRandomPosInZone(minPos, maxPos);
        GLHelper.pushTransform(graphics, pos, size, 1.0f, source.m_188501_() * 360.0f);
        RandomRender.rO(graphics, pos, size, object, rgb);
        GLHelper.popTransform(graphics);
    }

    public static RGBFakeWidget renderObjectWithRotationAndPos(Vector2 minPos, Vector2 maxPos, Vector2 size, final Object object, RGB rgb) {
        final RandomSource source = RandomSource.m_216327_();
        final Vector2 pos = RandomRender.getRandomPosInZone(minPos, maxPos);
        return new RGBFakeWidget(rgb){

            @Override
            public void draw(GuiGraphics graphics) {
                GLHelper.pushTransform(graphics, pos, this.size, 1.0f, source.m_188501_() * 360.0f);
                RandomRender.rO(graphics, pos, this.size, object, this.rgb);
                GLHelper.popTransform(graphics);
            }
        };
    }

    public static void renderObject(GuiGraphics graphics, Vector2 minPos, Vector2 maxPos, Vector2 minScale, Vector2 maxScale, Object object, RGB rgb) {
        RandomSource source = RandomSource.m_216327_();
        Vector2 pos = RandomRender.getRandomPosInZone(minPos, maxPos);
        Vector2 size = RandomRender.getRandomScale(minScale, maxScale);
        GLHelper.pushTransform(graphics, pos, size, 1.0f, source.m_188501_() * 360.0f);
        RandomRender.rO(graphics, pos, size, object, rgb);
        GLHelper.popTransform(graphics);
    }

    public static RGBFakeWidget renderObject(Vector2 minPos, Vector2 maxPos, Vector2 minScale, Vector2 maxScale, final Object object, RGB rgb) {
        final RandomSource source = RandomSource.m_216327_();
        final Vector2 pos = RandomRender.getRandomPosInZone(minPos, maxPos);
        final Vector2 sizeD = RandomRender.getRandomScale(minScale, maxScale);
        return new RGBFakeWidget(rgb){

            @Override
            public void draw(GuiGraphics graphics) {
                GLHelper.pushTransform(graphics, pos, sizeD, 1.0f, source.m_188501_() * 360.0f);
                RandomRender.rO(graphics, pos, sizeD, object, this.rgb);
                GLHelper.popTransform(graphics);
            }
        };
    }

    public static void renderObjectCount(GuiGraphics graphics, int count, Vector2 minPos, Vector2 maxPos, Vector2 minScale, Vector2 maxScale, Object object, RGB rgb) {
        for (int i = 0; i < count; ++i) {
            RandomRender.renderObject(graphics, minPos, maxPos, minScale, maxScale, object, rgb);
        }
    }

    public static RGBFakeWidget renderObjectCount(int count, Vector2 minPos, Vector2 maxPos, Vector2 minScale, Vector2 maxScale, Object object, RGB rgb) {
        final ArrayList<RGBFakeWidget> widgets = new ArrayList<RGBFakeWidget>();
        for (int i = 0; i < count; ++i) {
            widgets.add(RandomRender.renderObject(minPos, maxPos, minScale, maxScale, object, rgb));
        }
        return new RGBFakeWidget(rgb){

            @Override
            public void draw(GuiGraphics graphics) {
                for (int i = 0; i < widgets.size(); ++i) {
                    ((RGBFakeWidget)widgets.get(i)).draw(graphics);
                }
            }
        };
    }

    private static void rO(GuiGraphics graphics, Vector2 pos, Vector2 size, Object object, RGB rgb) {
        switch (object) {
            case CUBE: {
                rgb.draw(graphics, pos.x, pos.y, size.x, size.y, 0.0f);
                break;
            }
            case TRIANGLE: {
                rgb.drawTriangle(graphics, pos.x, pos.y, size.x, size.y);
            }
        }
    }

    public static Vector2 getRandomScale(Vector2 minScale, Vector2 maxScale) {
        RandomSource source = RandomSource.m_216327_();
        return new Vector2(source.m_216339_(minScale.x, maxScale.x), source.m_216339_(minScale.y, maxScale.y));
    }

    public static Vector2 getRandomPosInZone(Vector2 startPos, Vector2 endPos) {
        RandomSource source = RandomSource.m_216327_();
        return new Vector2(source.m_216339_(startPos.x, endPos.x), source.m_216339_(startPos.y, endPos.y));
    }

    public static enum Object {
        CUBE,
        TRIANGLE;

    }
}

