/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmuilib.client.render.container;

import net.minecraft.client.gui.GuiGraphics;
import net.sixik.sdmuilib.client.render.container.RenderContainer;
import net.sixik.sdmuilib.client.utils.RenderHelper;
import net.sixik.sdmuilib.client.utils.math.Vector2;
import net.sixik.sdmuilib.client.utils.misc.CenterOperators;

public class RenderContainerImpl
extends RenderContainer {
    public RenderContainerImpl(GuiGraphics graphics, Vector2 mousePosition) {
        super(graphics, mousePosition);
    }

    public void pushScale(int scale, Vector2 position) {
        RenderHelper.pushScale(this.graphics, position.x, position.y, scale);
    }

    public void pushScale(float scale, Vector2 position) {
        RenderHelper.pushScale(this.graphics, position.x, position.y, scale);
    }

    public void popScale() {
        RenderHelper.popScale(this.graphics);
    }

    public void pushUpper() {
        RenderHelper.pushUpper(this.graphics);
    }

    public void pushUpper(float pos) {
        RenderHelper.pushUpper(this.graphics, pos);
    }

    public void popUpper() {
        RenderHelper.popUpper(this.graphics);
    }

    public void pushRotation(Vector2 position, Vector2 size, float angle) {
        RenderHelper.pushRotate(this.graphics, position.x, position.y, size.x, size.y, angle);
    }

    public void popRotation() {
        RenderHelper.popRotate(this.graphics);
    }

    public void pushTransparent(float strange) {
        RenderHelper.setTransparent(this.graphics, strange);
    }

    public void popTransparent() {
        RenderHelper.popTransparent();
    }

    public Vector2 getCenter(Vector2 position, Vector2 size, CenterOperators.Type centerType, CenterOperators.Method method) {
        switch (centerType) {
            case CENTER_X: {
                return new Vector2(position.x + (method.isAbsolute() ? size.x / 3 : size.x / 2), position.y);
            }
            case CENTER_Y: {
                return new Vector2(position.x, position.y + (method.isAbsolute() ? size.y / 3 : size.y / 2));
            }
            case CENTER_XY: {
                return new Vector2(method.isAbsolute() ? size.x / 3 : size.x / 2, position.y + (method.isAbsolute() ? size.y / 3 : size.y / 2));
            }
        }
        return new Vector2(position.x, position.y);
    }

    public Vector2 getCenterWithPos(Vector2 pos, Vector2 size, CenterOperators.Type centerType, CenterOperators.Method method) {
        switch (centerType) {
            case CENTER_X: {
                return new Vector2(pos.x + (method.isAbsolute() ? size.x / 3 : size.x / 2), pos.y);
            }
            case CENTER_Y: {
                return new Vector2(pos.x, pos.y + (method.isAbsolute() ? size.y / 3 : size.y / 2));
            }
            case CENTER_XY: {
                return new Vector2(pos.x + (method.isAbsolute() ? size.x / 3 : size.x / 2), pos.y + (method.isAbsolute() ? size.y / 3 : size.y / 2));
            }
        }
        return new Vector2(pos.x, pos.y);
    }
}

