/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.world.general_features.structures.villages;

import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.data.providers.SkiesLootProv;
import com.legacy.blue_skies.registries.SkiesEntityTypes;
import com.legacy.blue_skies.registries.SkiesJigsawTypes;
import com.legacy.blue_skies.registries.SkiesStructures;
import com.legacy.blue_skies.registries.SkiesVillagers;
import com.legacy.blue_skies.world.general_features.structures.villages.SkiesVillageBiomes;
import com.legacy.blue_skies.world.general_features.structures.villages.SkiesVillageProfessions;
import com.legacy.structure_gel.api.structure.jigsaw.ExtendedJigsawStructurePiece;
import com.legacy.structure_gel.api.structure.jigsaw.IPieceFactory;
import com.legacy.structure_gel.api.structure.jigsaw.JigsawCapability;
import com.mojang.serialization.Codec;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;

public class SkiesVillageStructure {

    public static class Piece
    extends ExtendedJigsawStructurePiece {
        private static final Map<String, EntityType<?>> BASIC_SPAWNS = new HashMap();

        public Piece(IPieceFactory.Context context) {
            super(context);
        }

        public Piece(StructurePieceSerializationContext context, CompoundTag nbt) {
            super(context, nbt);
        }

        public void handleDataMarker(String key, BlockPos pos, ServerLevelAccessor level, RandomSource rand, BoundingBox bounds) {
            if (BASIC_SPAWNS.containsKey(key)) {
                this.spawnEntity(BASIC_SPAWNS.get(key), pos, level, rand, null);
                return;
            }
            if (key.equals("cod")) {
                this.spawnEntity(EntityType.f_20556_, pos, level, rand, cod -> {
                    level.m_7731_(pos, Blocks.f_49990_.m_49966_(), 3);
                    cod.m_21530_();
                });
                return;
            }
            if (key.contains("villager")) {
                this.spawnEntity(EntityType.f_20492_, pos, level, rand, villager -> {
                    if (key.contains("-")) {
                        villager.m_34375_(villager.m_7141_().m_35567_(BuiltInRegistries.f_256934_.m_6612_(BlueSkies.locate(key.split("-")[1])).orElseGet(() -> SkiesVillagers.CALMING_SKIES)));
                    }
                    if (rand.m_188501_() < 0.1f) {
                        if (rand.m_188499_()) {
                            villager.m_34375_(villager.m_7141_().m_35565_(VillagerProfession.f_35596_));
                        } else {
                            villager.m_6863_(true);
                        }
                    }
                });
                return;
            }
            if (key.startsWith("chest")) {
                SkiesVillageBiomes biome;
                this.setAir((LevelAccessor)level, pos);
                String[] data = key.split("-");
                ResourceLocation lootTable = BuiltInLootTables.f_78755_;
                if (data.length > 2) {
                    SkiesVillageProfessions profession = SkiesVillageProfessions.from(data[2]);
                    if (profession != null) {
                        if (data[1].equals("bright")) {
                            lootTable = SkiesLootProv.VILLAGE_EVERBRIGHT_PROFESSIONS.get((Object)profession);
                        } else if (data[1].equals("dawn")) {
                            lootTable = SkiesLootProv.VILLAGE_EVERDAWN_PROFESSIONS.get((Object)profession);
                        }
                    }
                } else if (data.length > 1 && (biome = SkiesVillageBiomes.from(data[1])) != null) {
                    lootTable = SkiesLootProv.VILLAGE_BIOME_CHESTS.get((Object)biome);
                }
                RandomizableContainerBlockEntity.m_222766_((BlockGetter)level, (RandomSource)rand, (BlockPos)pos.m_7495_(), (ResourceLocation)lootTable);
                return;
            }
        }

        private <T extends Entity> void spawnEntity(EntityType<T> entityType, BlockPos pos, ServerLevelAccessor level, RandomSource rand, @Nullable Consumer<T> modifyEntity) {
            this.setAir((LevelAccessor)level, pos);
            Entity entity = this.createEntity(entityType, level, pos, this.f_72599_);
            if (modifyEntity != null) {
                modifyEntity.accept(entity);
            }
            if (entity instanceof Mob) {
                ((Mob)entity).m_6518_(level, level.m_6436_(pos), MobSpawnType.STRUCTURE, null, null);
            }
            level.m_7967_(entity);
        }

        public StructurePieceType m_210000_() {
            return (StructurePieceType)SkiesStructures.BLUE_SKIES_VILLAGE.getPieceType().get();
        }

        static {
            BASIC_SPAWNS.put("golem", EntityType.f_20460_);
            BASIC_SPAWNS.put("azulfo", SkiesEntityTypes.AZULFO);
            BASIC_SPAWNS.put("ram", SkiesEntityTypes.STARDUST_RAM);
            BASIC_SPAWNS.put("monitor", SkiesEntityTypes.SHADE_MONITOR);
            BASIC_SPAWNS.put("camel", SkiesEntityTypes.CRYSTAL_CAMEL);
        }
    }

    public static class Capability
    implements JigsawCapability.IJigsawCapability {
        public static final Capability INSTANCE = new Capability();
        public static final Codec<Capability> CODEC = Codec.unit((Object)INSTANCE);

        public JigsawCapability.JigsawType<?> getType() {
            return SkiesJigsawTypes.VILLAGE;
        }

        public IPieceFactory getPieceFactory() {
            return Piece::new;
        }
    }
}

