/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.items;

import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.items.LootBagItem;
import com.legacy.blue_skies.items.util.IRarityItem;
import java.util.function.Supplier;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class BossLootBagItem
extends LootBagItem {
    private final Supplier<EntityType<?>> boss;

    public BossLootBagItem(Item.Properties properties, Supplier<EntityType<?>> boss) {
        super(properties);
        this.boss = boss;
    }

    @Override
    public <T extends Item> void fillItemCategoryWithRarity(CreativeModeTab.Output output, T item, CreativeModeTab.TabVisibility visibility) {
        String bossName = ForgeRegistries.ENTITY_TYPES.getKey(this.boss.get()).m_135815_();
        for (IRarityItem.SkiesRarity rarity : IRarityItem.SkiesRarity.values()) {
            ItemStack stack = new ItemStack(item);
            ((IRarityItem)item).setRarityTag(stack, rarity);
            LootBagItem.setLootTable(stack, BlueSkies.locate("loot_bags/" + bossName + "/" + rarity));
            output.m_246267_(stack, visibility);
        }
    }

    @Override
    public void fillTabs(CreativeModeTab.Output output) {
        this.fillItemCategoryWithRarity(output, this, CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY);
        ItemStack stack = new ItemStack((ItemLike)this);
        String bossName = ForgeRegistries.ENTITY_TYPES.getKey(this.boss.get()).m_135815_();
        this.setRarityTag(stack, IRarityItem.SkiesRarity.COMMON);
        LootBagItem.setLootTable(stack, BlueSkies.locate("loot_bags/" + bossName + "/" + IRarityItem.SkiesRarity.COMMON));
        output.m_246267_(stack, CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
    }
}

