/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.entities.hostile;

import com.legacy.blue_skies.entities.util.base.SkiesMonsterEntity;
import com.legacy.blue_skies.registries.SkiesSounds;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ShrumptyEntity
extends SkiesMonsterEntity {
    public boolean shouldSpreadLegs = false;
    public boolean safeDistance = true;
    public boolean landedHit = false;

    public ShrumptyEntity(EntityType<? extends ShrumptyEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 16.0).m_22268_(Attributes.f_22279_, 0.3);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 20.0f, 1.2, 1.2){

            public boolean m_8036_() {
                return !ShrumptyEntity.this.safeDistance && super.m_8036_();
            }

            public boolean m_8045_() {
                return !ShrumptyEntity.this.safeDistance && super.m_8045_();
            }
        });
        this.f_21345_.m_25352_(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2f, true){

            public boolean m_8036_() {
                return !ShrumptyEntity.this.landedHit && super.m_8036_();
            }

            public boolean m_8045_() {
                return !ShrumptyEntity.this.landedHit && super.m_8045_();
            }
        });
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 1.0E-5f));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    @Override
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        spawnDataIn = super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        return spawnDataIn;
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.safeDistance && this.m_9236_().m_45924_(this.m_20185_(), this.m_20186_(), this.m_20189_(), 15.0, true) == null) {
            this.safeDistance = true;
            this.landedHit = false;
        }
        if (!this.m_9236_().f_46443_) {
            this.setShrumptyNoticed(!this.m_21573_().m_26571_() || this.f_20902_ != 0.0f || this.m_5448_() != null);
        }
    }

    protected SoundEvent m_7515_() {
        return SkiesSounds.ENTITY_SHRUMPTY_IDLE;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SkiesSounds.ENTITY_SHRUMPTY_HURT;
    }

    protected SoundEvent m_5592_() {
        return SkiesSounds.ENTITY_SHRUMPTY_DEATH;
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        super.m_7355_(pos, blockIn);
    }

    protected float m_6121_() {
        return 1.0f;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        return super.m_6469_(source, amount);
    }

    public boolean m_7327_(Entity entityIn) {
        this.safeDistance = false;
        this.landedHit = true;
        this.m_5496_(SkiesSounds.ENTITY_SHRUMPTY_ATTACK, this.m_6121_(), this.m_6100_());
        if (this.m_20096_()) {
            Vec3 vec3d = this.m_20184_();
            Vec3 vec3d1 = new Vec3(entityIn.m_20185_() - this.m_20185_(), 0.0, entityIn.m_20189_() - this.m_20189_());
            if (vec3d1.m_82556_() > 1.0E-7) {
                vec3d1 = vec3d1.m_82541_().m_82490_(0.4).m_82549_(vec3d.m_82490_(0.2));
            }
            this.m_20334_(vec3d1.f_82479_, 0.3f, vec3d1.f_82481_);
        }
        if (entityIn instanceof LivingEntity) {
            ((LivingEntity)entityIn).m_7292_(new MobEffectInstance(MobEffects.f_19597_, 40, 2));
        }
        return super.m_7327_(entityIn);
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return super.m_6431_(poseIn, sizeIn);
    }

    public void setShrumptyNoticed(boolean noticedIn) {
        if (noticedIn) {
            this.shouldSpreadLegs = true;
            this.m_9236_().m_7605_((Entity)this, (byte)4);
        } else {
            this.shouldSpreadLegs = false;
            this.m_9236_().m_7605_((Entity)this, (byte)5);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7822_(byte id) {
        switch (id) {
            case 4: {
                this.shouldSpreadLegs = true;
                break;
            }
            case 5: {
                this.shouldSpreadLegs = false;
                break;
            }
            default: {
                super.m_7822_(id);
            }
        }
    }

    public int m_5792_() {
        return 1;
    }
}

