/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.client.gui.menu;

import com.legacy.blue_skies.block_entity.HorizoniteForgeBlockEntity;
import com.legacy.blue_skies.block_entity.IRecipeUnlocker;
import com.legacy.blue_skies.registries.SkiesContainers;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.FurnaceResultSlot;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.RecipeBookType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;

public class HorizoniteForgeMenu
extends RecipeBookMenu<Container> {
    private final Container tile;
    private final ContainerData furnaceData;
    protected final Level world;

    public HorizoniteForgeMenu(int id, Inventory playerInv) {
        this(id, playerInv, (Container)new SimpleContainer(3), (ContainerData)new SimpleContainerData(4));
    }

    public HorizoniteForgeMenu(int id, Inventory playerInv, Container tile, ContainerData furnaceData) {
        super(SkiesContainers.HORIZONITE_FORGE, id);
        this.tile = tile;
        this.furnaceData = furnaceData;
        this.world = playerInv.f_35978_.m_9236_();
        this.m_38897_(new Slot(tile, 0, 56, 17));
        this.m_38897_(new FuelSlot(this, tile, 1, 22, 54));
        this.m_38897_((Slot)new ResultSlot(playerInv.f_35978_, tile, 2, 116, 35));
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)playerInv, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.m_38897_(new Slot((Container)playerInv, k, 8 + k * 18, 142));
        }
        this.m_38884_(furnaceData);
    }

    public void m_5816_(StackedContents itemHelperIn) {
        if (this.tile instanceof StackedContentsCompatible) {
            ((StackedContentsCompatible)this.tile).m_5809_(itemHelperIn);
        }
    }

    public boolean m_142157_(int slotIndex) {
        return slotIndex != 1;
    }

    public void m_6650_() {
        this.m_38853_(0).m_5852_(ItemStack.f_41583_);
        this.m_38853_(2).m_5852_(ItemStack.f_41583_);
    }

    public boolean m_6032_(Recipe<? super Container> recipeIn) {
        return recipeIn.m_5818_(this.tile, this.world);
    }

    public int m_6636_() {
        return 2;
    }

    public int m_6635_() {
        return 1;
    }

    public int m_6656_() {
        return 1;
    }

    public int m_6653_() {
        return 3;
    }

    public boolean m_6875_(Player player) {
        return this.tile.m_6542_(player);
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        ItemStack existingClone = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack existingStack = slot.m_7993_();
            existingClone = existingStack.m_41777_();
            if (index == 2) {
                if (!this.m_38903_(existingStack, 3, 39, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(existingStack, existingClone);
            } else if (index != 1 && index != 0 ? (this.hasRecipe(existingStack) ? !this.m_38903_(existingStack, 0, 1, false) : (this.isFuel(existingStack) ? !this.m_38903_(existingStack, 1, 2, false) : (index >= 3 && index < 30 ? !this.m_38903_(existingStack, 30, 39, false) : index >= 30 && index < 39 && !this.m_38903_(existingStack, 3, 30, false)))) : !this.m_38903_(existingStack, 3, 39, false)) {
                return ItemStack.f_41583_;
            }
            if (existingStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (existingStack.m_41613_() == existingClone.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(playerIn, existingStack);
        }
        return existingClone;
    }

    protected boolean hasRecipe(ItemStack stack) {
        return this.world.m_7465_().m_44015_(RecipeType.f_44108_, (Container)new SimpleContainer(new ItemStack[]{stack}), this.world).isPresent();
    }

    protected boolean isFuel(ItemStack stack) {
        return HorizoniteForgeBlockEntity.isFuel(stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getCookProgressionScaled() {
        double cookTime = this.furnaceData.m_6413_(2);
        double maxCookTime = this.furnaceData.m_6413_(3);
        return (int)(cookTime / maxCookTime * 24.0);
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getEnergyLeftScaled() {
        double maxEnergy;
        double energy = this.furnaceData.m_6413_(0);
        double scaled = energy / (maxEnergy = (double)this.furnaceData.m_6413_(1)) * 32.0;
        return scaled > 0.0 && scaled < 1.0 ? 1 : (int)scaled;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isCooking() {
        return this.furnaceData.m_6413_(2) > 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public RecipeBookType m_5867_() {
        return RecipeBookType.FURNACE;
    }

    public static class FuelSlot
    extends Slot {
        private final HorizoniteForgeMenu container;

        public FuelSlot(HorizoniteForgeMenu container, Container furnaceInv, int id, int x, int y) {
            super(furnaceInv, id, x, y);
            this.container = container;
        }

        public boolean m_5857_(ItemStack stack) {
            return this.container.isFuel(stack);
        }
    }

    public static class ResultSlot
    extends FurnaceResultSlot {
        private final Player player;
        private int removeCount;

        public ResultSlot(Player player, Container furnaceInv, int id, int x, int y) {
            super(player, furnaceInv, id, x, y);
            this.player = player;
        }

        public boolean m_5857_(ItemStack stack) {
            return false;
        }

        public ItemStack m_6201_(int amount) {
            if (this.m_6657_()) {
                this.removeCount += Math.min(amount, this.m_7993_().m_41613_());
            }
            return super.m_6201_(amount);
        }

        public void m_142406_(Player player, ItemStack stack) {
            this.m_5845_(stack);
            super.m_142406_(player, stack);
        }

        protected void m_7169_(ItemStack stack, int amount) {
            this.removeCount += amount;
            this.m_5845_(stack);
        }

        protected void m_5845_(ItemStack stack) {
            stack.m_41678_(this.player.m_9236_(), this.player, this.removeCount);
            if (!this.player.m_9236_().m_5776_() && this.f_40218_ instanceof IRecipeUnlocker) {
                ((IRecipeUnlocker)this.f_40218_).unlockRecipes(this.player);
            }
            this.removeCount = 0;
            ForgeEventFactory.firePlayerSmeltedEvent((Player)this.player, (ItemStack)stack);
        }
    }
}

