/*
 * Decompiled with CFR 0.152.
 */
package net.liopyu.entityjs.entities.nonliving.entityjs;

import java.util.Objects;
import javax.annotation.Nullable;
import net.liopyu.entityjs.builders.nonliving.entityjs.PartBuilder;
import net.liopyu.entityjs.util.ContextUtils;
import net.liopyu.entityjs.util.EntityJSHelperClass;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class PartEntityJS<T extends LivingEntity>
extends PartEntity<T> {
    public final T parentMob;
    public final String name;
    private final EntityDimensions size;
    public float width;
    public float height;
    protected final PartBuilder<T> builder;

    public PartEntityJS(T pParentMob, String pName, float pWidth, float pHeight, PartBuilder<T> builder) {
        super(pParentMob);
        this.builder = builder;
        this.size = EntityDimensions.m_20395_((float)pWidth, (float)pHeight);
        this.m_6210_();
        this.parentMob = pParentMob;
        this.name = pName;
        this.width = pWidth;
        this.height = pHeight;
    }

    public PartEntityJS(Entity pParentMob, String name, float width, float height, PartBuilder<?> builder) {
        super((Entity)((LivingEntity)pParentMob));
        this.builder = builder;
        this.size = EntityDimensions.m_20395_((float)width, (float)height);
        this.m_6210_();
        this.parentMob = (LivingEntity)pParentMob;
        this.name = name;
        this.width = width;
        this.height = height;
    }

    public boolean m_5829_() {
        if (this.builder.canBeCollidedWith == null) {
            return super.m_5829_();
        }
        Object obj = this.builder.canBeCollidedWith.apply((Entity)this);
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for canBeCollidedWith from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.m_5829_());
        return super.m_5829_();
    }

    public String entityName() {
        return this.name;
    }

    public boolean m_6087_() {
        return this.builder.isPickable;
    }

    protected void m_8097_() {
    }

    protected void m_7378_(CompoundTag pCompound) {
    }

    protected void m_7380_(CompoundTag pCompound) {
    }

    @Nullable
    public ItemStack m_142340_() {
        return this.parentMob.m_142340_();
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        return !this.m_6673_(pSource) && this.partHurt(this, pSource, pAmount);
    }

    private boolean partHurt(PartEntityJS<T> partEntity, DamageSource pSource, float pDamage) {
        if (pDamage <= 0.0f) {
            return false;
        }
        if (this.builder.onPartHurt != null) {
            ContextUtils.PartHurtContext<T> context = new ContextUtils.PartHurtContext<T>(partEntity, pSource, pDamage, (LivingEntity)this.parentMob);
            this.builder.onPartHurt.accept(context);
            return true;
        }
        this.parentMob.m_6469_(pSource, pDamage);
        return true;
    }

    public boolean m_7306_(Entity pEntity) {
        return this == pEntity || this.parentMob == pEntity;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        throw new UnsupportedOperationException();
    }

    public void movePart(double pX, double pY, double pZ, float pYRot, float pXRot) {
        super.m_7678_(pX, pY, pZ, pYRot, pXRot);
    }

    public EntityDimensions m_6972_(Pose pPose) {
        return this.size;
    }

    public boolean m_142391_() {
        return false;
    }

    public boolean m_6783_(double distance) {
        if (this.builder.shouldRenderAtSqrDistance != null) {
            ContextUtils.EntitySqrDistanceContext context = new ContextUtils.EntitySqrDistanceContext(distance, (Entity)this);
            Object obj = this.builder.shouldRenderAtSqrDistance.apply(context);
            if (obj instanceof Boolean) {
                Boolean b = (Boolean)obj;
                return b;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid shouldRenderAtSqrDistance for builder: " + obj + ". Must be a boolean. Defaulting to super method: " + super.m_6783_(distance));
        }
        return super.m_6783_(distance);
    }

    public void m_6453_(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        super.m_6453_(x, y, z, yaw, pitch, posRotationIncrements, teleport);
        if (this.builder.lerpTo != null) {
            ContextUtils.LerpToContext context = new ContextUtils.LerpToContext(x, y, z, yaw, pitch, posRotationIncrements, teleport, (Entity)this);
            this.builder.lerpTo.accept(context);
        }
    }

    public T getParent() {
        return this.parentMob;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.builder.tick != null) {
            this.builder.tick.accept((Entity)this);
        }
    }

    public void m_6478_(MoverType pType, Vec3 pPos) {
        super.m_6478_(pType, pPos);
        if (this.builder.move != null) {
            ContextUtils.MovementContext context = new ContextUtils.MovementContext(pType, pPos, (Entity)this);
            this.builder.move.accept(context);
        }
    }

    public void m_6123_(Player player) {
        if (this.builder != null && this.builder.playerTouch != null) {
            ContextUtils.EntityPlayerContext context = new ContextUtils.EntityPlayerContext(player, (Entity)this);
            this.builder.playerTouch.accept(context);
        } else {
            super.m_6123_(player);
        }
    }

    public boolean m_6097_() {
        if (this.builder.isAttackable != null) {
            Object obj = this.builder.isAttackable.apply((Entity)this);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for isAttackable from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.m_6097_());
        }
        return super.m_6097_();
    }

    public LivingEntity m_6688_() {
        LivingEntity entity;
        Entity var2 = this.m_146895_();
        LivingEntity var10000 = var2 instanceof LivingEntity ? (entity = (LivingEntity)var2) : null;
        return var10000;
    }

    public boolean m_7337_(Entity pEntity) {
        if (this.builder.canCollideWith != null) {
            ContextUtils.ECollidingEntityContext context = new ContextUtils.ECollidingEntityContext((Entity)this, pEntity);
            Object obj = this.builder.canCollideWith.apply(context);
            if (obj instanceof Boolean) {
                Boolean b = (Boolean)obj;
                return b;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for canCollideWith from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.m_7337_(pEntity));
        }
        return super.m_7337_(pEntity);
    }

    protected float m_20098_() {
        if (this.builder.setBlockJumpFactor == null) {
            return super.m_20098_();
        }
        Object obj = EntityJSHelperClass.convertObjectToDesired(this.builder.setBlockJumpFactor.apply((Entity)this), "float");
        if (obj != null) {
            return ((Float)obj).floatValue();
        }
        EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for setBlockJumpFactor from entity: " + this.entityName() + ". Value: " + this.builder.setBlockJumpFactor.apply((Entity)this) + ". Must be a float. Defaulting to " + super.m_20098_());
        return super.m_20098_();
    }

    public boolean m_6094_() {
        return this.builder.isPushable;
    }

    protected float m_6041_() {
        if (this.builder.blockSpeedFactor == null) {
            return super.m_6041_();
        }
        Object obj = EntityJSHelperClass.convertObjectToDesired(this.builder.blockSpeedFactor.apply((Entity)this), "float");
        if (obj != null) {
            return ((Float)obj).floatValue();
        }
        EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for blockSpeedFactor from entity: " + this.entityName() + ". Value: " + this.builder.blockSpeedFactor.apply((Entity)this) + ". Must be a float, defaulting to " + super.m_6041_());
        return super.m_6041_();
    }

    protected void m_19956_(Entity pPassenger, Entity.MoveFunction pCallback) {
        if (this.builder.positionRider != null) {
            ContextUtils.PositionRiderContext context = new ContextUtils.PositionRiderContext((Entity)this, pPassenger, pCallback);
            EntityJSHelperClass.consumerCallback(this.builder.positionRider, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: positionRider.");
            return;
        }
        super.m_19956_(pPassenger, pCallback);
    }

    protected boolean m_7310_(@NotNull Entity entity) {
        if (this.builder.canAddPassenger == null) {
            return super.m_7310_(entity);
        }
        ContextUtils.EPassengerEntityContext context = new ContextUtils.EPassengerEntityContext(entity, (Entity)this);
        Object obj = this.builder.canAddPassenger.apply(context);
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for canAddPassenger from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean, defaulting to " + super.m_7310_(entity));
        return super.m_7310_(entity);
    }

    protected boolean m_142039_() {
        if (this.builder.isFlapping != null) {
            Object obj = this.builder.isFlapping.apply((Entity)this);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for isFlapping from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.m_142039_());
        }
        return super.m_142039_();
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        if (this.builder.onAddedToWorld != null) {
            this.builder.onAddedToWorld.accept((Entity)this);
        }
    }

    protected boolean m_6093_() {
        return Objects.requireNonNullElseGet(this.builder.repositionEntityAfterLoad, () -> super.m_6093_());
    }

    protected float m_6059_() {
        if (this.builder.nextStep != null) {
            Object obj = EntityJSHelperClass.convertObjectToDesired(this.builder.nextStep.apply((Entity)this), "float");
            if (obj != null) {
                return ((Float)obj).floatValue();
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for nextStep from entity: " + this.entityName() + ". Value: " + this.builder.nextStep.apply((Entity)this) + ". Must be a float, defaulting to " + super.m_6059_());
        }
        return super.m_6059_();
    }

    protected SoundEvent m_5509_() {
        if (this.builder.setSwimSplashSound == null) {
            return super.m_5509_();
        }
        return Objects.requireNonNull((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue((ResourceLocation)this.builder.setSwimSplashSound));
    }

    protected SoundEvent m_5501_() {
        if (this.builder.setSwimSound == null) {
            return super.m_5501_();
        }
        return Objects.requireNonNull((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue((ResourceLocation)this.builder.setSwimSound));
    }

    public boolean m_142535_(float distance, float damageMultiplier, @NotNull DamageSource damageSource) {
        if (this.builder.onFall != null) {
            ContextUtils.EEntityFallDamageContext context = new ContextUtils.EEntityFallDamageContext((Entity)this, damageMultiplier, distance, damageSource);
            this.builder.onFall.accept(context);
        }
        return super.m_142535_(distance, damageMultiplier, damageSource);
    }

    public void m_6858_(boolean sprinting) {
        if (this.builder.onSprint != null) {
            this.builder.onSprint.accept((Entity)this);
        }
        super.m_6858_(sprinting);
    }

    public void m_8127_() {
        super.m_8127_();
        if (this.builder.onStopRiding != null) {
            this.builder.onStopRiding.accept((Entity)this);
        }
    }

    public void m_6083_() {
        super.m_6083_();
        if (this.builder.rideTick != null) {
            this.builder.rideTick.accept((Entity)this);
        }
    }

    public boolean m_142079_() {
        if (this.builder.canFreeze != null) {
            Object obj = this.builder.canFreeze.apply((Entity)this);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for canFreeze from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.m_142079_());
        }
        return super.m_142079_();
    }

    public boolean m_203117_() {
        if (this.builder.isFreezing != null) {
            Object obj = this.builder.isFreezing.apply((Entity)this);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for isFreezing from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.m_203117_());
        }
        return super.m_203117_();
    }

    public boolean m_142038_() {
        if (this.builder.isCurrentlyGlowing != null) {
            Object obj = this.builder.isCurrentlyGlowing.apply((Entity)this);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for isCurrentlyGlowing from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.m_142038_());
        }
        return super.m_142038_();
    }

    public void m_142036_() {
        if (this.builder.onClientRemoval != null) {
            this.builder.onClientRemoval.accept((Entity)this);
        }
        super.m_142036_();
    }

    public void m_20093_() {
        if (this.builder.lavaHurt != null) {
            this.builder.lavaHurt.accept((Entity)this);
        }
        super.m_20093_();
    }

    protected void m_142043_() {
        if (this.builder.onFlap != null) {
            this.builder.onFlap.accept((Entity)this);
        }
        super.m_142043_();
    }

    public boolean m_213854_() {
        if (this.builder.dampensVibrations != null) {
            Object obj = this.builder.dampensVibrations.apply((Entity)this);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for dampensVibrations from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.m_213854_());
        }
        return super.m_213854_();
    }

    public boolean m_20152_() {
        if (this.builder.showVehicleHealth != null) {
            Object obj = this.builder.showVehicleHealth.apply((Entity)this);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for showVehicleHealth from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.m_20152_());
        }
        return super.m_20152_();
    }

    public void m_8038_(ServerLevel p_19927_, LightningBolt p_19928_) {
        if (this.builder.thunderHit != null) {
            super.m_8038_(p_19927_, p_19928_);
            ContextUtils.EThunderHitContext context = new ContextUtils.EThunderHitContext(p_19927_, p_19928_, (Entity)this);
            this.builder.thunderHit.accept(context);
        }
    }

    public boolean m_6673_(DamageSource p_20122_) {
        if (this.builder.isInvulnerableTo != null) {
            ContextUtils.EDamageContext context = new ContextUtils.EDamageContext((Entity)this, p_20122_);
            Object obj = this.builder.isInvulnerableTo.apply(context);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for isInvulnerableTo from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.m_6673_(p_20122_));
        }
        return super.m_6673_(p_20122_);
    }

    public boolean m_6072_() {
        if (this.builder.canChangeDimensions != null) {
            Object obj = this.builder.canChangeDimensions.apply((Entity)this);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for canChangeDimensions from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.m_6072_());
        }
        return super.m_6072_();
    }

    public boolean m_142265_(@NotNull Level p_146843_, @NotNull BlockPos p_146844_) {
        if (this.builder.mayInteract != null) {
            ContextUtils.EMayInteractContext context = new ContextUtils.EMayInteractContext(p_146843_, p_146844_, (Entity)this);
            Object obj = this.builder.mayInteract.apply(context);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for mayInteract from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.m_142265_(p_146843_, p_146844_));
        }
        return super.m_142265_(p_146843_, p_146844_);
    }

    public boolean canTrample(@NotNull BlockState state, @NotNull BlockPos pos, float fallDistance) {
        if (this.builder.canTrample != null) {
            ContextUtils.ECanTrampleContext context = new ContextUtils.ECanTrampleContext(state, pos, fallDistance, (Entity)this);
            Object obj = this.builder.canTrample.apply(context);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for canTrample from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.canTrample(state, pos, fallDistance));
        }
        return super.canTrample(state, pos, fallDistance);
    }

    public void onRemovedFromWorld() {
        if (this.builder != null && this.builder.onRemovedFromWorld != null) {
            EntityJSHelperClass.consumerCallback(this.builder.onRemovedFromWorld, this, "[EntityJS]: Error in " + this.entityName() + "builder for field: onRemovedFromWorld.");
        }
        super.onRemovedFromWorld();
    }

    public int m_6056_() {
        if (this.builder.setMaxFallDistance == null) {
            return super.m_6056_();
        }
        Object obj = EntityJSHelperClass.convertObjectToDesired(this.builder.setMaxFallDistance.apply((Entity)this), "integer");
        if (obj != null) {
            return (Integer)obj;
        }
        EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for setMaxFallDistance from entity: " + this.entityName() + ". Value: " + this.builder.setMaxFallDistance.apply((Entity)this) + ". Must be an integer. Defaulting to " + super.m_6056_());
        return super.m_6056_();
    }
}

