/*
 * Decompiled with CFR 0.152.
 */
package net.liopyu.entityjs.client.nonliving.model;

import dev.latvian.mods.kubejs.typings.Info;
import java.util.function.Consumer;
import java.util.function.Function;
import net.liopyu.entityjs.builders.nonliving.BaseEntityBuilder;
import net.liopyu.entityjs.client.nonliving.KubeJSNLEntityRenderer;
import net.liopyu.entityjs.client.nonliving.model.NLGeoLayerJS;
import net.liopyu.entityjs.client.nonliving.model.NLGlowingGeoLayerJS;
import net.liopyu.entityjs.entities.nonliving.entityjs.IAnimatableJSNL;
import net.liopyu.entityjs.util.ContextUtils;
import net.liopyu.entityjs.util.EntityJSHelperClass;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class NLGeoLayerJSBuilder<T extends Entity> {
    public transient Function<T, Object> textureResource;
    public BaseEntityBuilder<T> builder;
    public transient Consumer<ContextUtils.PreRenderContext<T>> render;
    public transient Consumer<ContextUtils.PreRenderContext<T>> preRender;
    public transient RenderType setRenderType;
    public transient Function<T, RenderType> renderTypeFunction;

    public NLGeoLayerJSBuilder(BaseEntityBuilder<T> builder) {
        this.builder = builder;
    }

    public NLGeoLayerJS<T> build(KubeJSNLEntityRenderer<T> entityRendererIn, BaseEntityBuilder<T> builder) {
        return new NLGeoLayerJS<T>(entityRendererIn, this, builder);
    }

    public NLGlowingGeoLayerJS<T> buildGlowing(KubeJSNLEntityRenderer<T> entityRendererIn, BaseEntityBuilder<T> builder) {
        return new NLGlowingGeoLayerJS<T>(entityRendererIn, this, builder);
    }

    public BaseEntityBuilder<T> getBuilder() {
        return this.builder;
    }

    @Info(value="Defines logic to preRender the newGeoLayer.\n\nExample usage:\n```javascript\ngeoBuilder.preRender(context => {\n    // Define logic to render the newGeoLayer\n    if (context.entity.isBaby()) {\n        context.poseStack.scale(0.5, 0.5, 0.5);\n    }\n});\n```\n")
    public NLGeoLayerJSBuilder<T> preRender(Consumer<ContextUtils.PreRenderContext<T>> preRender) {
        this.preRender = preRender;
        return this;
    }

    @Info(value="Defines logic to render the newGeoLayer.\nBy default this will render the flat texture set in textureResource\nonto the entity as an overlay. This method overrides the render method completely\nallowing scripters to define their own render logic.\n\nExample usage:\n```javascript\ngeoBuilder.render(context => {\n    // Define logic to render the newGeoLayer\n    if (context.entity.isBaby()) {\n        context.poseStack.scale(0.5, 0.5, 0.5);\n    }\n});\n```\n")
    public NLGeoLayerJSBuilder<T> render(Consumer<ContextUtils.PreRenderContext<T>> render) {
        this.render = render;
        return this;
    }

    @Info(value="Sets a function to determine the texture resource for the entity.\nThe provided Function accepts a parameter of type T (the entity),\nallowing changing the texture based on information about the entity.\nThe default behavior returns <namespace>:textures/entity/<path>.png.\n\nExample usage:\n```javascript\nentityBuilder.textureResource(entity => {\n    // Define logic to determine the texture resource for the entity\n    // Use information about the entity provided by the context.\n    return \"kubejs:textures/entity/wyrm.png\" // Some ResourceLocation representing the texture resource;\n});\n```\n")
    public NLGeoLayerJSBuilder<T> textureResource(Function<T, Object> function) {
        this.textureResource = entity -> {
            Object obj = function.apply(entity);
            if (obj instanceof String && !obj.toString().equals("undefined")) {
                return new ResourceLocation((String)obj);
            }
            if (obj instanceof ResourceLocation) {
                return (ResourceLocation)obj;
            }
            EntityJSHelperClass.logWarningMessageOnce("Invalid return value for textureResource in newGeoLayer builder: " + obj + ". Defaulting to " + ((IAnimatableJSNL)entity).getBuilder().newID("textures/entity/", ".png"));
            return ((IAnimatableJSNL)entity).getBuilder().newID("textures/entity/", ".png");
        };
        return this;
    }

    @Info(value="Sets the render type for the entity's layer.\n\nExample usage:\n```javascript\nbuilder.setRenderType(RenderType.entityCutoutNoCull(\"kubejs:path/to/texture\", true));\n```\n")
    public NLGeoLayerJSBuilder<T> setRenderType(RenderType type) {
        this.setRenderType = type;
        return this;
    }

    @Info(value="Sets the render type for the entity's layer via a function.\n\nExample usage:\n```javascript\nbuilder.renderType(entity => RenderType.entityCutoutNoCull(\"kubejs:path/to/texture\", outlineEntityBoolean));\n```\n")
    public NLGeoLayerJSBuilder<T> renderType(Function<T, RenderType> type) {
        this.renderTypeFunction = type;
        return this;
    }
}

