/*
 * Decompiled with CFR 0.152.
 */
package net.liopyu.entityjs.builders.misc;

import dev.latvian.mods.kubejs.registry.BuilderBase;
import dev.latvian.mods.kubejs.registry.RegistryInfo;
import dev.latvian.mods.kubejs.typings.Generics;
import dev.latvian.mods.kubejs.typings.Info;
import dev.latvian.mods.rhino.util.HideFromJS;
import java.util.function.Consumer;
import net.liopyu.entityjs.builders.misc.CustomEntityJSBuilder;
import net.liopyu.entityjs.builders.misc.EntityReflection;
import net.liopyu.entityjs.item.SpawnEggItemBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;

public class CustomEntityBuilder
extends CustomEntityJSBuilder {
    private final Class<?> entityClass;
    public transient SpawnEggItemBuilder eggItem;
    public transient boolean noEggItem = false;

    public CustomEntityBuilder(ResourceLocation i, Class<? extends LivingEntity> entityClass) {
        super(i);
        this.entityClass = EntityReflection.createEntityClass(entityClass);
        if (Mob.class.isAssignableFrom(entityClass)) {
            this.eggItem = new SpawnEggItemBuilder(this.id, this).backgroundColor(0).highlightColor(0);
        }
    }

    @Info(value="Indicates that no egg item should be created for this entity type")
    public CustomEntityBuilder noEggItem() {
        this.noEggItem = true;
        return this;
    }

    @Info(value="Creates a spawn egg item for this entity type")
    @Generics(value={Mob.class, SpawnEggItemBuilder.class})
    public CustomEntityBuilder eggItem(Consumer<SpawnEggItemBuilder> eggItem) {
        this.eggItem = new SpawnEggItemBuilder(this.id, this);
        eggItem.accept(this.eggItem);
        return this;
    }

    @HideFromJS
    public void createAdditionalObjects() {
        if (this.noEggItem || !Mob.class.isAssignableFrom(this.entityClass)) {
            return;
        }
        RegistryInfo.ITEM.addBuilder((BuilderBase)this.eggItem);
    }

    @Override
    public AttributeSupplier.Builder getAttributeBuilder() {
        return Mob.m_21552_().m_22266_(Attributes.f_22276_).m_22266_(Attributes.f_22279_).m_22266_(Attributes.f_22281_).m_22266_(Attributes.f_22277_).m_22266_(Attributes.f_22285_).m_22266_(Attributes.f_22287_).m_22266_(Attributes.f_22282_).m_22266_(Attributes.f_22280_).m_22266_(Attributes.f_22288_).m_22266_(Attributes.f_22286_).m_22266_(Attributes.f_22283_).m_22266_(Attributes.f_22278_).m_22266_(Attributes.f_22284_);
    }

    public EntityType.EntityFactory<? extends LivingEntity> factory() {
        return (type, world) -> {
            if (this.entityClass == null) {
                throw new IllegalStateException("Entity class not set! Call .set(Class<T>) before using this builder.");
            }
            try {
                return (LivingEntity)this.entityClass.getDeclaredConstructor(EntityType.class, Level.class).newInstance(type, world);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to dynamically instantiate entity: " + this.id, e);
            }
        };
    }
}

