/*
 * Decompiled with CFR 0.152.
 */
package com.squoshi.irons_spells_js.util;

import dev.latvian.mods.kubejs.registry.BuilderBase;
import dev.latvian.mods.kubejs.util.ConsoleJS;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.RegistryObject;

public class ISSKJSUtils {
    public static <T> boolean safeCallback(Consumer<T> consumer, T value, String errorMessage) {
        try {
            consumer.accept(value);
        }
        catch (Throwable e) {
            ConsoleJS.STARTUP.error(errorMessage, e);
            return false;
        }
        return true;
    }

    public static <T> boolean safePredicate(Predicate<T> predicate, T value, String errorMessage) {
        try {
            return predicate.test(value);
        }
        catch (Throwable e) {
            ConsoleJS.STARTUP.error(errorMessage, e);
            return false;
        }
    }

    public static interface ResourceHolder<T extends ResourceHolder<T>> {
        public static <T extends ResourceHolder<T>> T of(Object o, Function<ResourceLocation, T> constructor) {
            if (o instanceof String) {
                String str = (String)o;
                return (T)((ResourceHolder)constructor.apply(new ResourceLocation(str)));
            }
            if (o instanceof ResourceLocation) {
                ResourceLocation rl = (ResourceLocation)o;
                return (T)((ResourceHolder)constructor.apply(rl));
            }
            if (o instanceof RegistryObject) {
                RegistryObject reg = (RegistryObject)o;
                return (T)((ResourceHolder)constructor.apply(reg.getId()));
            }
            if (o instanceof BuilderBase) {
                BuilderBase builder = (BuilderBase)o;
                return (T)((ResourceHolder)constructor.apply(builder.id));
            }
            throw new IllegalArgumentException("Object " + o + " of class " + o.getClass().getName() + " is not valid, should be a String or ResourceLocation.");
        }
    }

    public record DamageTypeHolder(ResourceLocation getLocation) implements ResourceHolder<DamageTypeHolder>
    {
        public static DamageTypeHolder of(Object o) {
            return ResourceHolder.of(o, DamageTypeHolder::new);
        }
    }

    public record SchoolHolder(ResourceLocation getLocation) implements ResourceHolder<SchoolHolder>
    {
        public static SchoolHolder of(Object o) {
            return ResourceHolder.of(o, SchoolHolder::new);
        }
    }

    public record SpellHolder(ResourceLocation getLocation) implements ResourceHolder<SpellHolder>
    {
        public static SpellHolder of(Object o) {
            return ResourceHolder.of(o, SpellHolder::new);
        }
    }

    public record SoundEventHolder(ResourceLocation getLocation) implements ResourceHolder<SoundEventHolder>
    {
        public static SoundEventHolder of(Object o) {
            return ResourceHolder.of(o, SoundEventHolder::new);
        }
    }

    public record AttributeHolder(ResourceLocation getLocation) implements ResourceHolder<AttributeHolder>
    {
        public static AttributeHolder of(Object o) {
            return ResourceHolder.of(o, AttributeHolder::new);
        }
    }
}

