/*
 * Decompiled with CFR 0.152.
 */
package com.squoshi.irons_spells_js.item;

import com.squoshi.irons_spells_js.util.ISSKJSUtils;
import dev.latvian.mods.kubejs.item.custom.HandheldItemBuilder;
import dev.latvian.mods.kubejs.typings.Info;
import io.redspace.ironsspellbooks.item.weapons.StaffItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraftforge.registries.ForgeRegistries;

public class StaffItemBuilderJS
extends HandheldItemBuilder {
    public transient List<AttributeHolder> additionalAttributes = new ArrayList<AttributeHolder>();

    public StaffItemBuilderJS(ResourceLocation i) {
        super(i, 3.0f, -2.4f);
    }

    @Info(value="        Adds an additional attribute to the item. It takes an attribute ID (or just an attribute object), the modifier name, the modifier amount, and the modifier operation.\n        The modifier operation can be either `ADDITION`, `MULTIPLY_TOTAL` or `MULTIPLY_BASE`.\n")
    public StaffItemBuilderJS addAdditionalAttribute(ISSKJSUtils.AttributeHolder attribute, String modifierName, double modifierAmount, AttributeModifier.Operation modifierOperation) {
        this.additionalAttributes.add(new AttributeHolder(attribute.getLocation(), new AttributeModifier(modifierName, modifierAmount, modifierOperation)));
        return this;
    }

    public StaffItem createObject() {
        HashMap<Attribute, AttributeModifier> map = new HashMap<Attribute, AttributeModifier>(Map.of());
        for (AttributeHolder holder : this.additionalAttributes) {
            Attribute attribute = Objects.requireNonNull((Attribute)ForgeRegistries.ATTRIBUTES.getValue(holder.attribute()));
            map.put(attribute, holder.modifier());
        }
        return new StaffItem(this.createItemProperties(), (double)this.attackDamageBaseline, (double)this.speedBaseline, map);
    }

    public record AttributeHolder(ResourceLocation attribute, AttributeModifier modifier) {
    }
}

